Program Notebook;
{ணࠬ 㦨 䠩  "᭮ "}
Uses App, Objects, Menus, Drivers, Views, StdDlg, DOS, Memory, Dialogs;
type

  {ꥪ TWorkWin ᮧ ࠬ筮   ᠬ ஫
    ࠢ ஥   ꥪ⮬ TInterior}
  PWorkWin =^TWorkWin;
  TWorkWin = object (TWindow)
    Constructor Init(Bounds: TRect);
  end;

  {ꥪ TDlgWin ᮧ    롮
  ० ࠡ}
  PDlgWin =^TDlgWin;
  TDlgWin = object (TDialog)
    Procedure HandleEvent(var Event: TEvent); Virtual;
  end;

  {騩 ꥪ 㦨 ७  ࠬ筮 
  TWorkWin.  ᮧ ஫㥬   ﬨ 
  娢 䠩      TDlgWin ࠢ
  ࠡ⮩  ⨬ ﬨ}
  PInterior =^TInterior;
  TInterior = object (TScroller)
    PS: PStringCollection;
    Location: Word;
    Constructor Init(var Bounds: TRect;	HS,VS: PScrollBar);
    Procedure Draw; Virtual;
    Procedure ReadFile;
    Destructor Done; Virtual;
    Procedure HandleEvent(var Event: TEvent); Virtual;
  end;

  {ꥪ-ணࠬ TNotebook ন ࠡ  
   ப }
  TNotebook = object (TApplication)
    Procedure InitStatusLine; Virtual;
    Procedure InitMenuBar; Virtual;
    Procedure HandleEvent(var Event: TEvent); Virtual;
    Procedure FileSave;
    Procedure ChangeDir;
    Procedure DOSCall;
    Procedure FileOpen;
    Procedure Work;
  end;

const
  {  ࠡ稪 ᮡ⨩:}
  cmChDir    = 202; { ⠫}
  cmWork     = 203; {ࠡ }
  cmDOS      = 204; {६   }
  cmCan      = 205; { 襭 ࠡ}
  cmDelete   = 206; {⮦ ⥪ }
  cmSearch   = 207; {᪠ 㦭 }
  cmEdit     = 208; {஢ }
  cmAdd      = 209; { }
  {⢮ ६ 㯭 :}
  WinCom1: TCommandSet = [cmSave,cmWork];
  WinCom2: TCommandSet = [cmOpen];

  LName = 25; 			{  Name}
  LPhone= 11; 			{  Phone}
  LAddr = 40; 			{  Addr}
  LLine = LName+LPhone+LAddr;   { ப}
type
  DataType = record 		{   䠩}
    Name : String[LName]; 	{}
    Phone: String[LPhone]; 	{䮭}
    Addr : String[LAddr] 	{}
  end;
var
  DataFile: file of DataType;   { ६}
  OpFileF : Boolean; 		{ ⮣ 䠩}

{-----------------------------------------
       ꥪ TWorkWin
------------------------------------------}
Constructor TWorkWin.Init(Bounds: TRect);
{  }
var
  HS,VS: PScrollBar; 		{-㪠⥫}
  Interior: PInterior; 		{⥫  ࠢ塞 ⥪⮢ }
begin
  TWindow.Init(Bounds,'',0); 	{    ࠬ}
  GetClipRect(Bounds); 		{砥  BOUNDS न
  				쭮 ᮢ뢠  }
  Bounds.Grow(-1,-1);  		{⠭ ࠧ   ⥪⮬}
  {砥 ⠭  ࠧ   -㪠⥫:}
  VS := StandardScrollBar(sbVertical+sbHandleKeyBoard);
  HS := StandardScrollBar(sbHorizontal+sbHandleKeyBoard);
  { ⥪⮢ :}
  Interior := New(PInterior,Init(Bounds, HS, VS));
  Insert(Interior)              {砥   ᭮ }
end; {TWorkWin.Init}
{-----------------}
Procedure TDlgWin.HandleEvent;
begin
  Inherited HandleEvent(Event);
  if Event.What=evCommand then
    EndModal(Event.Command)
end;
{------------------}
Procedure TNotebook.FileOpen;
{뢠 䠩 }
var
  PF: PFileDialog; {  롮 䠩}
  Control: Word;
  s: PathStr;
begin
  {  ᪮ ꥪ:}
  New(PF, Init('*.dat','롥 㦭 䠩:',
					' 䠩',fdOpenButton,0));
  {  ᫥饣   뢮  ࠭
	 १ ࠡ 짮⥫   頥 
	६   Control:}
  Control := DeskTop^.ExecView(PF);
  {A㥬 १ o:}
  case Control of
    StdDlg.cmFileOpen,cmOk:
      begin         		{짮⥫ 㪠  䠩:}
        PF^.GetFileName(s); 	{s ᮤন  䠩}
      Assign(DataFile,s); { 稭  ப}
      {$I-}
      Reset(DataFile);
      if IOResult <> 0 then
        Rewrite(DataFile);
      OpFileF := IOResult=0;
      {$I+}
      if OpFileF then
        begin
          DisableCommands(WinCom2);
          EnableCommands(WinCom1);
          Work                    {室  ࠡ}
        end
      end;
  end; {case Control}
  Dispose(PF, Done) 		{⮦ }
end; {FileOpen}
{------------------}
Procedure TNotebook.FileSave;
{뢠 䠩 }
begin
  Close(DataFile);
  OpFileF := False;
  EnableCommands(WinCom2); {蠥  䠩}
  DisableCommands(WinCom1) {頥 ࠡ  ࠭}
end; {TNotebook.FileSave}
{------------------}
Procedure TNotebook.ChangeDir;
{ ⥪騩 ⠫}
var
  PD: PChDirDialog; {  ᬥ ⠫/᪠}
  Control: Word;
begin
  New(PD, Init(cdNormal,0)); 		{  }
  Control := DeskTop^.ExecView(PD);	{ᯮ㥬 }
  ChDir(PD^.DirInput^.Data^); 	{⠭
						 ⠫}
  Dispose(PD, Done) 			{塞   }
end; {TNotebook.ChangeDir}
{--------------------}
Procedure TNotebook.DOSCall;
{६ 室  }
const
  txt ='   EXIT  ⢥'+
       '  ਣ襭 ...';
begin
  DoneEvents; 		{ ࠡ稪 ᮡ⨩}
  DoneVideo; 		{  ࠭}
  DoneMemory; 		{  }
  SetMemTop(HeapPtr); 	{᢮ }
  WriteLn(txt); 		{  室}
  SwapVectors; 		{⠭ ⠭ }
  {। ࠢ   :} 
  Exec(GetEnv('COMSPEC'),'');
  {  :}
  SwapVectors; 		{⠭ }
  SetMemTop(HeapEnd); 	{⠭ }
  InitMemory; 		{  }
  InitVideo; 		{  ࠭}
  InitEvents; 		{ ࠡ稪 ᮡ⨩}
  InitSysError; 		{ ࠡ稪 訡}
  Redraw           	{⠭  ࠭}
end; {DOSCall}
{------------------}
Constructor TInterior.Init;
{  ஫}
begin
  TScroller.Init(Bounds, Hs, VS);
  ReadFile;
  GrowMode := gfGrowHiX+gfGrowHiY;
  SetLimit(LLine, PS^.Count)
end;
{-----------------}
Destructor TInterior.Done;
begin
  Dispose(PS,Done);
  Inherited Done
end;
{----------------}
Procedure TInterior.ReadFile;
{⠥ ᮤন 䠩   ᨢ LINES}
var
  k: Integer;
  s: String;
  Data: DataType;
  f: text;
begin
  PS := New(PStringCollection, Init(100,10));
  seek(DataFile,0);
  while not (EOF(DataFile) or LowMemory) do
    begin
    Read(DataFile, data);
    with data do
      begin
        s := Name;
        while Length(s) < LName do
	    s := s+' ';
        s := s+Phone;
        while Length(s) < LName+LPhone do
          s := s+' ';
        s := s+Addr
      end;
    if s<>'' then PS^.Insert(NewStr(S))
  end;
  Location := 0;
end; {ReadFile}
{-------------------}
Procedure TInterior.Draw;
{뢮    ᬮ}
var
  n, 			{ ப ࠭}
  k: Integer; 	        { ப ᨢ}
  B: TDrawBuffer;
  Color: Byte;
  p: PString;
begin
  if Delta.Y>Location then
    Location := Delta.Y;
  if Location>Delta.Y+pred(Size.Y) then
    Location := Delta.Y+pred(Size.Y);
  for n := 0 to pred(Size.Y) do
  {Size.Y - ⢮ ப }
    begin
      k := Delta.Y+n;
      if k=Location then
        Color := GetColor(2)
      else
        Color := GetColor(1);
      MoveChar(B,' ',Color,Size.X);
      if k < pred(PS^.Count) then
        begin
          p := PS^.At(k);
          MoveStr(B, Copy(p^,Delta.X+1,Size.X),Color);
        end;
      WriteLine(0,N,Size.X,1,B)
    end
end; {TInterior.Draw}
{-------------------}
Function Control: Word;
{砥   ᭮  }
const
  X = 1;
  L = 12;
  DX= 13;
  But: array [0..4] of String [13] = {  :} 
  ('~1~ 室 ','~2~  ','~3~ ᪠ ',
  '~4~  ','~5~  ');
  Txt: array [0..3] of String [52] = (
  {ࠢ ⥪:}
  ' - 㤠 , 뤥 梥⮬',
  '᪠ - ᪠ , 稭 㦭묨 㪢',
  ' -   () 뤥 ',
  ' -   ');
var
  R: TRect;
  D: PDlgWin;
  k: Integer;
begin
  R.Assign(7,6,74,15);
  D := New(PDlgWin,Init(R, '롥 த:'));
  with D^ do
    begin
      for k := 0 to 3 do {⠢塞 騩 ⥪}
        begin
          R.Assign(1,1+k,65,2+k);
          Insert(New(PStaticText,Init(R,#3+Txt[k])))
        end;
      for k := 0 to 4 do {⠢塞 :}
        begin
          R.Assign(X+k*DX,6,X+k*DX+L,8);
          Insert(New(PButton,
          Init(R,But[k],cmCan+k,bfNormal)))
        end;
      SelectNext(False); {⨢㥬  }
    end;
  Control := DeskTop^.ExecView(D); {믮塞 }
end; {Control}
{-----------------}
Procedure TInterior.HandleEvent;
Procedure DeleteItem;
{ 㪠  Location  }
var
  D: Integer;
  PStr: PString;
  s: String;
  Data: DataType;
begin
  PStr := PS^.At(Location); 	{砥 ⥪ }
  s := copy(PStr^,1,LName);
  seek(DataFile,0);
  D := -1; 				{D -    䠩}
  repeat         	{ ᪠  ᮢ  Name:} 
    inc(D);
    read(DataFile,Data);
    with Data do while Length(Name) < LName do
      Name := Name+' '
  until Data.Name=s;
  seek(DataFile,pred(FileSize(DataFile)));
  read(DataFile,Data); 	{⠥ ᫥ }
  seek(DataFile,D);
  write(DataFile,Data); {頥    㤠塞}
  seek(DataFile,pred(FileSize(DataFile)));
  truncate(DataFile); 	{塞 ᫥ }
  with PS^ do D := IndexOf(At(Location));
  PS^.AtFree(D); 		{塞 ப  樨}
  Draw                  {塞 }
end; {DeleteItem}
{------------------}
Procedure AddItem(Edit: Boolean);
{   ।   }
const
  y = 1;
  dy= 2;
  L = LName+LPhone+LAddr;
var
  Data: DataType;
  R: TRect;
  InWin: PDialog;
  BName,BPhone,BAddr: PInputLine;
  Control: Word;
  OldCount: Word;
  s: String;
  p: PString;
begin
  Seek(DataFile,FileSize(DataFile)); 	{塞 ᨢ  䠩}
  repeat {  ᥩ}
    if Edit then {⮢ }
      s := '஢:'
    else
      begin
        Str(FileSize(DataFile)+1,s);
        while Length(s) < 3 do
          s := '0'+s;
        s := '  N '+s
      end;
    FillChar(Data,SizeOf(Data),' '); 	{塞 	஡}
    R.Assign(15,5,65,16);
    InWin := New(PDialog, Init(R, s)); 	{ }
    with InWin^ do
      begin  					{ନ㥬 :} 
        R.Assign(2,y+1,2+LName,y+2);
        BName := New(PInputLine, Init(R,LName));
        Insert(BName); 				{ }
        R.Assign(2,y,2+LName,y+1);
        Insert(New(PLabel,
        Init(R, '',BName)));
        R.Assign(2,y+dy+1,2+LPhone,y+dy+2);
        BPhone := New(PInputLine,                         	      	  	Init(R,LPhone));
        Insert(BPhone); 			{ ⥫䮭}
        R.Assign(2,y+dy,2+LPhone,y+dy+1);
        Insert(New(PLabel,
        			Init(R, '䮭',BPhone)));
        R.Assign(2,y+2*dy+1,2+LAddr,y+2*dy+2);
        BAddr := New(PInputLine, Init(R,LAddr));
        Insert(BAddr); 				{ }
        R.Assign(2,y+2*dy,2+LAddr,y+2*dy+1);
        Insert(New(PLabel,
        Init(R, '',BAddr)));
        {⠢塞   :}
        R.Assign(2,y+3*dy+1,12,y+3*dy+3);
        Insert(New(PButton,
        Init(R, '',cmOK,bfDefault)));
        R.Assign(2+20,y+3*dy+1,12+20,y+3*dy+3);
        Insert(New(PButton,
        Init(R, '室',cmCancel,bfNormal)));
        SelectNext(False) 	{⨢㥬  }
      end; { ନ஢ }
    if Edit then with Data do
      begin {⮢ 砫 ⥪:}
        p := PS^.At(Location); {⠥   }
        s := p^;
        Name := copy(s,1,LName);
        Phone:= copy(s,succ(LName),LPhone);
        Addr := copy(s,succ(LName+LPhone),LAddr);
        InWin^.SetData(Data) {⠢塞 ⥪   }
      end;
    Control := DeskTop^.ExecView(InWin); {믮塞 }
    if Control=cmOk then with Data do
      begin
        if Edit then
          DeleteItem; 			{塞  }
        Name := BName^.Data^;
        Phone:= BPhone^.Data^;
        Addr := BAddr^.Data^;
        s[0] := chr(L);
        FillChar(s[1],L,' ');
        move(Name[1],s[1],Length(Name));
        move(Phone[1],s[succ(LName)],Length(Phone));
        move(Addr[1],s[succ(LName+LPhone)],Length(Addr));
        OldCount := PS^.Count; {० ⢮ ᥩ}
        PS^.Insert(NewStr(s)); {塞	 }
        {஢塞 }
        if OldCount <> PS^.Count then
          Write(DataFile,Data) { - 塞  䠩}
      end
  until Edit or (Control=cmCancel);
  Draw
end; {AddItem}
{------------------}
Procedure SearchItem;
{ 㦭 }
Function UpString(s: String): String;
{८ࠧ ப  孨 ॣ}
var
  k: Integer;
begin
  for k := 1 to Length(s) do
  if s[k] in ['a'..'z'] then
    s[k] := chr(ord('A')+ord(s[k])-ord('a'))
  else if s[k] in [''..''] then
    s[k] := chr(ord('')+ord(s[k])-ord(''))
  else if s[k] in [''..''] then
    s[k] := chr(ord('')+ord(s[k])-ord(''));
  UpString := s
end;	{UpString}
var
  InWin: PDialog;
  R: TRect;
  s: String;
  p: PInputLine;
  k: Word;
begin	{SearchItem}
  R.Assign(15,8,65,16);
  InWin := New(PDialog,
  Init(R,' :'));
  with InWin^ do
    begin
      R.Assign(2,2,47,3);
      p := New(PInputLine, Init(R,50));
      Insert(p);
      R.Assign(1,1,40,2);
      Insert(New(PLabel, Init(R,
  				' ࠧ  ᪠:',p)));
      R.Assign(10,5,20,7);
      Insert(New(PButton,  	Init(R,'',cmOk,bfDefault)));
      R.Assign(25,5,35,7);
      Insert(New(PButton,  	Init(R,'室',cmCancel,bfNormal)));
      SelectNext(False)
    end;
  if DeskTop^.ExecView(InWin) = cmCancel then
    exit;
  s := p^.Data^;
  Location := 0;
  while (UpString(s) >=	UpString(PString(PS^.At(Location))^))
  		and (Location < pred(PS^.Count)) do
    inc(Location);
  if (Location < Delta.Y) or
	(Location > Delta.Y+pred(Size.Y)) then
    ScrollTo(Delta.X,Location)
  else
    Draw
end; {SearchItem}
{------------------}
var
  R: TPoint;
label Cls;
begin
  TScroller.HandleEvent(Event);
  case Event.What of
  evCommand:
    case Event.Command of
    cmClose:
    begin
Cls:
    case Control of 	{  
				᭮  }
    cmCan,
    cmCancel: EndModal(cmCancel);
    cmEdit  : AddItem(True);
    cmDelete: DeleteItem;
    cmSearch: SearchItem;
    cmAdd   : AddItem(False);
    end
    end;
    cmZoom: exit;
    end;
  evMouseDown: 				{  饫箪 }
    begin
      MakeLocal(MouseWhere, R); 	{砥  R 
    						न 㪠⥫ }
      Location := Delta.Y+R.Y;
      Draw
    end;
  evKeyDown: 				{   + -}
  case Event.KeyCode of
  kbEsc: goto Cls;
  kbGrayMinus: if Location > Delta.Y then
    begin
      dec(Location);
      Draw
    end;
  kbGrayPlus: if Location < Delta.Y+pred(Size.Y) then
    begin
      inc(Location);
      Draw
    end;
  end
  end
end; {TInterior.HandleEvent}
{------------------}
Procedure TNotebook.Work;
{  묨}
var
  R: TRect;
  PW: PWorkWin;
  Control: Word;
begin
  R.Assign(0,0,80,23);
  PW := New(PWorkWin, Init(R));
  Control := DeskTop^.ExecView(PW);
  Dispose(PW,Done)
end;
{-------------------}
Procedure TNotebook.HandleEvent(var Event: TEvent);
{ࠡ稪 ᮡ⨩ ணࠬ}
begin	{TNotebook.HandleEvent}
  TApplication.HandleEvent(Event); {ࠡ⪠ ⠭ 
						 cmQuit  cmMenu}
  if Event.What = evCommand then
  case Event.Command of
    {ࠡ⪠  :} 
    cmOpen: FileOpen; 	{ 䠩}
    cmSave: FileSave; 	{ 䠩}
    cmChangeDir : ChangeDir; 	{ }
    cmDOSShell : DOSCall; 		{६ 室  }
    cmWork : Work; 		{ࠡ }
  else
    exit      			{ ࠡ뢠 㣨 }
  end;
  ClearEvent(Event) 	{ ᮡ⨥ ᫥ ࠡ⪨}
end; {TNotebook.HandleEvent}
{----------------------}
Procedure TNotebook.InitMenuBar;
{ 孥 }
var
  R: TRect;
begin
  GetExtent(R);
  R.B.Y := succ(R.A.Y); {R - न ப }
  MenuBar := New(PMenuBar, Init(R,
    NewMenu(		{ }
    	{    ।⠢ ᮡ
	 ( ண ஢).  }
  	NewSubMenu('~F~/', hcNoContext,
  	{뢠   }
  	  NewMenu(		{ }
  		NewItem(	{ }
  		'~1~/ ','F3',kbF3,cmOpen,hcNoContext,
  		NewItem(	{ன }
  		'~2~/ ','F2',kbF2,cmSave,hcNoContext,
  		NewItem(	{⨩ }
  		'~3~/  ','',0,cmChangeDir,hcNoContext,
  		NewLine(	{ப-ࠧ⥫}
  		NewItem('~4~/ 맮 ','',0,cmDOSShell,hcNoContext,
  		NewItem('~5~/  ࠡ','Alt-X',
  					kbAltX,cmQuit,hcNoContext,
  	NIL)))))) 		{ 㣨 ⮢ }
      ),
      { ன   }
      NewItem('~W~/ ','',kbF4,cmWork,hcNoContext,
  NIL) { 㣨 ⮢  }
  ))))
end; {TNotebook.InitMenuBar}
{------------------}
Procedure TNotebook.InitStatusLine;
{ନ ப }
var
  R: TRect; {࠭ ப }
begin
  GetExtent(R); {砥  R न ᥣ ࠭}
  R.A.Y := pred(R.B.Y);
  StatusLine := New(PStatusLine,
  Init(R, 				{ ப }
    NewStatusDef(0, $FFFF, 	{⠭  ᨬ 				 ⥪⭮ ࠢ筮 㦡}
    NewStatusKey('~Alt-X~ 室', kbAltX, cmQuit,
    NewStatusKey('~F2~ ', kbF2, cmSave,
    NewStatusKey('~F3~ ', kbF3, cmOpen,
    NewStatusKey('~F4~ ', kbF4, cmWork,
    NewStatusKey('~F10~ ', kbF10, cmMenu,
    NIL))))), 	{ 㣨 }
  NIL) 		{ 㣨 ।}
  ));
  DisableCommands(WinCom1) {頥 㯭 }
end; {TNotebook.InitStatusLine}
{-------------------}
var
  Nbook: TNotebook;
begin
  Nbook.Init;
  Nbook.Run;
  Nbook.Done
end.

