unit mouse;                                                                     { }

interface

uses dos;

function InitMouse:boolean;                                                     { }
function GetMouse(var MouseX,MouseY:word):word;                                 {     
										 }
procedure SetMouse(MouseX, MouseY:word);                                        {   }
procedure SetMouseRange(X1,Y1,X2,Y2:word);                                      {    }

implementation

function InitMouse:boolean;
var
  CPU_Reg : registers;
begin
  CPU_Reg.Ax := 0;
  Intr($33,CPU_Reg);
  InitMouse := CPU_Reg.Ax = $ffff;
end;

function GetMouse(var MouseX,MouseY : word) : word;
var
  CPU_Reg:registers;
begin
  CPU_Reg.Ax := 3;
  Intr($33,CPU_Reg);
  with CPU_Reg do
    begin
      MouseX := Cx;
      MouseY := Dx;
      GetMouse := Bx;
    end;
end;

procedure SetMouse(MouseX, MouseY: word);
var
  CPU_Reg:registers;
begin
  with CPU_Reg do
    begin
      Ax := 4;
      Cx := MouseX;
      Dx := MouseY;
    end;
  intr($33,CPU_Reg);
end;

procedure SetMouseRange(x1,y1,x2,y2: word);
var
  CPU_Reg:registers;
begin
  with CPU_Reg do
    begin
      Ax := 7;
      Cx := x1;
      Dx := x2;
    end;
  intr($33,CPU_Reg);                                                            { 7 -   }
  with CPU_Reg do
    begin
      Ax := 8;
      Cx := y1;
      Dx := y2;
    end;
  intr($33,CPU_Reg);                                                            { 8 -   }
end;

end.