unit pal;                                                                       {  256- }

interface

procedure SetPal(var pal:byte;nbegpal,lenpal:integer);                          { 256- }
procedure GetPal(var pal:byte;nbegpal,lenpal:integer);                          { 256- }
procedure WaitVerticalRetrace;                                                  {    }
procedure BlackPal;                                                             { "" }
procedure FadeOut(p:array of byte);                                             {  }
procedure FadeIn(p:array of byte);                                              {  }

implementation

uses dos;

procedure SetPal(var pal:byte;nbegpal,lenpal:integer);
var
  r:registers;
begin
  r.ax := $1012;
  r.bx := nbegpal;
  r.cx := lenpal;
  r.dx := ofs(pal);
  r.es := seg(pal);
  intr($10,r);
end;

procedure GetPal(var pal:byte;nbegpal,lenpal:integer);
var
  r:registers;
begin
  r.ax := $1017;
  r.bx := nbegpal;
  r.cx := lenpal;
  r.dx := ofs(pal);
  r.es := seg(pal);
  intr($10,r);
end;

procedure WaitVerticalRetrace;
begin
  while (port[$3da] and 8) = 0 do;
end;

procedure BlackPal;
var
  p:array[0..767]of byte;
begin
  FillChar(p,SizeOf(p),0);
  SetPal(p[0],0,256);
end;

procedure FadeIn(p:array of byte);
var
  p1:array[0..767]of byte;
  i,j:integer;
begin
  BlackPal;
  for i := 0 to 63 do
    begin
      for j := 0 to 767 do                                                      {    }
        p1[j] := round(p[j]/63*i);
      WaitVerticalRetrace;
      SetPal(p1[0],0,256);
    end;
end;

procedure FadeOut(p:array of byte);
var
  p1:array[0..767]of byte;
  i,j:integer;
begin
  for i := 0 to 767 do
    p1[i] := p[i];
  for i := 63 downto 0 do
    begin
      for j := 0 to 767 do                                                      {   0}
        p1[j] := round(p[j]/63*i);
      WaitVerticalRetrace;
      SetPal(p1[0],0,256);
    end;
end;

end.