{$N+}
unit timer18;

interface

function Clock : longint;                                                       {,      1/18 }
procedure ResetTime;                                                            {     0}
function GetFPS : single;                                                       {     
										  1    }

implementation

var
  ZeroClock:longint;                                                            {  }
  LastFPSclock:longint;                                                         {-"-   FPS}
  Days:longint;                                                                 { }
  LastClock:longint;                                                            {  }
  NumberFrames:integer;                                                         { }
  FPS:single;                                                                   {   }

function Clock : longint;
var t : longint;
begin
  t := meml[Seg0040:$6c] - ZeroClock;
  if t < LastClock then
    begin                                                                       {  . }
      inc(Days);
    end;
  LastClock := t;
  Clock := t + days*1573040;                                                    {1  - 1573040}
end;

procedure ResetTime;
begin
  ZeroClock := meml[Seg0040:$6c];
  LastFPSclock := 0;
  NumberFrames := 0;
  FPS := 0;
  Days := 0;
  LastClock := 0;
end;

function GetFPS : single;
var
  c : longint;
  e : single;
begin
  inc(NumberFrames);
  c := Clock;
  if (c - LastFPSclock) >= 18 then
    begin                                                                                    {  
											        1 }
      FPS := NumberFrames / (c - LastFPSclock) * 18.2;
      NumberFrames := 0;
      LastFPSclock := c;
    end;
  GetFPS := FPS;
end;

begin
  ResetTime;
end.