unit bmpread;

interface

type
  artype = array[0..0]of byte;
  arptr = ^artype;
  bmFileHeader = record                                                         { }
    Typf:word;                                                                  { "BM"}
    Size:longint;                                                               {   }
    Res1:word;
    Res2:word;
    OfBm:longint;                                                               {    (1078)}
  end;
  bmInfoHeader = record
    Size:longint;                                                               {    (40)}
    Widt:longint;                                                               {  ( )}
    Heig:longint;                                                               {  ( )}
    Plan:word;                                                                  {  (1)}
    BitC:word;                                                                  {  (  ) (8)}
    Comp:longint;                                                               {  (0 - )}
    SizI:longint;                                                               {   }
    XppM:longint;                                                               { }
    YppM:longint;                                                               { }
    NCoL:longint;                                                               { }
    NCoI:longint;                                                               {  }
  end;
  bmHeader = record
    f:bmFileHeader;                                                             { }
    i:bmInfoHeader;                                                             { }
    p:array[0..255,0..3]of byte;                                                { }
  end;
  bmhptr = ^bmHeader;

                                                                                {===[   Bmp-]===}
procedure ReadBMP(image:arptr;                                                  {  }
  xim,yim:word;                                                                 {}
  pal:arptr;                                                                    {}
  filename:string);                                                             { }
                                                                                {===[  Bmp-]===}
procedure ReadBMPheader(header:bmhptr;filename:string);

implementation
{$R-}
procedure ReadBMP(image:arptr; xim,yim:word;pal:arptr; filename:string);
var
  h:bmHeader;
  i:integer;
  bmpfile:file;
  s:longint;
begin
  Assign(bmpfile,filename);
  Reset(bmpfile,1);
  BlockRead(bmpfile,h,SizeOf(h));                                               { }
  for i := 0 to yim-1 do
    begin                                                                       { }
      BlockRead(bmpfile,image^[(yim-i-1)*xim],xim);
      if (xim mod 4) <> 0 then
        BlockRead(bmpfile,s,4 - (xim mod 4));
    end;
  Close(bmpfile);
  for i := 0 to 255 do
    begin                                                                       { }
      pal^[i*3+2] := h.p[i,0] shr 2;                                            {}
      pal^[i*3+1] := h.p[i,1] shr 2;                                            {}
      pal^[i*3+0] := h.p[i,2] shr 2;                                            {}
    end;
end;

procedure ReadBMPheader(header:bmhptr;filename:string);
var
  bmpfile:file;
begin
  Assign(bmpfile,filename);
  Reset(bmpfile,1);
  BlockRead(bmpfile,header^,SizeOf(header^));
  Close(bmpfile);
end;
end.