unit keyboard;                                                                  { }
interface

var
   key : array[0..127]of boolean;                                               {  - /}

procedure SetStandardInt;                                                       {  }

procedure SetMyInt;                                                             {  }

const                                                                           {   }
  KeyUp     = 72;
  KeyDown   = 80;
  KeyLeft   = 75;
  KeyRight  = 77;
  KeyEsc    =  1;
  KeyAltL   = 56;
  KeyAltR   = 86;
  KeyCtrlL  = 29;
  KeyCtrlR  = 85;
  KeyShiftL = 42;
  KeyShiftR = 54;
  KeySpace  = 57;

implementation

uses dos;

var
  ExitSave,p9old:pointer;                                                       {     DOS}
  i : integer;
  E0pressed,MyIntEnable : boolean;                                              {  ; , 
										   }

{$F+}
procedure NewInt; interrupt;                                                    {   }
var
  Button,b : byte;
begin
  inline ($fa);                                                                 {cli}
  Button := Port[$60];
  b := Port[$61];
  Port[$61] := b or  $80;
  Port[$61] := b and $7f;
  if Button = $e0 then
    E0pressed := TRUE                                                           { }
  else
    begin
      if E0pressed then
        begin                                                                   { "" Alt  Ctrl}
          if (Button and $7f) = KeyCtrlL then
            Button := Button + (KeyCtrlR - KeyCtrlL);
          if (Button and $7f) = KeyAltL then
            Button := Button + (KeyAltR - KeyAltL);
        end;
      E0pressed := FALSE;
      if Button < 128 then
        key[Button] := TRUE
      else
        key[Button-128] := FALSE;
    end;
    inline ($fb);                                                               {sti}
    Port[$20] := $20;                                                           {  }
end;

procedure MyExit;                                                               {     DOS}
begin
  ExitProc:=ExitSave;
  SetStandardInt;
end;
{$F-}

procedure SetStandardInt;                                                       {  }
begin
  if MyIntEnable then
    begin
      SetIntVec(9,p9old);
      MyIntEnable := FALSE;
      mem[Seg0040:$17] := mem[Seg0040:$17] and $f0;
      mem[Seg0040:$18] := 0;                                                    { Alt, Ctrl, Shift}
    end;
end;

procedure SetMyInt;                                                             {  }
begin
  if not MyIntEnable then
    begin
      GetIntVec(9,p9old);
      SetIntVec(9,@NewInt);                                                     {  }
      MyIntEnable := TRUE;
      for i := 0 to 127 do
        key[i] := FALSE;
      E0pressed := FALSE;
    end;
end;

begin
  ExitSave:=ExitProc;                                                           {  }
  ExitProc:=@MyExit;
  MyIntEnable := FALSE;
  SetMyInt;
end.