unit sprites1;

interface

uses bmpread,timer18;

const
  Xsize = 20;                                                                   { }
  Ysize = 20;
  TransparentColor = $FF;                                                       { }
  AnimTime = 1;                                                                 {    }

type
  SpriteArrayType =
  array[0..Ysize-1,0..Xsize-1]of byte;                                          {    }
  SpriteAnimArrayType = array[0..3]of SpriteArrayType;
  SpriteType = record
    x,y:word;                                                                   {  }
    dx,dy:integer;                                                              {  }
    Img  : ^SpriteAnimArrayType;                                                {    }
    OldTime : longint;                                                          {  }
    Phase : word;                                                               { }
  end;
  ScreenType = array[0..199,0..319]of byte;                                     { }

var
  Scr:^ScreenType;                                                              {}
  p:array[0..767]of byte;

procedure CreateBackBuffer;                                                     {  }
procedure DestroyBackBuffer;                                                    {  }
procedure BackBufferToScreen;                                                   {   }
procedure CreateScreenBuffer;                                                   {  }
procedure DestroyScreenBuffer;                                                  {  }
procedure ScreenBufferToScreen;                                                 {   }
procedure PutSprite(Sprite:SpriteType);                                         {   }
procedure CreateSprite(s:string; x,y,dx,dy:integer;var Sprite:SpriteType);      {"" }
procedure DestroySprite(Sprite:SpriteType);                                     {"" }
procedure CalcSpritePosition(var Sprite:SpriteType);                            {   }
procedure PutBackground;                                                        {   }

implementation

var
  IsBuffer:boolean;
  IsBackBuffer : boolean;                                                       {  }
  BackBuffer : ^ScreenType;                                                     {  }

procedure CreateBackBuffer;
begin
  if not IsBackBuffer then
    begin
      IsBackBuffer := TRUE;
      GetMem(BackBuffer,64000);
    end;
end;

procedure DestroyBackBuffer;
begin
  if IsBackBuffer then
    begin
      IsBackBuffer := FALSE;
      FreeMem(BackBuffer,64000);
   end;
end;

procedure BackBufferToScreen;
begin
  if IsBackBuffer then
    asm
      push ds
      les di,scr
      lds si,BackBuffer
      mov cx,16000
      db $66
      rep movsw
      pop ds
    end;
end;


procedure CreateScreenBuffer;
begin
  if not IsBuffer then
    begin
      IsBuffer := TRUE;
      GetMem(scr,64000);
    end;
end;

procedure DestroyScreenBuffer;
begin
  if IsBuffer then
    begin
      IsBuffer := FALSE;
      FreeMem(scr,64000);
      scr := ptr(SegA000,0);
    end;
end;

procedure ScreenBufferToScreen;
begin
  if IsBuffer then
    asm
      push ds
      mov es,SegA000
      xor di,di                                                                 {  }
      lds si,scr
      mov cx,16000
      db $66
      rep movsw
      pop ds
    end;
end;


procedure PutSprite(Sprite:SpriteType);
var
  sou,dest:pointer;
begin
  sou := @(Sprite.Img^[Sprite.phase,0,0]);
  dest := @(Scr^[Sprite.Y shr 6,Sprite.X shr 6]);
  asm
        push  ds
        les   di,dest
        lds   si,sou
        mov   dx,Ysize                                                          { dx -    Y }
        mov   ah,TransparentColor
   @l1: mov   cx,Xsize                                                          { cx -    X }
   @l2: lodsb
        cmp   al,ah                                                             {    ,             }
        jz    @l3                                                               {                      }
        stosb                                                                   {                 }
        loop  @l2                                                               {                   }
        jmp near ptr @l4                                                        {  = TransparentColor,}
   @l3: inc   di                                                                {                 }
        loop  @l2                                                               {            }
   @l4: add   di, 320-Xsize                                                     {     }
        dec   dx
        jnz   @l1
        pop   ds
  end;
end;

procedure CreateSprite(s:string;x,y,dx,dy:integer;var Sprite:SpriteType);
var
  f:file;                                                                       {   }
begin
  GetMem(Sprite.Img,sizeof(SpriteAnimArrayType));                               {   }
  Readbmp(@(Sprite.Img^),Xsize,Ysize*4,@p,s);
  Sprite.x := x*64;
  Sprite.y := y*64;                                                             {    }
  Sprite.dx := dx;                                                              {       }
  Sprite.dy := dy;
  Sprite.OldTime := Clock;                                                      { }
  Sprite.Phase := random(4);                                                    {  }
end;

procedure DestroySprite(Sprite:SpriteType);
begin
  FreeMem(Sprite.Img,sizeof(SpriteAnimArrayType));                              {   }
end;

procedure CalcSpritePosition(var Sprite:SpriteType);
var
  NewTime:longint;
begin
  with Sprite do
    begin
      if (x + Xsize*64 + dx) >= 319*64 then
         dx := -dx;                                                             {  ,}
      if (x + dx) <= 0 then
         dx := -dx;                                                             { }
      if (y + Ysize*64 + dy) >= 199*64 then
         dy := -dy;                                                             {  }
      if (y + dy) <= 0 then
         dy := -dy;
      x := x+dx;                                                                {      }
      y := y+dy;                                                                {   }
      NewTime := Clock;
      if NewTime >= (OldTime+AnimTime) then                                     {  }
        begin
          Phase := (Phase + (NewTime - OldTime) div AnimTime) and 3;
          OldTime := OldTime + ((NewTime - OldTime) div AnimTime)*AnimTime;
        end;
    end;
end;


procedure PutBackground;                                                        {   }
var
  i,j:word;                                                                     { }
begin
  if IsBackBuffer then
    for j := 0 to 199 do
      for i := 0 to 319 do
        BackBuffer^[j,i] := $ff
  else
    for j := 0 to 199 do
      for i := 0 to 319 do
        Scr^[j,i] := $ff;
end;


begin
  scr := ptr(SegA000,0);
  IsBuffer := FALSE;
  IsBackBuffer := FALSE;
end.