unit text;

interface

uses sprites;

procedure SetTextParm(color,bkcolor,typetext:byte);                             {   }
procedure GetTextParm(var color,bkcolor,typetext:byte);                         {  }
procedure PutText(x,y:word;text:string);                                        {    x,y
										(  )}
procedure PutChar(x,y:word;chr:char);                                           {    x,y
										(  )}

implementation

uses dos;

type
  FTType = array[0..255,0..7]of byte;                                           { }

const
   Colors : array[0..15]of byte =
           (  0,  2, 20, 22,160,162,172,182,
            109,111,125,127,237,239,253,255);                                   {,   0-15}
var
   FontTable:^FTType;                                                           { }
   Color1,bkColor1:byte;                                                        {     }
   Color2,bkColor2:byte;                                                        {      
										 }
   TextType:byte;                                                               {  (  )}

procedure SetTextParm(color,bkcolor,typetext:byte);
begin
  Color1 := color;
  bkColor1 := bkcolor;
  TextType := typetext;
  Color2 := Colors[Color1];
  bkColor2 := Colors[bkColor1];
end;

procedure GetTextParm(var color,bkcolor,typetext:byte);
begin
  color := Color1;
  bkcolor := bkColor1;
  typetext := TextType;
end;

procedure PutText(x,y:word;text:string);
var
   i:word;
begin
  if(byte(text[0])>0)then
    for i := 1 to byte(text[0]) do
      putchar(x+8*(i-1),y,text[i])
end;

procedure PutPixel(x,y:word;c:byte);                                            { }
begin
  scr^[y,x] := c;
end;

function getpixel(x,y:word):byte;                                               {  }
begin
  getpixel := scr^[y,x];
end;

procedure putchar(x,y:word;chr:char);
var
  i,j,k,l:word;
  cc,bb:byte;
begin
  l := byte(chr);
  case TextType of
    0:for i := 0 to 7 do                                                        { }
        for j := 0 to 7 do
          if (FontTable^[l,i] and (1 shl (7-j)) <> 0) then
            putpixel(x+j,y+i,Color2);
    1: for i := 0 to 7 do                                                       { }
        for j := 0 to 7 do
          if (FontTable^[l,i] and (1 shl (7-j)) <> 0) then
            putpixel(x+j,y+i,Color2)
          else
            putpixel(x+j,y+i,bkColor2);
  end;
end;

var
  r:registers;

begin                                                                           { -   
										 }
  r.ax := $1130;
  r.bh := 3;
  intr($10,r);
  FontTable := ptr(r.es,r.bp);
  Color1   := 15;                                                               {   }
  bkColor1 :=  0;
  TextType :=  1;
  Color2   := Colors[Color1];
  bkColor2 := Colors[bkColor1];
end.