unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Serializer, StdCtrls, ExtCtrls;

type
  TForm1 = class(TForm)
    Button1: TButton;
    Memo1: TMemo;
    Button2: TButton;
    Button3: TButton;
    procedure Button1Click(Sender: TObject);
    procedure Button2Click(Sender: TObject);
    procedure Button3Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

{ ###   #################################################### }

type
  TMyObject = class(TInterfacedObject, ISerializable)
  public
     Int: integer;
     Line: string;
     constructor Create;
     procedure Serialize(Context: ISerializer);
     procedure Deserialize(Context: ISerializer);
  end;

constructor TMyObject.Create;
begin
  _AddRef; //    -     
end;

//  
procedure TMyObject.Serialize(Context: ISerializer);
begin
  Context.SerializeString(Line);
  Context.SerializeData(Int, sizeof(Int));
end;

//   -        , 
//   !
procedure TMyObject.Deserialize(Context: ISerializer);
begin
  Line := Context.DeserializeString;
  //      
  Context.DeserializeData(Int);
  //    ,     2 
  // Context.DeserializeData(Int, sizeof(Int));
  //     -   ESerializationException
end;

procedure TForm1.Button1Click(Sender: TObject);
var stream: TStream;
    Obj: TMyObject;
    newObj: TMyObject;
begin
  Memo1.Lines.Clear;

  stream := TMemoryStream.Create; //   ,     

  //  
  Obj := TMyObject.Create;
  Obj.Int := 44;
  Obj.Line := 'test';

  //    
  SerializeObject(Obj, stream);
    //           
    //       SerializeObject(Obj, stream, true);
    //        ,     
    //        ,     :
    //       SerializeObject(Obj, TFileStream.Create('myfile', fmCreate), true);
    //         



  Obj._Release;  //      Free
                 //     =(
                 //         

  stream.Position := 0; //   

  // ,     
  // ,      
  //     Deserialize(Context)
  newObj := DeserializeObject(TMyObject, stream) as TMyObject;

  Memo1.Lines.Add(' :');

  Memo1.Lines.Add(IntToStr(newObj.Int));
  Memo1.Lines.Add(newObj.Line);
  
  newObj._Release;
   
  stream.Free;
end;

{ ###     ######################################## }

type
  TMyListNode = class(TInterfacedObject, ISerializable)
  private
    fNext: TMyListNode;
    fLine: string;
  public
    constructor Create(const Line: string; Tail: TMyListNode = nil);
    destructor Destroy; override;
    procedure Serialize(Context: ISerializer);
    procedure Deserialize(Context: ISerializer);
    property Next: TMyListNode read fNext write fNext;
    property Line: string read fLine write fLine;
  end;

constructor TMyListNode.Create(const Line: string; Tail: TMyListNode = nil);
begin
  _AddRef;
  Self.fLine := Line;
  Self.fNext := Tail;
end;

destructor TMyListNode.Destroy;
begin
  if Next <> nil then  
     Next._Release;
  inherited;
end;

procedure TMyListNode.Serialize(Context: ISerializer);
begin
  Context.SerializeString(fLine);
  Context.SerializeObject(fNext); // ,    nil-
end;

procedure TMyListNode.Deserialize(Context: ISerializer);
begin
  fLine := Context.DeserializeString;
  fNext := Context.DeserializeObject(TMyListNode) as TMyListNode;
end;

procedure TForm1.Button2Click(Sender: TObject);
var stream: TMemoryStream;
    list: TMyListNode;
    newList: TMyListNode;

    procedure PrintList(list: TMyListNode);
    begin
      if list <> nil then begin
          Memo1.Lines.Add(list.Line);
          PrintList(list.Next);
      end;
    end;


begin
  Memo1.Lines.Clear;

  stream := TMemoryStream.Create;

//  
  list := TMyListNode.Create('first line',
    TMyListNode.Create('second line',
    TMyListNode.Create('third line',
    TMyListNode.Create('fourth line'))));

  Memo1.Lines.Add(' :');  

  PrintList(list);

//   
  SerializeObject(list, stream);
  list._Release;

  stream.Position := 0;

//  
  newList := DeserializeObject(TMyListNode, stream) as TMyListNode;

  Memo1.Lines.Add(' :');
  
  PrintList(newList);
  newList._Release;

  stream.Free;
end;

{ ###   ##################################################### }

procedure TForm1.Button3Click(Sender: TObject);
var stream: TMemoryStream;
    list: TMyListNode;
    lastNode: TMyListNode;
    newList: TMyListNode;

    procedure PrintList(list: TMyListNode; CallCount: integer = 0);
    begin
      if list <> nil then begin
          if CallCount < 10 then begin
              Memo1.Lines.Add(list.Line);
              PrintList(list.Next, CallCount + 1);
          end else begin
              Memo1.Lines.Add('... cycle.... ');
          end;
      end;
    end;


begin
  Memo1.Lines.Clear;

  stream := TMemoryStream.Create;

//   
  lastNode := TMyListNode.Create('fifth line');
  
  list := TMyListNode.Create('first line',
    TMyListNode.Create('second line',
    TMyListNode.Create('third line',
    TMyListNode.Create('fourth line', lastNode))));

  lastNode.Next := list;

  Memo1.Lines.Add(' :');

  PrintList(list);

//   
  SerializeObject(list, stream);
  list._Release;

  stream.Position := 0;

//  
  newList := DeserializeObject(TMyListNode, stream) as TMyListNode;

  Memo1.Lines.Add(' :');

  PrintList(newList);
  newList._Release;

  stream.Free;
end;



end.
