{

  MMTimer.pas - Mutimedia Timer Support
  By m.d./XDS, 2004

}

unit MMTimer;

interface

uses
  Windows, SysUtils, Classes;

type
  EMMTimerError = class(Exception);

type
  TMMTimer = class(TObject)
  private
    FPeriod,
    FId: UINT;
    FOnTick: TNotifyEvent;
  public
    constructor Create(Period: Cardinal; OnTick: TNotifyEvent);
    destructor Destroy; override;
  end;

implementation

uses
  MMSystem;

procedure TimeProc(uID, uMsg: UINT; dwUser, dw1, dw2: DWORD); stdcall;
begin
  with TMMTimer(dwUser) do
    if Assigned(FOnTick) then FOnTick(TMMTimer(dwUser));
end;

constructor TMMTimer.Create(Period: Cardinal; OnTick: TNotifyEvent);
begin
  inherited Create;
  if (Period <> 0) and (timeBeginPeriod(Period) = TIMERR_NOERROR) then
    begin
      FPeriod := Period;
      FOnTick := OnTick;
      FId := timeSetEvent(Period, Period, TimeProc, Cardinal(Self), TIME_PERIODIC);
      if FId <> 0 then Exit;
    end;
  FPeriod := 0;
  raise EMMTimerError.Create('Period value out of supported range');
end;

destructor TMMTimer.Destroy;
begin
  if FPeriod <> 0 then
    begin
      timeEndPeriod(FPeriod);
      if FId <> 0 then timeKillEvent(FId);
    end;
  inherited Destroy;
end;

end.
