unit Main;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  MMTimer, StdCtrls, ExtCtrls;

type
  TMainForm = class(TForm)
    lbSpeed: TLabel;
    tmSpeed: TTimer;
    btExit: TButton;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure tmSpeedTimer(Sender: TObject);
    procedure btExitClick(Sender: TObject);
  private
    { Private declarations }
    Timer: TMMTimer;
    n: Integer;
    procedure TimerTick(Sender: TObject);
  public
    { Public declarations }
  end;

var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FormCreate(Sender: TObject);
begin
  Timer := TMMTimer.Create(10, TimerTick);
end;

procedure TMainForm.FormDestroy(Sender: TObject);
begin
  Timer.Free;
end;

procedure TMainForm.TimerTick(Sender: TObject);
begin
  Inc(n);
end;

procedure TMainForm.tmSpeedTimer(Sender: TObject);
begin
  lbSpeed.Caption := Format('%d tick(s) per second', [n]);
  n := 0;
end;

procedure TMainForm.btExitClick(Sender: TObject);
begin
  Close;
end;

end.
