unit BlindCoder;

interface

uses
  SysUtils, Classes, Graphics;


function WriteToBitmap(Bitmap: TBitmap; Data: TStream; Count: cardinal): cardinal;
function ReadFromBitmap(Bitmap: TBitmap; Strm: TStream; Count: cardinal): cardinal;

implementation

function WriteToBitmap(Bitmap: TBitmap; Data: TStream; Count: cardinal): cardinal;
  type TPixel = packed record b1, b2, b3, b4: byte; end;
       PPixel = ^TPixel;
  var Pixel: PPixel;
      NeedByte: boolean;
      NextByte: byte;
      h,w,i,j: integer;
  begin
    Bitmap.PixelFormat:=pf32bit;
    h:=Bitmap.Height;
    w:=Bitmap.Width;
    if Count = 0 then begin
        Result:=h * w div 2;
    end else begin
        Result:=0;
        NeedByte:=true;
        for i:=0 to h-1 do begin
            Pixel:=PPixel(Bitmap.ScanLine[i]);
            for j:=0 to w-1 do begin
                if NeedByte then begin
                    if Result = Count then Exit;
                    Data.ReadBuffer(NextByte,1);
                    with Pixel^ do begin
                        if boolean(NextByte and 1) then b1:=b1 or 1 else b1:=b1 and $FE;
                        if boolean(NextByte and 2) then b2:=b2 or 1 else b2:=b2 and $FE;
                        if boolean(NextByte and 4) then b3:=b3 or 1 else b3:=b3 and $FE;
                        if boolean(NextByte and 8) then b4:=b4 or 1 else b4:=b4 and $FE;
                    end;
                    NeedByte:=false;
                end else begin
                    with Pixel^ do begin
                        if boolean(NextByte and 16) then b1:=b1 or 1 else b1:=b1 and $FE;
                        if boolean(NextByte and 32) then b2:=b2 or 1 else b2:=b2 and $FE;
                        if boolean(NextByte and 64) then b3:=b3 or 1 else b3:=b3 and $FE;
                        if boolean(NextByte and 128) then b4:=b4 or 1 else b4:=b4 and $FE;
                    end;
                    NeedByte:=true;
                    inc(Result);
                end;
                inc(Pixel);
            end;
        end;
    end;
  end;

function ReadFromBitmap(Bitmap: TBitmap; Strm: TStream; Count: cardinal): cardinal;
  type TPixel = packed record b1, b2, b3, b4: byte; end;
       PPixel = ^TPixel;
  var Pixel: PPixel;
      NewByte: boolean;
      NextByte: byte;
      h,w,i,j: integer;
  begin
    Bitmap.PixelFormat:=pf32bit;
    h:=Bitmap.Height;
    w:=Bitmap.Width;
    if Count = 0 then begin
        Result:=h * w div 2;
    end else begin
        Result:=0;
        NewByte:=true;
        NextByte:=0;
        for i:=0 to h-1 do begin
            Pixel:=PPixel(Bitmap.ScanLine[i]);
            for j:=0 to w-1 do begin
                if NewByte then begin
                    if Result = Count then Exit;
                    with Pixel^ do begin
                        if boolean(b1 and 1) then NextByte:=NextByte or 1;
                        if boolean(b2 and 1) then NextByte:=NextByte or 2;
                        if boolean(b3 and 1) then NextByte:=NextByte or 4;
                        if boolean(b4 and 1) then NextByte:=NextByte or 8;
                    end;
                    NewByte:=false;
                end else begin
                    with Pixel^ do begin
                        if boolean(b1 and 1) then NextByte:=NextByte or 16;
                        if boolean(b2 and 1) then NextByte:=NextByte or 32;
                        if boolean(b3 and 1) then NextByte:=NextByte or 64;
                        if boolean(b4 and 1) then NextByte:=NextByte or 128;
                    end;
                    Strm.WriteBuffer(NextByte,1);
                    NextByte:=0;
                    NewByte:=true;
                    inc(Result);
                end;
                inc(Pixel);
            end;
        end;
    end;
  end;

end.
