unit MainUnit;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, jpeg, ExtCtrls, BlindCoder, Menus, ExtDlgs;

type
  TfrmBlinder = class(TForm)
    Image1: TImage;
    Memo1: TMemo;
    MainMenu1: TMainMenu;
    Encode1: TMenuItem;
    Decode1: TMenuItem;
    LoadImage1: TMenuItem;
    SaveImage1: TMenuItem;
    OpenPictureDialog1: TOpenPictureDialog;
    SavePictureDialog1: TSavePictureDialog;
    Splitter1: TSplitter;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure Encode1Click(Sender: TObject);
    procedure Decode1Click(Sender: TObject);
    procedure LoadImage1Click(Sender: TObject);
    procedure SaveImage1Click(Sender: TObject);
  private
    bmp: TBitmap;
  public
    { Public declarations }
  end;

var
  frmBlinder: TfrmBlinder;

implementation

{$R *.dfm}

procedure TfrmBlinder.FormCreate(Sender: TObject);
  begin
    bmp:=TBitmap.Create;
    bmp.Assign(Image1.Picture.Graphic);
    Memo1.MaxLength:=WriteToBitmap(bmp,nil,0);
  end;

procedure TfrmBlinder.FormDestroy(Sender: TObject);
  begin
    bmp.Free;
  end;

procedure TfrmBlinder.Encode1Click(Sender: TObject);
  var Strm: TStream;
      Count: integer;
  begin
    Strm:=TMemoryStream.Create;
    Memo1.Lines.SaveToStream(Strm);
    Count:=Strm.Size;
    Strm.Position:=0;
    try
      WriteToBitmap(bmp,Strm,Count);
    finally
      Strm.Free;
      Image1.Picture.Assign(bmp);
    end;
    ShowMessage('Encoding Complete!');
  end;

procedure TfrmBlinder.Decode1Click(Sender: TObject);
  var Strm: TStream;
  begin
    Strm:=TMemoryStream.Create;
    try
      ReadFromBitmap(bmp,Strm,MaxInt);
      Strm.Position:=0;
      Memo1.Lines.LoadFromStream(Strm);
    finally
      Strm.Free;
    end;
    ShowMessage('Decoding complete!');
  end;

procedure TfrmBlinder.LoadImage1Click(Sender: TObject);
  begin
    if OpenPictureDialog1.Execute then begin
        Image1.Picture.LoadFromFile(OpenPictureDialog1.FileName);
        bmp.Assign(Image1.Picture.Graphic);
        Memo1.MaxLength:=WriteToBitmap(bmp,nil,0);
    end;
  end;

procedure TfrmBlinder.SaveImage1Click(Sender: TObject);
  begin
    if SavePictureDialog1.Execute then begin
        bmp.SaveToFile(SavePictureDialog1.FileName);
    end;
  end;

end.
