unit Main;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Pipes;

type
  TForm1 = class(TForm)
    Memo1: TMemo;
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
  private
    PipeCom: TPipeCommunication;
    procedure LineRecieved(sender: TPipeCommunication; const line: string);
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.dfm}

procedure TForm1.FormCreate(Sender: TObject);
var now: TDateTime;
begin
    PipeCom := TPipeCommunication.Create('samplepipe');
    if PipeCom.IsServer then begin
        Memo1.Lines.Add('Server mode enabled');
        PipeCom.OnStringRecieved := LineRecieved;
    end else begin
        now := GetTime();
    //   
        PipeCom.SendString('Attempting to start program.');
        PipeCom.SendString('Server detected at ' + TimeToStr(now));
        PipeCom.SendString('that''s all');
        PipeCom.Flush;
    //  
        FreeAndNil(PipeCom);
    end;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
    FreeAndNil(PipeCom);
end;

procedure TForm1.LineRecieved(sender: TPipeCommunication; const line: string);
begin
    Memo1.Lines.Add(line);
end;

end.
