unit Unit3;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FastBMP, FastFX, FastRGB, Fast256, FastIMG;

type
  TForm3 = class(TForm)
    sRed: TScrollBar;
    sBlue: TScrollBar;
    sGreen: TScrollBar;
    sContrast: TScrollBar;
    sLightness: TScrollBar;
    sSaturation: TScrollBar;
    Label1: TLabel;
    Button1: TButton;
    procedure Button1Click(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure sRedScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form3: TForm3;
  Buf: TFastRGB;
  CBuf: TFColorEntryArray;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm3.Button1Click(Sender: TObject);
var
x: Integer;
begin
  sRed.Position:=0;
  sBlue.Position:=0;
  sGreen.Position:=0;
  sContrast.Position:=0;
  sLightness.Position:=0;
  sSaturation.Position:=255;
  sRedScroll(Sender,scEndScroll,x);
end;

procedure TForm3.FormShow(Sender: TObject);
begin
  sRed.Position:=0;
  sBlue.Position:=0;
  sGreen.Position:=0;
  sContrast.Position:=0;
  sLightness.Position:=0;
  sSaturation.Position:=255;
  case Form2.FastIMG1.DataType of
    dtFastBMP: Buf:=TFastBMP.Create;
    dtFast256: Buf:=TFast256.Create;
  end;
  Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
  if Buf is TFast256 then
  begin
    CBuf:=TFast256(Form2.FastIMG1.Bmp).Colors^;
    TFast256(Buf).Colors^:=CBuf;
  end;
  CopyMemory(Buf.Bits,Form2.FastIMG1.Bmp.Bits,Buf.Size);
end;

procedure TForm3.sRedScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  if Buf is TFast256 then
  begin
    TFast256(Form2.FastIMG1.Bmp).Colors^:=CBuf;
    if(sRed.Position<>0)or(sBlue.Position<>0)or(sGreen.Position<>0)then
      TFast256(Form2.FastIMG1.Bmp).RGB(sRed.Position,sBlue.Position,sGreen.Position);
    if sLightness.Position<>0 then
      TFast256(Form2.FastIMG1.Bmp).Lightness(sLightness.Position);
    if sContrast.Position<>0 then
      TFast256(Form2.FastIMG1.Bmp).Contrast(sContrast.Position);
    if sSaturation.Position<>255 then
      TFast256(Form2.FastIMG1.Bmp).Saturation(sSaturation.Position);
  end else
  begin
    CopyMemory(Form2.FastIMG1.Bmp.Bits,Buf.Bits,Buf.Size);
    if(sRed.Position<>0)or(sBlue.Position<>0)or(sGreen.Position<>0)then
      RGB(Form2.FastIMG1.Bmp,sRed.Position,sBlue.Position,sGreen.Position);
    if sLightness.Position<>0 then
      Lightness(Form2.FastIMG1.Bmp,sLightness.Position);
    if sContrast.Position<>0 then
      Contrast(Form2.FastIMG1.Bmp,sContrast.Position);
    if sSaturation.Position<>255 then
      Saturation(Form2.FastIMG1.Bmp,sSaturation.Position);
  end;
  Form2.FastIMG1.Refresh;
end;

procedure TForm3.FormHide(Sender: TObject);
begin
  CopyMemory(Buf.Bits,Buf.Bits,Buf.Size);
  Buf.Free;
end;

end.
