unit Unit6;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FastRGB, FastFX, FastBMP, Fast256, FastIMG;

type
  TForm6 = class(TForm)
    ScrollBar1: TScrollBar;
    Label1: TLabel;
    rSharpen: TRadioButton;
    rBlur: TRadioButton;
    rGaussian: TRadioButton;
    rMosaic: TRadioButton;
    rHShift: TRadioButton;
    rMono: TRadioButton;
    rSpray: TRadioButton;
    rVShift: TRadioButton;
    rColor: TRadioButton;
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormShow(Sender: TObject);
    procedure rSharpenClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Process;
  end;

var
  Form6: TForm6;
  Buf: TFastRGB;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm6.Process;
var
Amount:Integer;
begin
  Amount:=ScrollBar1.Position;
  CopyMemory(Form2.FastIMG1.Bmp.Bits,Buf.Bits,Buf.Size);

  if rSharpen.Checked then
    Sharpen(Form2.FastIMG1.Bmp,Amount)
  else if rMosaic.Checked then
    Mosaic(Form2.FastIMG1.Bmp,Amount,Amount)
  else if rSpray.Checked then
    Spray(Buf,Form2.FastIMG1.Bmp,Amount)
  else if rBlur.Checked then
    SplitBlur(Form2.FastIMG1.Bmp,Amount)
  else if rHShift.Checked then
    HShift(Form2.FastIMG1.Bmp,Amount)
  else if rVShift.Checked then
    VShift(Form2.FastIMG1.Bmp,Amount)
  else if rGaussian.Checked then
    GaussianBlur(Form2.FastIMG1.Bmp,TrimInt(Amount,0,10))
  else if rMono.Checked then
    AddMonoNoise(Form2.FastIMG1.Bmp,Amount)
  else if rColor.Checked then
    AddColorNoise(Form2.FastIMG1.Bmp,Amount);
  Form2.FastIMG1.Refresh;
end;

procedure TForm6.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  Process;
end;

procedure TForm6.FormShow(Sender: TObject);
begin
  ScrollBar1.Max:=Form2.FastIMG1.Bmp.Width;
  case Form2.FastIMG1.DataType of
    dtFastBMP: Buf:=TFastBMP.Create;
    dtFast256: Buf:=TFast256.Create;
  end;
  Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
  if Buf is TFast256 then TFast256(Buf).Colors^:=TFast256(Form2.FastIMG1.Bmp).Colors^;
  CopyMemory(Buf.Bits,Form2.FastIMG1.Bmp.Bits,Buf.Size);
end;

procedure TForm6.rSharpenClick(Sender: TObject);
begin
  Process;
end;

procedure TForm6.FormHide(Sender: TObject);
begin
  CopyMemory(Buf.Bits,Buf.Bits,Buf.Size);
  if Buf is TFast256 then TFast256(Form2.FastIMG1.Bmp).Colors^:=TFast256(Buf).Colors^;
  Buf.Free;
end;

end.
