unit Unit9;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, ExtCtrls, Fast256;

type
  TForm9 = class(TForm)
    ScrollBar1: TScrollBar;
    Label1: TLabel;
    CheckBox1: TCheckBox;
    Timer1: TTimer;
    Button1: TButton;
    procedure CheckBox1Click(Sender: TObject);
    procedure ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure Timer1Timer(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form9: TForm9;
  CBuf: TFColorEntryArray;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm9.CheckBox1Click(Sender: TObject);
begin
  Timer1.Enabled:=CheckBox1.Checked;
end;

procedure TForm9.ScrollBar1Scroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  if Form2.FastIMG1.Bmp is TFast256 then
  begin
    TFast256(Form2.FastIMG1.Bmp).Colors^:=CBuf;
    TFast256(Form2.FastIMG1.Bmp).ShiftColors(ScrollPos);
    Form2.FastIMG1.Refresh;
  end;
end;

procedure TForm9.Timer1Timer(Sender: TObject);
begin
  if Form2.FastIMG1.Bmp is TFast256 then
  begin
    TFast256(Form2.FastIMG1.Bmp).ShiftColors(ScrollBar1.Position);
    Form2.FastIMG1.Refresh;
  end;
end;

procedure TForm9.FormShow(Sender: TObject);
begin
  if Form2.FastIMG1.Bmp is TFast256 then
  CBuf:=TFast256(Form2.FastIMG1.Bmp).Colors^;
end;

procedure TForm9.Button1Click(Sender: TObject);
var
w,h,
x,y,i: Integer;
v: Single;
begin
  if Form2.FastIMG1.Bmp is TFast256 then
  begin
    w:=Form2.FastIMG1.Bmp.Width;
    h:=Form2.FastIMG1.Bmp.Height; i:=0;
    for y:=0 to h-1 do
    begin
      for x:=0 to w-1 do
      begin
        v:=Sin(2*Pi*x/w)*Sin(2*Pi*y/h);
        v:=((v+1)/2)*255;
        PBytes(Form2.FastIMG1.Bmp.Bits)[i]:=Round(v);
        Inc(i);
      end;
      Inc(i,Form2.FastIMG1.Bmp.Gap);
    end;
    Form2.FastIMG1.Refresh;
  end;
end;

end.
