program lights;

uses
  Windows, Messages, FastBMP, FastFX, FastRGB;

var
  //effects variables
  x,y,
  bx,by,
  gx,gy,
  rx,ry,
  hDC:    Integer;
  r,g,b:  Single;
  Bmp:    TFastBMP;
  //system variables
  Handle: Integer;
  Msg:    TMSG;
  GotMsg: Boolean;

//window function
function Main(hWnd,uMsg,wParam,lParam:Longint):Longint; stdcall;
var
ps: TPaintStruct;
begin
  case uMsg of
  WM_DESTROY:
    begin
      Bmp.Free;
      ReleaseDC(Handle,hDC);
      ExitProcess(hInstance);
    end;
  WM_ERASEBKGND:;
  WM_PAINT:
    begin
      BeginPaint(hWnd,ps);
      Bmp.Draw(ps.hDC,0,0);
      EndPaint(hWnd,ps);
    end;
  end;
  Result:=DefWindowProc(hWnd,uMsg,wParam,lParam);
end;

//paint lights
procedure UpdateFrame;
begin
  r:=r+0.2; g:=g+0.2; b:=b+0.2;
  rx:=Round(120+Sin(r/3)*100);
  ry:=Round(120+Sin(r/2)*100);
  gx:=Round(120+Sin(g/5)*100);
  gy:=Round(120+Sin(g/3)*100);
  bx:=Round(120+Sin(b/4)*100);
  by:=Round(120+Sin(b/2)*100);

  for y:=0 to 15 do
  for x:=0 to 15 do
  begin
    Bmp.Pixels[ry+y,rx+x].r:=255;
    Bmp.Pixels[gy+y,gx+x].g:=255;
    Bmp.Pixels[by+y,bx+x].b:=255;
  end;

  //try different combinations of filters
  //the effect varies a lot, play around!!!
  SplitBlur(Bmp,3);
  Lightness(Bmp,-10);
  //Contrast(Bmp,100);
  //WaveWrap(Bmp,Bmp,35,50,100);
  //Wave(Bmp,Bmp,ry,gy,by);
  //RotateWrap(Bmp,Bmp,128,128,20);
  RotateWrap(Bmp,Bmp,ry,gx,by);
  //AddMonoNoise(Bmp,255);

  Bmp.Draw(hDC,0,0);
end;

begin
  //make a TFastBMP
  Bmp:=TFastBMP.Create;
  Bmp.SetSize(256,256);

  Handle:=CreateWindow('#32770','TFastBMP demo - Lights',WS_VISIBLE or WS_SYSMENU,0,0,262,281,0,0,hInstance,nil);
  SetWindowLong(Handle,GWL_WNDPROC,Longint(@Main));
  hDC:=GetDC(Handle);

  while Msg.Message<>WM_QUIT do
  begin
    GotMsg:=PeekMessage(Msg,0,0,0,PM_REMOVE);
    if GotMsg then DispatchMessage(Msg) else UpdateFrame;
  end;

end.
