unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  Menus, FastBMP, FastRGB, FastFX, Fast256, FastDraw;

type
  TForm1 = class(TForm)
    MainMenu1: TMainMenu;
    File1: TMenuItem;
    LoadFromFile1: TMenuItem;
    SaveToFile1: TMenuItem;
    Revert1: TMenuItem;
    N1: TMenuItem;
    Exit1: TMenuItem;
    DrawStyle1: TMenuItem;
    Draw1: TMenuItem;
    Center1: TMenuItem;
    Stretch1: TMenuItem;
    Resize1: TMenuItem;
    Tile1: TMenuItem;
    N2: TMenuItem;
    SmoothResizing1: TMenuItem;
    OpenDialog1: TOpenDialog;
    SaveDialog1: TSaveDialog;
    DataType1: TMenuItem;
    TFastBMP1: TMenuItem;
    TFast2561: TMenuItem;
    cmCut1: TMenuItem;
    cmDither1: TMenuItem;
    cmGray1: TMenuItem;
    FastFX1: TMenuItem;
    Attributes1: TMenuItem;
    Rotation1: TMenuItem;
    AlphaBlending1: TMenuItem;
    WaveEffects1: TMenuItem;
    OtherFilters1: TMenuItem;
    N3: TMenuItem;
    Invert1: TMenuItem;
    Emboss1: TMenuItem;
    Gradient1: TMenuItem;
    Flip1: TMenuItem;
    Flop1: TMenuItem;
    FishEye1: TMenuItem;
    Twirl1: TMenuItem;
    Grayscale1: TMenuItem;
    N4: TMenuItem;
    Colors1: TMenuItem;
    CycleColors1: TMenuItem;
    procedure LoadFromFile1Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure SaveToFile1Click(Sender: TObject);
    procedure Revert1Click(Sender: TObject);
    procedure Draw1Click(Sender: TObject);
    procedure Center1Click(Sender: TObject);
    procedure Stretch1Click(Sender: TObject);
    procedure Resize1Click(Sender: TObject);
    procedure Tile1Click(Sender: TObject);
    procedure SmoothResizing1Click(Sender: TObject);
    procedure Exit1Click(Sender: TObject);
    procedure TFastBMP1Click(Sender: TObject);
    procedure cmCut1Click(Sender: TObject);
    procedure cmDither1Click(Sender: TObject);
    procedure cmGray1Click(Sender: TObject);
    procedure Attributes1Click(Sender: TObject);
    procedure WaveEffects1Click(Sender: TObject);
    procedure Rotation1Click(Sender: TObject);
    procedure OtherFilters1Click(Sender: TObject);
    procedure AlphaBlending1Click(Sender: TObject);
    procedure Invert1Click(Sender: TObject);
    procedure Grayscale1Click(Sender: TObject);
    procedure Emboss1Click(Sender: TObject);
    procedure Gradient1Click(Sender: TObject);
    procedure Flip1Click(Sender: TObject);
    procedure Flop1Click(Sender: TObject);
    procedure Colors1Click(Sender: TObject);
    procedure FishEye1Click(Sender: TObject);
    procedure Twirl1Click(Sender: TObject);
    procedure CycleColors1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;
  Last:  TMenuItem;

implementation

uses Unit2, Unit3, Unit4, Unit5, Unit6, Unit7, Unit8, Unit9;

{$R *.DFM}

procedure TForm1.FormCreate(Sender: TObject);
begin
  SetWindowLong(Handle,GWL_EXSTYLE,WS_EX_CLIENTEDGE);
  ClientWidth:=Width;
  Last:=Draw1;
  OpenDialog1.FileName:=ExtractFilePath(Application.ExeName)+'fastbmp.bmp';
end;

procedure TForm1.LoadFromFile1Click(Sender: TObject);
begin
  if OpenDialog1.Execute then
  begin
    Form2.FastIMG1.FileName:=OpenDialog1.FileName;
    Form2.ClientWidth:=Form2.FastIMG1.Bmp.Width;
    Form2.ClientHeight:=Form2.FastIMG1.Bmp.Height;
  end;
end;

procedure TForm1.SaveToFile1Click(Sender: TObject);
begin
  if SaveDialog1.Execute then
  begin
    if   Form2.FastIMG1.Bmp is TFast256
    then TFast256(Form2.FastIMG1.Bmp).SaveToFile(SaveDialog1.FileName)
    else TFastBMP(Form2.FastIMG1.Bmp).SaveToFile(SaveDialog1.FileName);
  end;
end;

procedure TForm1.Revert1Click(Sender: TObject);
begin
  Form2.FastIMG1.FileName:=OpenDialog1.FileName;
  Form2.ClientWidth:=Form2.FastIMG1.Bmp.Width;
  Form2.ClientHeight:=Form2.FastIMG1.Bmp.Height;
end;

procedure TForm1.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TForm1.Draw1Click(Sender: TObject);
begin
  Last.Checked:=False;
  Form2.FastIMG1.DrawStyle:=dsDraw;
  Draw1.Checked:=True;
  Last:=Draw1;
end;

procedure TForm1.Center1Click(Sender: TObject);
begin
  Last.Checked:=False;
  Form2.FastIMG1.DrawStyle:=dsCenter;
  Center1.Checked:=True;
  Last:=Center1;
end;

procedure TForm1.Stretch1Click(Sender: TObject);
begin
  Last.Checked:=False;
  Form2.FastIMG1.DrawStyle:=dsStretch;
  Stretch1.Checked:=True;
  Last:=Stretch1;
end;

procedure TForm1.Resize1Click(Sender: TObject);
begin
  Last.Checked:=False;
  Form2.FastIMG1.DrawStyle:=dsResize;
  Resize1.Checked:=True;
  Last:=Resize1;
end;

procedure TForm1.Tile1Click(Sender: TObject);
begin
  Last.Checked:=False;
  Form2.FastIMG1.DrawStyle:=dsTile;
  Tile1.Checked:=True;
  Last:=Tile1;
end;

procedure TForm1.SmoothResizing1Click(Sender: TObject);
begin
  SmoothResizing1.Checked:=not SmoothResizing1.Checked;
  Form2.FastIMG1.BilinearResize:=SmoothResizing1.Checked;
end;

procedure TForm1.TFastBMP1Click(Sender: TObject);
var
Tmp: TFast256;
begin
  if Form2.FastIMG1.Bmp is TFast256 then
  begin
    Tmp:=TFast256.Create;
    Tmp.Copy(TFast256(Form2.FastIMG1.Bmp));
    Form2.FastIMG1.Bmp.Free;
    Form2.FastIMG1.Bmp:=TFastBMP.Create;
    Form2.FastIMG1.Bmp.SetSize(Tmp.Width,Tmp.Height);
    Tmp.Draw(TFastBMP(Form2.FastIMG1.Bmp).hDC,0,0);
    Tmp.Free;
    Form2.Caption:='TFastBMP';
    Form2.FastIMG1.Refresh;
  end;
end;

procedure TForm1.cmCut1Click(Sender: TObject);
var
Tmp: TFastBMP;
begin
  if Form2.FastIMG1.Bmp is TFastBMP then
  begin
    Tmp:=TFastBMP.Create;
    Tmp.Copy(TFastBMP(Form2.FastIMG1.Bmp));
    Form2.FastIMG1.Bmp.Free;
    Form2.FastIMG1.Bmp:=TFast256.Create;
    TFast256(Form2.FastIMG1.Bmp).LoadFromRGB(Tmp,cmCut);
    Tmp.Free;
    Form2.Caption:='TFast256';
    Form2.FastIMG1.Refresh;
    Form2.FastIMG1.Convert_256:=cmCut;
  end;
end;

procedure TForm1.cmDither1Click(Sender: TObject);
var
Tmp: TFastBMP;
begin
  if Form2.FastIMG1.Bmp is TFastBMP then
  begin
    Tmp:=TFastBMP.Create;
    Tmp.Copy(TFastBMP(Form2.FastIMG1.Bmp));
    Form2.FastIMG1.Bmp.Free;
    Form2.FastIMG1.Bmp:=TFast256.Create;
    TFast256(Form2.FastIMG1.Bmp).LoadFromRGB(Tmp,cmDither);
    Tmp.Free;
    Form2.Caption:='TFast256';
    Form2.FastIMG1.Refresh;
    Form2.FastIMG1.Convert_256:=cmDither;
  end;
end;

procedure TForm1.cmGray1Click(Sender: TObject);
var
Tmp: TFastBMP;
begin
  if Form2.FastIMG1.Bmp is TFastBMP then
  begin
    Tmp:=TFastBMP.Create;
    Tmp.Copy(TFastBMP(Form2.FastIMG1.Bmp));
    Form2.FastIMG1.Bmp.Free;
    Form2.FastIMG1.Bmp:=TFast256.Create;
    TFast256(Form2.FastIMG1.Bmp).LoadFromRGB(Tmp,cmGray);
    Tmp.Free;
    Form2.Caption:='TFast256';
    Form2.FastIMG1.Refresh;
    Form2.FastIMG1.Convert_256:=cmGray;
  end;
end;

procedure TForm1.Attributes1Click(Sender: TObject);
begin
  Form3.Show;
end;

procedure TForm1.WaveEffects1Click(Sender: TObject);
begin
  Form4.Show;
end;

procedure TForm1.Rotation1Click(Sender: TObject);
begin
  Form5.Show;
end;

procedure TForm1.OtherFilters1Click(Sender: TObject);
begin
  Form6.Show;
end;

procedure TForm1.AlphaBlending1Click(Sender: TObject);
begin
  Form7.Show;
end;

procedure TForm1.Invert1Click(Sender: TObject);
begin
  Invert(Form2.FastIMG1.Bmp);
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Grayscale1Click(Sender: TObject);
begin
  Grayscale(Form2.FastIMG1.Bmp);
  if Form2.FastIMG1.Bmp is TFast256 then
    TFast256(Form2.FastIMG1.Bmp).FillColors(tfBlack,tfWhite);
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Emboss1Click(Sender: TObject);
begin
  Emboss(Form2.FastIMG1.Bmp);
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Gradient1Click(Sender: TObject);
begin
  InterpolateRect(Form2.FastIMG1.Bmp,0,0,Form2.FastIMG1.Bmp.Width-1,
    Form2.FastIMG1.Bmp.Height-1,FRGB(255,0,0),FRGB(0,255,0),FRGB(0,0,255),
    FRGB(255,255,0));
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Flip1Click(Sender: TObject);
begin
  Flip(Form2.FastIMG1.Bmp);
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Flop1Click(Sender: TObject);
begin
  Flop(Form2.FastIMG1.Bmp);
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Colors1Click(Sender: TObject);
begin
  Form8.Show;
end;

procedure TForm1.FishEye1Click(Sender: TObject);
var
Tmp: TFastBMP;
begin
  if Form2.FastIMG1.Bmp is TFast256 then Exit;
  Tmp:=TFastBMP.Create;
  Tmp.Copy(TFastBMP(Form2.FastIMG1.Bmp));
  FishEye(Tmp,Form2.FastIMG1.Bmp,1);
  Tmp.Free;
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.Twirl1Click(Sender: TObject);
var
Tmp: TFastBMP;
begin
  if Form2.FastIMG1.Bmp is TFast256 then Exit;
  Tmp:=TFastBMP.Create;
  Tmp.Copy(TFastBMP(Form2.FastIMG1.Bmp));
  Twist(Tmp,Form2.FastIMG1.Bmp,50);
  Tmp.Free;
  Form2.FastIMG1.Refresh;
end;

procedure TForm1.CycleColors1Click(Sender: TObject);
begin
  Form9.Show;
end;

end.
