unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FastFX, FastRGB, FastBMP, Fast256, FastIMG;

type
  TForm4 = class(TForm)
    sxDiv: TScrollBar;
    syDiv: TScrollBar;
    sRatio: TScrollBar;
    sWrap: TRadioButton;
    sBlank: TRadioButton;
    Label1: TLabel;
    procedure sxDivScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure sWrapClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
    procedure FormShow(Sender: TObject);
  private
    { Private declarations }
  public
    procedure Process;
    { Public declarations }
  end;

var
  Form4: TForm4;
  Buf: TFastRGB;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm4.Process;
var
xDiv,yDiv,Ratio: Extended;
begin
  xDiv:=sxDiv.Position*0.5;
  yDiv:=syDiv.Position*0.5;
  Ratio:=sRatio.Position*0.5;
  if sWrap.Checked then
    WaveWrap(Buf,Form2.FastIMG1.Bmp,xDiv,yDiv,Ratio)
  else
  begin
    FillChar(Form2.FastIMG1.Bmp.Bits^,Form2.FastIMG1.Bmp.Size,0);
    Wave(Buf,Form2.FastIMG1.Bmp,xDiv,yDiv,Ratio);
  end;
  Form2.FastIMG1.Refresh;
end;

procedure TForm4.sxDivScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  Process;
end;

procedure TForm4.sWrapClick(Sender: TObject);
begin
  Process;
end;

procedure TForm4.FormHide(Sender: TObject);
begin
  CopyMemory(Buf.Bits,Buf.Bits,Buf.Size);
  if Buf is TFast256 then TFast256(Form2.FastIMG1.Bmp).Colors^:=TFast256(Buf).Colors^;
  Buf.Free;
end;

procedure TForm4.FormShow(Sender: TObject);
begin
  case Form2.FastIMG1.DataType of
    dtFastBMP: Buf:=TFastBMP.Create;
    dtFast256: Buf:=TFast256.Create;
  end;
  Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
  if Buf is TFast256 then TFast256(Buf).Colors^:=TFast256(Form2.FastIMG1.Bmp).Colors^;
  CopyMemory(Buf.Bits,Form2.FastIMG1.Bmp.Bits,Buf.Size);
end;

end.
 