unit Unit5;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, FastFX, FastRGB, FastBMP, Fast256, FastIMG;

type
  TForm5 = class(TForm)
    sAngle: TScrollBar;
    Label1: TLabel;
    scx: TScrollBar;
    scy: TScrollBar;
    rRotateWrap: TRadioButton;
    rSmoothRotateWrap: TRadioButton;
    Label2: TLabel;
    rRotate: TRadioButton;
    rSmoothRotate: TRadioButton;
    rClear: TCheckBox;
    procedure sAngleScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormShow(Sender: TObject);
    procedure rRotateWrapClick(Sender: TObject);
    procedure FormHide(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Process;
  end;

var
  Form5: TForm5;
  Buf: TFastRGB;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm5.Process;
var
Angle: Extended;
cx,cy: Integer;
begin
  if(rSmoothRotateWrap.Checked or rSmoothRotate.Checked)and(Form2.FastIMG1.Bmp is TFast256)then Exit;
  Angle:=sAngle.Position * 0.1;
  if Angle=0 then Exit;
  cx:=scx.Position;
  cy:=scy.Position;
  if(rClear.Checked)and(rRotate.Checked or rSmoothRotate.Checked)
  then FillChar(Form2.FastIMG1.Bmp.Bits^,Form2.FastIMG1.Bmp.Size,0);
  if rRotateWrap.Checked then
    RotateWrap(Buf,Form2.FastIMG1.Bmp,cx,cy,Angle)
  else if rSmoothRotateWrap.Checked then
    SmoothRotateWrap(Buf,Form2.FastIMG1.Bmp,cx,cy,Angle)
  else if rRotate.Checked then
    Rotate(Buf,Form2.FastIMG1.Bmp,cx,cy,Angle)
  else
    SmoothRotate(Buf,Form2.FastIMG1.Bmp,cx,cy,Angle);
  Form2.FastIMG1.Refresh;
end;

procedure TForm5.sAngleScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  Process;
end;

procedure TForm5.FormShow(Sender: TObject);
begin
  case Form2.FastIMG1.DataType of
    dtFastBMP: Buf:=TFastBMP.Create;
    dtFast256: Buf:=TFast256.Create;
  end;
  Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
  if Buf is TFast256 then TFast256(Buf).Colors^:=TFast256(Form2.FastIMG1.Bmp).Colors^;
  CopyMemory(Buf.Bits,Form2.FastIMG1.Bmp.Bits,Buf.Size);
  scx.Max:=Form2.FastIMG1.Bmp.Width;
  scy.Max:=Form2.FastIMG1.Bmp.Height;
  scx.Position:=Form2.FastIMG1.Bmp.Width div 2;
  scy.Position:=Form2.FastIMG1.Bmp.Height div 2;
end;

procedure TForm5.rRotateWrapClick(Sender: TObject);
begin
  Process;
end;

procedure TForm5.FormHide(Sender: TObject);
begin
  CopyMemory(Buf.Bits,Buf.Bits,Buf.Size);
  if Buf is TFast256 then TFast256(Form2.FastIMG1.Bmp).Colors^:=TFast256(Buf).Colors^;
  Buf.Free;
end;

end.
