unit Unit7;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, Menus, FastFX, FastBMP, FastRGB, Fast256, FastIMG;

type
  TForm7 = class(TForm)
    sAlpha: TScrollBar;
    Label1: TLabel;
    Button1: TButton;
    OpenDialog1: TOpenDialog;
    procedure sAlphaScroll(Sender: TObject; ScrollCode: TScrollCode;
      var ScrollPos: Integer);
    procedure FormHide(Sender: TObject);
    procedure FormShow(Sender: TObject);
    procedure Button1Click(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
    procedure Process;
  end;

var
  Form7: TForm7;
  Buf,
  Bmp: TFastRGB;

implementation

uses Unit2;

{$R *.DFM}

procedure TForm7.Process;
begin
  AlphaBlend(Form2.FastIMG1.Bmp,Bmp,Buf,sAlpha.Position);
  Form2.FastIMG1.Refresh;
end;

procedure TForm7.sAlphaScroll(Sender: TObject; ScrollCode: TScrollCode;
  var ScrollPos: Integer);
begin
  Process;
end;

procedure TForm7.FormHide(Sender: TObject);
begin
  Buf.Free;
  Bmp.Free;
end;

procedure TForm7.FormShow(Sender: TObject);
var
Tmp: TFastRGB;
begin
  case Form2.FastIMG1.DataType of
    dtFastBMP:
    begin
      Buf:=TFastBMP.Create;
      Bmp:=TFastBMP.Create;
      Tmp:=TFastBMP.Create;
      Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
      Bmp.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
      TFastBMP(Tmp).LoadFromFile(ExtractFilePath(Application.ExeName)+'sample.bmp');
    end;
    dtFast256:
    begin
      Buf:=TFast256.Create;
      Bmp:=TFast256.Create;
      Tmp:=TFast256.Create;
      Buf.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
      Bmp.SetSize(Form2.FastIMG1.Bmp.Width,Form2.FastIMG1.Bmp.Height);
      TFast256(Buf).Colors^:=TFast256(Form2.FastIMG1.Bmp).Colors^;
      TFast256(Bmp).Colors^:=TFast256(Form2.FastIMG1.Bmp).Colors^;
      TFast256(Tmp).LoadFromFile(ExtractFilePath(Application.ExeName)+'sample.bmp',cmGray);
    end;
  end;
  Tmp.SmoothResize(Bmp);
  Tmp.Free;
  CopyMemory(Buf.Bits,Form2.FastIMG1.Bmp.Bits,Buf.Size);
end;

procedure TForm7.Button1Click(Sender: TObject);
var
Tmp: TFastRGB;
begin
  if OpenDialog1.Execute then
  begin
    if Bmp is TFast256 then
    begin
      Tmp:=TFast256.Create;
      TFast256(Tmp).LoadFromFile(OpenDialog1.FileName,cmGray);
      Tmp.SmoothResize(Bmp);
    end else
    begin
      Tmp:=TFastBMP.Create;
      TFastBMP(Tmp).LoadFromFile(OpenDialog1.FileName);
      Tmp.SmoothResize(Bmp);
    end;
    Tmp.Free;
    Process;
  end;
end;

end.
 