#include    <graph.h>
#include    "vga_new.h"

/**
*.Name    Set360x480Mode
*
*.Title   ⠭ ० 360480 ᥫ, 256 梥⮢.
*
*.Proto   void Set360x480Mode( void )
*
*.Params   ᯮ.
*
*.Return   ᯮ.
*
*.Sample  e256hres.c
**/

void    Set360x480Mode( void ) {

	_asm  {

		// ⠭ ० 12h, ⮡  
		mov     ax,12h
		int     10h

		// ⠭ ⠭ ० 13h (320x200 ᥫ, 256 梥⮢)
		mov     ax,0013h
		int     10h

		// ९ணࠬ㥬 ॣ ।  :
		// 頥   ࠧ ᫮   ᨬ 
		// ⭮   ६ ( D4 chain4)
		mov   dx,SC_INDEX
		mov   ax,0604h
		out   dx,ax

		// ந ᨭ஭   ⠭ ᨭ஭
		mov   ax,0100h
		out   dx,ax

		// 㥬  ॣ । ࠧ ० ࠡ
		mov   dx,MOR

		// ⠭  ஢ 60
		mov   al,0e7h
		out   dx,al

		// ᪠ ᨭ஭
		mov   dx,SC_INDEX
		mov   ax,0300h
		out   dx,ax


		// 롨ࠥ ॣ ० ࠡ ᪮ ஫
		mov     dx,GC_INDEX
		mov     al,MDR
		out     dx,al

		// 뢠  祭
		inc     dx
		in      al,dx

		// 몫砥    ᠬ   ᫮,  
		//  ᠬ   ᫮
		and     al,11101111b
		out     dx,al

		// 롨ࠥ ॣ ᬥ蠭 祭 ᪮ ஫
		dec     dx
		mov     al,MIR
		out     dx,al

		// 뢠  祭
		inc     dx
		in      al,dx

		// 뢠  ࠢ騩 楯    ᫮
		and     al,11111101b
		out     dx,al


		// 롨ࠥ ॣ  ⭮ ⨪쭮 室 
		mov   dx,3d4h
		mov   al,11h
		out   dx,al

		// ᭨     ॣ஢ ஫ ,
		//    0  7
		inc   dx
		in    al,dx
		and   al,7fh
		out   dx,al

		dec   dx

		// ணࠬ㥬 ॣ ஫ , ⮬ ᫥
		// ॣ, ।騥 ६ ࠬ ०

		// ⠭ ॣ 饩   ਧ⠫쭮
		// ࠧ⪨
		mov   ax,06b00h
		out   dx,ax

		// ⠭ ॣ  ⮡ࠦ 
		// ਧ⠫쭮 ࠧ⪨
		mov   ax,05901h
		out   dx,ax

		// ⠭ ॣ 砫  襭 
		// ਧ⠫쭮 ࠧ⪨
		mov   ax,05a02h
		out   dx,ax

		// ⠭ ॣ   襭 
		// ਧ⠫쭮 ࠧ⪨
		mov   ax,08e03h
		out   dx,ax

		// ⠭ ॣ 砫  ਧ⠫쭮
		// ⭮ 室 
		mov   ax,05e04h
		out   dx,ax

		// ⠭ ॣ   ਧ⠫쭮
		// ⭮ 室 
		mov   ax,08a05h
		out   dx,ax

		// ⠭ ॣ ᫠ ਧ⠫ 
		// 
		mov   ax,0d06h
		out   dx,ax

		// ⠭ ⥫ ॣ
		mov   ax,03e07h
		out   dx,ax

		// ⠭ ॣ  ᨬ ⥪
		mov   ax,04009h
		out   dx,ax

		// ⠭ ॣ 砫 ⭮
		// ⨪쭮 室 
		mov   ax,0ea10h
		out   dx,ax

		// ⠭ ॣ  ⭮
		// ⨪쭮 室 
		mov   ax,0ac11h
		out   dx,ax

		// ⠭ ॣ 砫 襭 ⨪쭮
		// ࠧ⪨
		mov   ax,0df12h
		out   dx,ax

		// ⠭ ॣ ᪮ ਭ ࠭
		mov   ax,02d13h
		out   dx,ax

		// ⠭ ॣ  ન ᨬ
		mov   ax,014h
		out   dx,ax

		// ⠭ ॣ 砫  襭
		// ⨪쭮 ࠧ⪨
		mov   ax,0e715h
		out   dx,ax

		// ⠭ ॣ   襭
		// ⨪쭮 ࠧ⪨
		mov   ax,0616h
		out   dx,ax

		// ⠭ ॣ ࠢ ०
		mov   ax,0e317h
		out   dx,ax
	}
}


/**
*.Name    WritePixel_H
*
*.Title   ⮡ࠦ ᥫ.
*
*.Descr   㭪 ⮡ࠦ  ࠭ ᥫ   न,
*         । 梥.
*
*.Proto   void WritePixel_H(unsigned x, unsigned y, unsigned char color)
*
*.Params  x - x-न ᥫ (0-319),
*
*         y - y-न ᥫ (0-399),
*
*         color - 梥 ᥫ (0-255).
*
*.Return   ᯮ.
*
*.Sample  e256hres.c
**/

void  WritePixel_H(unsigned x, unsigned y, unsigned char color) {

	_asm  {

		push    di

		mov     cx,x
		mov     dx,y
		mov     bl,color


		mov     ax,VGA_SEGMENT
		mov     es,ax

		mov     ax,( SCREEN_WIDTH_H / 4 )
		mul     dx

		push    cx

		shr     cx,1
		shr     cx,1

		add     ax,cx
		mov     di,ax

		pop     cx

		and     cl,3
		mov     ah,1
		shl     ah,cl

		mov     dx,SC_INDEX
		mov     al,CPWER
		out     dx,ax

		mov     es:[di],bl

		pop     di
	}
}


/**
*.Name    ReadPixel_H
*
*.Title   । 梥 ᥫ.
*
*.Descr   㭪 頥 祭  , ।饣 ᥫ
*          묨 न⠬.
*
*.Proto   unsigned char ReadPixel_H(unsigned x, unsigned y, unsigned char color)
*
*.Params  x - x-न ᥫ (0-319),
*
*         y - y-न ᥫ (0-399).
*
*.Return  梥 ᥫ (0-255).
*
*.Sample  e256hres.c
**/

unsigned char   ReadPixel_H( unsigned x, unsigned y ) {

	unsigned char  color;

	_asm  {

		push    si

		mov     cx,x
		mov     dx,y

		mov     ax,VGA_SEGMENT
		mov     es,ax

		mov     ax,( SCREEN_WIDTH_H / 4 )
		mul     dx

		push    cx

		shr     cx,1
		shr     cx,1

		add     ax,cx
		mov     si,ax

		pop     ax

		and     al,3
		mov     ah,al

		mov     dx,GC_INDEX
		mov     al,RPSR
		out     dx,ax

		mov     al,es:[si]
		mov     color,al

		pop     si
	}

	return( color );
}


/**
*.Name    Full_Scr_H
*
*.Title   訢 ࠭  梥⮬.
*
*.Proto   void Full_Scr_H( unsigned char color )
*
*.Params  color - 梥 ࠭ (0-255).
*
*.Return   ᯮ.
*
*.Sample  e256hres.c
**/

void Full_Scr_H( unsigned char color ) {

	_asm {

		push    di

		;ࠧ蠥      梥⮢ ᫮

		mov     dx,SC_INDEX
		mov     al,CPWER
		out     dx,al

		mov     al,0fh
		out     dx,al


		mov     ax,VGA_SEGMENT
		mov     es,ax

		xor     di,di
		mov     al,color

		mov     cx,43200
		cld
		rep     stosb

		pop     di
	}
}


void main( void ){

	unsigned i;
	char ch = 13;

	struct videoconfig vc;

	// 塞   vc

	printf("\n   (C) Frolov G.V., 1992\n\n");
	_getvideoconfig( &vc );

	// 蠥 ணࠬ ᫨  VGA 

	if(vc.adapter != _VGA) {
		printf(" 믮 ணࠬ 室  VGA\n");
		exit(0);
	}


	// ⠭ ० 360480 ᥫ, 256 梥⮢

	Set360x480Mode();

	// 㦠 ॣ  VGA

	LoadVGA256();

	for(i = 0; i < 480; i++)
		WritePixel_H(180, (unsigned) i, (unsigned char) (i % 256) );

	for(i = 0; i < 360; i++)
		WritePixel_H((unsigned) i, 240, (unsigned char) (i % 256) );

	ch = getch();
	if( ch == 27 ) exit(1);

	for(i = 0; i < 360; i++)
		WritePixel_H((unsigned) i, (unsigned) i, (unsigned char) (i % 256) );

	ch = getch();

	for(i = 0; ((i < 256) && (ch != 27)); i++) {
		Full_Scr_H( (unsigned char) i );
		ch = getch();
	}


	// 頥  ⥪⮢ ०

	_setvideomode(_DEFAULTMODE);

	printf("ਢ ᥬ!!!\n");
}

