// MODEM.C
//

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>
#include <sys/types.h>

#include "uart.h"
#include "common.h"
#include "modem.h"
#include "mod_link.h"
#include "timer.h"
#include "tools.h"
#include "conf.h"


char *device = "COM3";  //  ᯮ㥬   ଠ
								// COMn,  n  1  4

unsigned  dialTimeout = 12,   // த⥫쭮  ᮥ
			 chardelay = 0,      // প  ।  ᨬ
			 modemTimeout = 3,   // ⠩  祭 ⢥  
			 answerTimeout;      // த⥫쭮  


unsigned  speed = 2400;     // ᪮  묨


char initialize[80];    //  樠樨
char dropline[80];      //   㡪
char autoanswer[80];    // ⢥  맮  ० ⮮⢥

char dialPrefix[80];  // 䨪 
char dialSuffix[80];  // 䨪 
char dialNumber[80];  // ⥫䮭 


static boolean    getmodem( const char *brand);
static boolean    sendlist( char **list, int timeout, int lasttimeout);
static boolean    sendalt( char *string, int timeout);

void exchange( void );


// call
// 맮 㤠 짮⥫

int call() {

	char str[80], buf[80];
   char *exp;
	int i,j;

	// ।塞 ࠬ 裡 (뢠 䠩 䨣樨)

	getconfig();

	// ⠭ ࠡ稪 뢠  樠㥬
	// ॣ UART  ஫ 뢠

	if (openline(device, speed))
		return FALSE;

	// 頥 ਥ 

	while (sread(buf,1,0));

	printf("樠㥬 \n\n");

	// ।  ப 樠樨
	// (ப 樠樨 । 祢 ᫮ Initialize
	//  䠩 䨣樨 setup.cfg)

	sendstr( initialize );

	//  ⢥ 

	sleep(modemTimeout);

	// 뢠  ⮡ࠦ  ࠭ ⢥⭮ ᮮ饭 

	if( r_count_pending() > 0 ) {

		sread(str, i = r_count_pending(), 0);
		str[i] = '\0';

		for( j = 0; j < i; j++ )
			putch( str[j] );
	}

	// ।    

	strcpy(buf, dialPrefix);
	strcat(buf, dialNumber);
	strcat(buf, dialSuffix);

	printf( "ࠥ \n\n");

	sendstr( buf );

	printf( " ᮥ\n\n");

	// ந  묨  㤠 ,
	//     "ESC"

	exchange();

	return(0);
}

// ansver
// ⢥砥  

int ansver( void ) {

	char c;

	// ।塞 ࠬ 裡

	getconfig();

	// ⠭ ࠡ稪 뢠  樠㥬
	// ॣ UART  ஫ 뢠

	if (openline(device, speed))
		exit(-2);

	// 頥 ਥ 

	while (sread(&c ,1,0));

	printf("樠㥬 \n\n");

	// ।  ப 樠樨
	// (ப 樠樨 । 祢 ᫮ Autoanswer
	//  䠩 䨣樨 setup.cfg)

	sendstr( autoanswer );
	sleep(modemTimeout);

	printf(" \n");

	// ந  묨  㤠 ,
	//     "ESC"

	exchange();

	return(0);
}


// shutdown
// 㭪  ⥫䮭 㡪

void shutdown( void ) {

	printf("\n\n 祭, ᢮ ⥫䮭\n");

	// ।   㡪

	sendstr( dropline );

	// ⠭  ࠡ稪 뢠

	closeline();
}


// slowwrite
// । ᨬ   প, ।塞 祢
// ᫮ CharDelay  䠩 䨣樨

void slowwrite( char *s, int len) {

   swrite( s , len );
	if (chardelay > 0) delay(chardelay);
}


// exchange
// 㭪 믮  짮⥫  㤠 

void exchange( void ) {

	int flag = 1;

	while(flag) {

		unsigned char str[80];
		unsigned char key;
		unsigned i,j;

		// ᫨ 짮⥫   , 砥 
		// ⮣ ᨬ  ।  

		if( kbhit() ) {
			key =  getch();

			//    "ESC" 室  ணࠬ

			if( key == 27 ) {
				ssendbrk( 3 );
				flag = 0;
				break;
			}

			if( key == '\r' ) putch( '\n' );

			putch(key);

			swrite( &key, 1);
		}

		// ᫨ 祭   , ⮡ࠦ   ࠭

		if( r_count_pending() > 0 ) {

			delay(100);

			sread(str, i = r_count_pending(), 0);
			str[i] = '\0';

			for( j = 0; j < i; j++ )
				putch( str[j] );
		}
	}
}



