#include <stdlib.h>
#include <string.h>
#include <dos.h>
#include "uart_reg.h"

#pragma check_stack( off )
#pragma check_pointer( off )

// ⢮ 뢠  ⠩   ᥪ㭤

#define TICKPERMIN  1092L


#define equip_bits  10h

char _huge *tsrstack;
char _huge *appstack;
char _huge *tsrbottom;


void (_interrupt _far *oldtimer)( void );
void _interrupt _far newtimer( void );

void test_com_port( void );
void hello( void );
void help( void );

// ।塞 㪠⥫  稪 ⠩

long _far *pcurtick = (long _far *)0x0000046cL;
long goaltick;


unsigned uart_reg[] = { 0, 0x3f8, 0x2f8, 0x3e8, 0x2e8 };

unsigned com_port;


//  楤

void main( int argc, char *argv[] ) {

	unsigned  tsrsize;

	// ࠬ ணࠬ  ᮤঠ 
	// ᯮ㥬 COM-

	if( argc < 2 ) help();

	hello();

	_asm mov  WORD PTR tsrstack[0], sp
	_asm mov  WORD PTR tsrstack[2], ss

	FP_SEG( tsrbottom ) = _psp;
	FP_OFF( tsrbottom ) = 0;


	com_port = ( unsigned ) uart_reg[atoi( argv[1] )];

	printf( "\n %x\n", com_port );

	// ।塞  ࢮ ஢ન ॣ஢
	// ᨭ஭ 

	goaltick += TICKPERMIN / 10L;

	// ⠭  뢠  ⠩

	oldtimer = _dos_getvect( 0x1c );
	_dos_setvect( 0x1c, newtimer );

	// 塞 ࠧ १⭮  ணࠬ

	tsrsize = ((tsrstack - tsrbottom) >> 4) + 1;
	_dos_freemem( _psp );

	// ⠢塞 ணࠬ १⭮  

	_dos_keep( 0, tsrsize );
}


void hello( void ) {

	printf("\n(c) Frolov G.V. \n");
}


void help( void ) {

	printf(" ࠢ쭮  ࠬ ணࠬ \n"
			 "LIGHT n,  n  1  4\n");
	exit(0);
}


// ࠡ稪 뢠  ⠩

void _interrupt _far newtimer() {

	// ᫨ 諮 ६ ஢塞 ॣ COM-

	if(*pcurtick >= goaltick) {

		(*oldtimer)();

		// 塞 ६ ᫥饩 ஢ન

		goaltick += TICKPERMIN / 10L;

		// ஢塞 ॣ COM-  ⮡ࠦ   ࠭

		test_com_port();
	}

	else
		_chain_intr( oldtimer );
}


void test_com_port( void ) {

	char data[9];
	char data2[] = "ddttidts";
	char data3[] = "  ss  rr";

	char attr[9];

  _asm {

		// 砥  ॣ ﭨ 

		mov     dx,com_port
		add     dx,LSR_N
		in      al,dx

		// ஢塞   ॣ ᤢ ।稪

		test    al,40h
		jz      next_1

		mov     ah,'t'
		mov     data[0],ah
		mov     attr[0],0x71
		jmp     short next_2

next_1:

		// ᫨ ॣ ᤢ  ,  
		// ⢫ । 

		mov     ah,'T'
		mov     data[0],ah
		mov     attr[0],0x79

next_2:

		// ஢塞   , ⮢  ⥭

		test    al,1
		jnz     next_3
		mov     ah,'r'
		mov     data[1],ah
		mov     attr[1],0x71
		jmp     short next_4

next_3:

		// ᫨    ⥭ ⮡ࠦ  ࠭
		// ᨬ 'R'

		mov     ah,'R'
		mov     data[1],ah
		mov     attr[1],0x79

next_4:

		// 뢠 ॣ ﭨ 

		mov     dx,com_port
		add     dx,MSR_N
		in      al,dx

		// ।塞 ﭨ  CTS

		test    al,10h
		jnz     next_5

		//  CTS  ⨢

		mov     ah,'c'
		mov     data[3],ah
		mov     attr[3],0x72
		jmp     short next_6

next_5:

		//  CTS ⨢

		mov     ah,'C'
		mov     data[3],ah
		mov     attr[3],0x7a

next_6:

		// ।塞 ﭨ  DSR

		test    al,20h
		jnz     next_7

		//  DSR  ⨢

		mov     ah,'d'
		mov     data[7],ah
		mov     attr[7],0x72
		jmp     short next_8

next_7:

		//  DSR ⨢

		mov     ah,'D'
		mov     data[7],ah
		mov     attr[7],0x7a

next_8:

		// ।塞 ﭨ  RI

		test    al,40h
		jnz     next_9

		//  RI 室   ⨢ ﭨ

		mov     ah,'r'
		mov     data[4],ah
		mov     attr[4],0x76
		jmp     short next_10

next_9:

		//  RI 室  ⨢ ﭨ

		mov     ah,'R'
		mov     data[4],ah
		mov     attr[4],0x7e

next_10:

		// ।塞 ﭨ  DCD

		test    al,80h
		jnz     next_11

		//  DCD  ⨢

		mov     ah,'c'
		mov     data[5],ah
		mov     attr[5],0x76
		jmp     short next_12

next_11:

		//  DCD ⨢

		mov     ah,'C'
		mov     data[5],ah
		mov     attr[5],0x7e

next_12:

		// 뢠 ॣ ࠢ 

		mov     dx,MCR_N
		add     dx,com_port
		in      al,dx

		// ஢塞  RTS

		test    al,2
		jnz     next_13

		//  RTS 室   ⨢ ﭨ

		mov     ah,'r'
		mov     data[2],ah
		mov     attr[2],0x74
		jmp     short next_14

next_13:

		//  RTS 室  ⨢ ﭨ

		mov     ah,'R'
		mov     data[2],ah
		mov     attr[2],0x7c

next_14:

		// ஢塞  DTR

		test    al,1
		jnz     next_15

		//  DTR  ⨢

		mov     ah,'d'
		mov     data[6],ah
		mov     attr[6],0x74
		jmp     short next_16

next_15:

		//  DTR ⨢

		mov     ah,'D'
		mov     data[6],ah
		mov     attr[6],0x7c

next_16:

// ⮡ࠦ  ࠭ ﭨ ॣ஢
// 뢮  ࠭ ந室 ।⢥
// १ 

		// ᥣ 

		mov     ax,0B800h
		mov     es,ax

		xor     si,si
		mov     di,0
		mov     cx,8

next_char:

		// ⮡ࠦ  ࠭ । ᨬ
		//  ᨢ data

		mov      ah,data[si]
		mov      es:[di],ah

		inc      di

		// ⠭ ਡ ⮣ ᨬ

		mov      ah,attr[si]
		mov      es:[di],ah
		sti

		inc      di
		inc      si

		loop     next_char

		xor     si,si
		mov     di,160
		mov     cx,8

next_str2:
		mov      ah,data2[si]
		mov      es:[di],ah
		inc      di
		mov      ah,attr[si]
		mov      es:[di],ah
		sti
		inc      di
		inc      si
		loop     next_str2


		xor     si,si
		mov     di,320
		mov     cx,8

next_str3:
		mov      ah,data3[si]
		mov      es:[di],ah
		inc      di
		mov      ah,attr[si]
		mov      es:[di],ah
		sti
		inc      di
		inc      si
		loop     next_str3


	}
}
