// REGISTER.C

#include "uart_reg.h"
#include <graph.h>


unsigned com_address( int );

void main(void) {

	unsigned adr;
	int port;
	unsigned char data;

	LCR     reg_lcr;
	LSR     reg_lsr;
	MCR     reg_mcr;
	MSR     reg_msr;
	ICR     reg_icr;
	IIDR    reg_iidr;

	printf(" ணࠬ ⮡ࠦ ﭨ ॣ஢ UART.\n\n");

	printf("   ᨭ஭  (1-4): ");
	scanf("%d", &port );

	// ।塞   port

	adr = com_address( --port );


	printf("\n ࠢ騩 ॣ = %Xh\n\n", data =
							(unsigned char ) inp( adr + 3 ) );

	reg_lcr.byte = data;

	printf("     ᫮   %d\n"
		   "    ⢮ ⮯ ⮢ %d\n"
		   "    ஫ %s\n"
		   "    䨪 ⭮ %s\n"
		   "    ⠭ 뢠: %s\n"
		   "     %Xh, %Xh ᯮ %s\n",

			reg_lcr.bit_reg.len + 5,
			reg_lcr.bit_reg.stop + 1,
			(reg_lcr.bit_reg.parity == 3) ? " ⭮" :
				((reg_lcr.bit_reg.parity == 1 ) ? " ⭮" :
											  "⭮  믮"),

			(reg_lcr.bit_reg.stuck_parity == 1) ? "ந" :
											  " ந",

			(reg_lcr.bit_reg.en_break_ctl == 1) ? "" :
											  "",

			adr, adr + 1,
			(reg_lcr.bit_reg.dlab == 1) ? " 㧪 ⥫ " :
									  " 筮"

	);




	printf("\n  ﭨ  = %Xh\n\n", data =
							(unsigned char ) inp( adr + 5 ) );

	reg_lsr.byte = data;

	printf("     ⮢  ⥭: %d\n"
		   "    訡 ९: %d\n"
		   "    訡 ⭮: %d\n"
		   "    訡 ᨭ஭樨: %d\n"
		   "    㦥   뢠 \"BREAK\": %d\n"
		   "    ॣ ࠭ ।稪 : %d\n"
		   "    ॣ ᤢ ।稪 : %d\n"
		   "    ⠩-: %d\n",

			reg_lsr.bit_reg.in_ready,
			reg_lsr.bit_reg.overflow,
			reg_lsr.bit_reg.parity,
			reg_lsr.bit_reg.synxr,
			reg_lsr.bit_reg.break_detect,
			reg_lsr.bit_reg.out_ready,
			reg_lsr.bit_reg.shift_ready,
			reg_lsr.bit_reg.taimout
	);

	printf("\n\n     த ");
	getch();




	printf("\n  ࠢ  = %Xh\n\n", data =
									 ( unsigned char ) inp( adr + 4 ));
	reg_mcr.byte = data;


	printf("     dtr: %d\n"
		   "     rts: %d\n"
		   "     out1: %d\n"
		   "     out2: %d\n"
		   "     ⨪: %d\n",

			reg_mcr.bit_reg.dtr,
			reg_mcr.bit_reg.rts,
			reg_mcr.bit_reg.out1,
			reg_mcr.bit_reg.out2,
			reg_mcr.bit_reg.diag
	);


	printf("\n  ﭨ  = %Xh\n\n", data =
									( unsigned char ) inp( adr + 6 ) );
	reg_msr.byte = data;


	printf("      cts ﭨ: %d\n"
		   "      dsr ﭨ: %d\n"
		   "      ri ﭨ: %d\n"
		   "      dcd ﭨ: %d\n"
		   "     cts: %d\n"
		   "     dsr: %d\n"
		   "     ri: %d\n"
		   "     dcd: %d\n",

			reg_msr.bit_reg.change_cts,
			reg_msr.bit_reg.change_dsr,
			reg_msr.bit_reg.change_ri,
			reg_msr.bit_reg.change_dcd,
			reg_msr.bit_reg.cts,
			reg_msr.bit_reg.dsr,
			reg_msr.bit_reg.ri,
			reg_msr.bit_reg.dcd
	);


	printf("\n\n     த ");
	getch();


	printf("\n\n  ࠢ 뢠ﬨ = %Xh\n\n", data =
								   ( unsigned char ) inp( adr + 1 ));

	reg_icr.byte = data;


	printf("    ࠧ襭 뢠  ⮢ ਭ : %d\n"
		   "    ࠧ襭 뢢 ᫥ । : %d\n"

		   "    ࠧ襭 뢠  㦥"
		   "    ﭨ \"BREAK\": %d\n"

		   "    ࠧ襭 뢠   ﭨ "
		   " cts, dsr, ri, dcd: %d\n",

			reg_icr.bit_reg.in_ready,
			reg_icr.bit_reg.out_ready,
			reg_icr.bit_reg.err,
			reg_icr.bit_reg.change
	);



	printf("\n\n  䨪樨 뢠 = %Xh\n\n", data =
									( unsigned char ) inp( adr + 2 ));

	reg_iidr.byte = data;


	printf("     뢠  㦨: %d\n"
		   "    䨪 뢠: %d\n",

			reg_iidr.bit_reg.no_inter,
			reg_iidr.bit_reg.inter_id
	);
}
