// TOOLS.C
//

#include <assert.h>
#include <fcntl.h>
#include <io.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <time.h>

#include "common.h"
#include "tools.h"
#include "uart.h"
#include "timer.h"


unsigned port_active = FALSE;

static unsigned current_baud;

#define  STOPBIT  1

static unsigned hangup_needed = TRUE;


/**
*.Name         openline
*
*.Title        ⠭ ⥪騩 COM-.
*
*.Descr         㭪 ⠭ ⥪騩 ᨭ஭
*                  쭥襬 㤥 ந室 .
*
*.Proto        int openline(char *name, unsigned baud)
*
*.Params       char *name -  COM-
*              unsigned baud - ᪮  묨
*
*.Return        ᯮ
*
*.Sample       comlib.c
**/

int openline(char *name, unsigned baud) {

   int   value;

	// ᫨  㦥 ⨢, 뢠 

	if (port_active)
		closeline();

	if (sscanf(name, "COM%d", &value) != 1) {
		exit(-1);
   }

	// 롨ࠥ ⥪騩 COM-

   select_port(value);

	// ࠭塞  ண ࠡ稪 뢠 COM-

   save_com();

	// ⠭  ࠡ稪 뢠 COM-

   install_com();


	// ணࠬ㥬 ⥪騩 COM-
	// ᪮,  १ ,  ஢塞 ⭮
	//  ⮯ 

	open_com(baud, 'M', 'N', STOPBIT);

	//  ᪮

   current_baud = baud;

	// ⠭  DTR  ⨢ ﭨ
	// ( ⮢   묨)

   dtr_on();

	port_active = TRUE;

	return( 0 );
}


/**
*.Name         sread
*
*.Title        ⠥ ᨬ  COM-.
*
*.Descr         㭪 ⠥  ᫮ ᨬ
*                ਥ ᨭ஭ .
*
*.Proto        unsigned sread(char *buffer, unsigned wanted, unsigned timeout)
*
*.Params       char *buffer - 㪠⥫      ᠭ ᨬ
*                               ਥ
*              unsigned wanted - ᫮ ᨬ, ஥  
*                                  ਥ
*              unsigned timeout - ६, ⢥  ⥭ ᨬ
*
*.Return       ⢮ ᨬ ⠭    ਥ
*
*.Sample       comlib.c
**/

unsigned  sread(char *buffer, unsigned wanted, unsigned timeout) {

   time_t start;
   hangup_needed = TRUE;

	// ।塞 砫쭮 ६

   start = time(nil(time_t));

	for(;;) {

      unsigned int pending;

		// ।塞 ᫮ ᨬ   ਥ

      pending = r_count_pending();

		// ᫨    室 ⢮ ᨬ

		if (pending >= wanted) {

         unsigned int i;

			// 뢠   㦭 ᫮ ᨬ

         for (i = 0; i < wanted; i++)
            *buffer++ = (char) receive_com();

         return pending;
		}

		// ᫨   ਥ  ᨬ, 祬 
		//  ⥭, ஢塞  ⥪  ⢥  ⥭
		// ६

		else {

         time_t   now     = time(nil(time_t));
         time_t   elapsed = now - start;

			delay(0);

         if (elapsed >= (long) timeout)
            return pending;
		}
   }
}


/**
*.Name         swrite
*
*.Title         ᨬ  COM-.
*
*.Descr         㭪 뢠  ᫮ ᨬ
*                ।稪 ᨭ஭ .
*
*.Proto        int swrite(char *data, unsigned len)
*
*.Params       char *data - 㪠⥫   
*              unsigned len - ᫮ ᨬ, ஥  
*                                  ।稪
*
*.Return       ⢮ ᨬ ᠭ   ।稪
*
*.Sample       comlib.c
**/

int swrite(char *data, unsigned int len) {

   unsigned int i;

   hangup_needed = TRUE;

	// 뢠 室    ।稪
	// ᨭ஭ 

   for (i = 0; i < len; i++)
      send_com(*data++);

   return len;
}


/**
*.Name         ssendbrk
*
*.Title        । ᨣ BREAK 㤠 .
*
*.Proto        void ssendbrk()
*
*.Params        ᯮ.
*
*.Return        ᯮ.
*
*.Sample       comlib.c
**/

void ssendbrk(void)  {

   break_com();
}


/**
*.Name         closeline
*
*.Title        뢠 COM-.
*
*.Descr         㭪 ⠭  祭
*              ஢ 뢠  頥 뢠
*               COM-.
*
*.Proto        void closeline(void)
*
*.Params        ᯮ.
*
*.Return        ᯮ.
*
*.Sample       comlib.c
**/

void closeline(void) {

   int far *stats;

	port_active = FALSE;

	// ⬥塞 ᨣ DTR

   dtr_off();

	// 頥 뢠  COM-

   close_com();

	// ⠭  뢠

   restore_com();
}


