IDEAL
RADIX	16
P286
MODEL	LARGE

include 'tiny-os.inc'

STACK	STACK_SIZE

DATASEG
DSEG_BEG = THIS WORD

	real_ss dw	?
	real_sp dw	?
	real_es dw	?

GDT_BEG	= $
LABEL	gdtr		WORD

gdt_0	desc_struc <0,0,0,0,0>
gdt_gdt desc_struc <GDT_SIZE-1,,,DATA_ACC,0>
gdt_idt desc_struc <IDT_SIZE-1,,,IDT_ACC,0>
gdt_ds	desc_struc <DSEG_SIZE-1,,,DATA_ACC,0>
gdt_cs	desc_struc <CSEG_SIZE-1,,,CODE_ACC,0>
gdt_ss	desc_struc <STACK_SIZE-1,,,DATA_ACC,0>
gdt_bio desc_struc <B_DATA_SIZE-1,B_DATA_ADDR,0,DATA_ACC,0>
gdt_crt desc_struc <CRT_SIZE-1,CRT_LOW,CRT_SEG,DATA_ACC,0>
gdt_mda desc_struc <MONO_SIZE-1,MONO_LOW,CRT_SEG,DATA_ACC,0>

GDT_SIZE = ($ - GDT_BEG)

;    㧪 ॣ IDTR

idtr	idtr_struc	<IDT_SIZE,,,0>

;  ਯ஢ 뢠

IDT_BEG	= $

; ---------------------- ⨫ ᪫祭 --------------------

idt	idt_struc <OFFSET exc_00,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_01,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_02,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_03,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_04,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_05,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_06,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_07,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_08,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_09,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0A,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0B,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0C,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0D,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0E,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_0F,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_10,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_11,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_12,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_13,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_14,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_15,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_16,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_17,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_18,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_19,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1A,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1B,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1C,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1D,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1E,CS_DESCR,0,TRAP_ACC,0>
	idt_struc <OFFSET exc_1F,CS_DESCR,0,TRAP_ACC,0>

; --------------- ⨫  뢠 ---------------

; int 20h -- IRQ0

	idt_struc <OFFSET Timer_int,CS_DESCR,0,INT_ACC,0>

; int 21h -- IRQ1

	idt_struc <OFFSET Keyb_int,CS_DESCR,0,INT_ACC,0>

; int 22h, 23h, 24h, 25h, 26h, 27h -- IRQ2-IRQ7

	idt_struc 6 dup (<OFFSET dummy_iret0,CS_DESCR,0,INT_ACC,0>)

; int 28h, 29h, 2ah, 2bh, 2ch, 2dh, 2eh, 2fh -- IRQ8-IRQ15

	idt_struc 8 dup (<OFFSET dummy_iret1,CS_DESCR,0,INT_ACC,0>)


; -------------------- ⨫ 뢠 --------------------

; int 30h 
		idt_struc	<OFFSET Int_30h_Entry,CS_DESCR,0,INT_ACC,0>


IDT_SIZE	= ($ - IDT_BEG)

CODESEG

PROC	start

	mov	ax,DGROUP
	mov	ds,ax
	call	set_crt_base
	mov	bh, 77h
	call	clrscr

; ⠭  ०

	call	set_pmode	
	call	write_hello_msg	

; ᪨㥬 뢠  ⠩  

	in	al,INT_MASK_PORT
	and	al,0fch
	out	INT_MASK_PORT,al

;     <ESC>

charin:
	int 	30h	;    
			; AX - ᪠- ,
			; BX - ﭨ ४ 
	cmp	al, 1	; ᫨ <ESC> - 室  横
	jz	continue

	push	bx		; 뢮 ᪠-  ࠭
	mov	bx, 0301h	; न 뢮
	call	Print_Word
	pop	bx

	mov	ax, bx		; 뢮 ﭨ
	push	bx		; ४ 
	mov	bx, 0306h
	call	Print_Word
	pop	bx

	jmp	charin

; 騩  室  ᥣ .
;  ᯮ   樨 
; ᪫祭  ⪥   ᥣ .

wrong1	db ?

continue:

; ᫥    <ESC> 室   
; ணࠬ. 騥 ᪮쪮 ப 
; ,  뢠 ᪫祭.  
; ஡ , ᫨ 㡥 ᨬ 
;  ᮮ⢥饩 ப.

; ⪠    ᥣ . ⪠ wrong
; 室  ᠬ  ணࠬ.
	mov	[wrong], al

; ⪠   ᥣ .
;	mov	[wrong1], al

; ⪠ 祭  ⮣ ⥪.
;	pop	ax

; 㧪  ᥣ ॣ ࠢ쭮 ᥫ.
;	mov	ax, 1280h
;	mov	ds, ax

; אַ 맮 ᪫祭    뢠.
;	int	1


	call	set_rmode	; ⠭ ॠ쭮 ०

	mov	bh, 07h		; ࠥ ࠭ 
	call	clrscr		; 室  DOS
	mov	ah,4c
	int	21h

ENDP	start


MACRO setgdtentry
	mov	[(desc_struc bx).base_l],ax
	mov	[(desc_struc bx).base_h],dl
ENDM

; -------------------------------------------
; ⠭ 񭭮 ०
; -------------------------------------------

PROC	set_pmode	NEAR

	mov	ax,DGROUP
	mov	dl,ah
	shr	dl,4
	shl	ax,4
	mov	si,ax
	mov	di,dx
	add	ax,OFFSET gdtr
	adc	dl,0
	mov	bx,OFFSET gdt_gdt
	setgdtentry

; 塞 ਯ  GDT, 㪠뢠騩 
; ਯ ⠡ 뢠

	mov	ax,si	; 㦠 24-⮢  ᥣ
	mov	dx,di	; 
	add	ax,OFFSET idt	;  ਯ  IDT
	adc	dl,0
	mov	bx,OFFSET gdt_idt
	setgdtentry

; 塞   㧪 ॣ IDTR

	mov	bx,OFFSET idtr
	mov	[(idtr_struc bx).idt_l],ax
	mov	[(idtr_struc bx).idt_h],dl

	mov	bx,OFFSET gdt_ds
	mov	ax,si
	mov	dx,di
	setgdtentry

	mov	bx,OFFSET gdt_cs
	mov	ax,cs
	mov	dl,ah
	shr	dl,4
	shl	ax,4
	setgdtentry

	mov	bx,OFFSET gdt_ss
	mov	ax,ss
	mov	dl,ah
	shr	dl,4
	shl	ax,4
	setgdtentry

; ⮢   ॠ ०

	push	ds
	mov	ax,40
	mov	ds,ax
	mov	[WORD 67],OFFSET shutdown_return
	mov	[WORD 69],cs
	pop	ds

	cli
	mov	al,8f
	out	CMOS_PORT,al
	jmp	del1
del1:
	mov	al,5
	out	CMOS_PORT+1,al

	mov	ax,[rl_crt]	; ᥣ 
	mov	es,ax

	call	enable_a20	; 뢠  A20

	mov	[real_ss],ss	; ࠭塞 ᥣ
	mov	[real_es],es	; ॣ

; -------- ९ணࠬ㥬 ஫ 뢠 --------

; ⠭  IRQ0-IRQ7  뢠 20h-27h

	mov	dx,MASTER8259A
	mov	ah,20h
	call	set_int_ctrlr

; ⠭  IRQ8-IRQ15  뢠 28h-2Fh

	mov	dx,SLAVE8259A
	mov	ah,28h
	call	set_int_ctrlr

; 㦠 ॣ IDTR  GDTR

	lidt	[FWORD idtr]
	lgdt	[QWORD gdt_gdt]

; ४砥   ०

	mov	ax,VIRTUAL_MODE
	lmsw	ax

;	jmp	far flush
	db	0ea
	dw	OFFSET flush
	dw	CS_DESCR
LABEL	flush	FAR

; 㦠 ᥫ  ᥣ ॣ

	mov	ax,SS_DESCR
	mov	ss,ax
	mov	ax,DS_DESCR
	mov	ds,ax

; 蠥 뢠

	sti

	ret
ENDP	set_pmode

; --------------------------------
;   ॠ ०
; --------------------------------

DATASEG

; ⮩ ਯ  믮 
;   ॠ ० १ ॢ
;   ﭨ ⪫祭.

null_idt idt_struc <> 

CODESEG

PROC	set_rmode	NEAR

	mov	[real_sp],sp

; ॢ   ﭨ ⪫祭,
;  ⭮ ⭮ , 
; 믮 ॥.
; 砫  㦠 IDTR ﬨ, ⥬
; 뤠  뢠.

	lidt	[FWORD null_idt]
	int	3

;   ᯮᮡ   १
; ஫ .
;	mov	al,SHUT_DOWN
;	out	STATUS_PORT,al

rwait:
	hlt
	jmp	rwait

LABEL	shutdown_return FAR

	in	al,INT_MASK_PORT
	and	al,0
	out	INT_MASK_PORT,al

	mov	ax,DGROUP
	mov	ds,ax
	assume	ds:DGROUP

	cli
	mov	ss,[real_ss]
	mov	sp,[real_sp]
	mov	ax,000dh
	out	CMOS_PORT,al
	sti
	mov	es,[real_es]
	call	disable_a20
	ret
ENDP	set_rmode


; -------------------------------------------------
; ࠡ⪠ ᪫祭
; -------------------------------------------------

; ࠡ稪 ᪫祭. 뢠  AX 
; ᪫祭  । ࠢ 楤
; shutdown

LABEL	exc_00	WORD
	mov	ax,0
	jmp	shutdown
LABEL	exc_01	WORD
	mov	ax,1
	jmp	shutdown
LABEL	exc_02	WORD
	mov	ax,2
	jmp	shutdown
LABEL	exc_03	WORD
	mov	ax,3
	jmp	shutdown
LABEL	exc_04	WORD
	mov	ax,4
	jmp	shutdown
LABEL	exc_05	WORD
	mov	ax,5
	jmp	shutdown
LABEL	exc_06	WORD
	mov	ax,6
	jmp	shutdown
LABEL	exc_07	WORD
	mov	ax,7
	jmp	shutdown
LABEL	exc_08	WORD
	mov	ax,8
	jmp	shutdown
LABEL	exc_09	WORD
	mov	ax,9
	jmp	shutdown
LABEL	exc_0A	WORD
	mov	ax,0ah
	jmp	shutdown
LABEL	exc_0B	WORD
	mov	ax,0bh
	jmp	shutdown
LABEL	exc_0C	WORD
	mov	ax,0ch
	jmp	shutdown
LABEL	exc_0D	WORD
	mov	ax,0dh
	jmp	shutdown
LABEL	exc_0E	WORD
	mov	ax,0eh
	jmp	shutdown
LABEL	exc_0F	WORD
	mov	ax,0fh
	jmp	shutdown
LABEL	exc_10	WORD
	mov	ax,10h
	jmp	shutdown
LABEL	exc_11	WORD
	mov	ax,11h
	jmp	shutdown
LABEL	exc_12	WORD
	mov	ax,12h
	jmp	shutdown
LABEL	exc_13	WORD
	mov	ax,13h
	jmp	shutdown
LABEL	exc_14	WORD
	mov	ax,14h
	jmp	shutdown
LABEL	exc_15	WORD
	mov	ax,15h
	jmp	shutdown
LABEL	exc_16	WORD
	mov	ax,16h
	jmp	shutdown
LABEL	exc_17	WORD
	mov	ax,17h
	jmp	shutdown
LABEL	exc_18	WORD
	mov	ax,18h
	jmp	shutdown
LABEL	exc_19	WORD
	mov	ax,19h
	jmp	shutdown
LABEL	exc_1A	WORD
	mov	ax,1ah
	jmp	shutdown
LABEL	exc_1B	WORD
	mov	ax,1bh
	jmp	shutdown
LABEL	exc_1C	WORD
	mov	ax,1ch
	jmp	shutdown
LABEL	exc_1D	WORD
	mov	ax,1dh
	jmp	shutdown
LABEL	exc_1E	WORD
	mov	ax,1eh
	jmp	shutdown
LABEL	exc_1F	WORD
	mov	ax,1fh
	jmp	shutdown

DATASEG

exc_msg db	"Exception ...., ....:.... code ..... Press any key... "

CODESEG

; -----------------------------------------------
; 뢮  ࠭  ᪫祭,  訡,
;  ॣ஢    ॠ ०.
; -----------------------------------------------

PROC	shutdown	NEAR

	call	rdump	;  ॣ஢ 

	push	ax
	call	beep	; 㪮 ᨣ

; 뢮 ᮮ饭  ᪫祭

	mov	ax,[vir_crt]
	mov	es,ax
	mov	bx,1d
	mov	ax,4
	mov	si,OFFSET exc_msg
	mov	dh,74h
	mov	cx, SIZE exc_msg
	call	writexy
	pop	ax

	mov	bx, 040bh	;  ᪫祭
	call	Print_Word

	pop	ax
	mov	bx, 0420h	;  訡
	call	Print_Word

	pop	ax
	mov	bx, 0416h	; ᬥ饭
	call	Print_Word

	pop	ax
	mov	bx, 0411h	; ᥫ
	call	Print_Word

	call	set_rmode	; 頥  ॠ ०

	mov	ax, 0	;    
	int 	16h

	mov	bh, 07h
	call	clrscr
	mov	ah,4Ch
	int	21h

ENDP	shutdown

; -------------------------------------------------
; ९ணࠬ஢ ஫ 뢠
;	 室: DX -  ஫ 뢠
;		  AH - 砫  뢠
; -------------------------------------------------

PROC	set_int_ctrlr	NEAR

	mov	al,11
	out	dx,al
	jmp	SHORT $+2
	mov	al,ah
	inc	dx
	out	dx,al
	jmp	SHORT $+2
	mov	al,4
	out	dx,al
	jmp	SHORT $+2
	mov	al,1
	out	dx,al
	jmp	SHORT $+2
	mov	al,0ff
	out	dx,al
	dec	dx
	ret
ENDP	set_int_ctrlr

; -------------------------------
; 襭  A20
; -------------------------------

PROC	enable_a20	NEAR
	mov	al,A20_PORT
	out	STATUS_PORT,al
	mov	al,A20_ON
	out	KBD_PORT_A,al
	ret
ENDP	enable_a20

; -------------------------------
; 饭  A20
; -------------------------------

PROC	disable_a20	NEAR
	mov	al,A20_PORT
	out	STATUS_PORT,al
	mov	al,A20_OFF
	out	KBD_PORT_A,al
	ret
ENDP	disable_a20

; ---------- ࠡ稪  뢠 IRQ2-IRQ7

PROC	dummy_iret0	 NEAR
	push	ax

; 뫠 ᨣ  뢠   ஫ 8259A

	mov	al,EOI
	out	MASTER8259A,al
	pop	ax
	iret
ENDP	dummy_iret0

; ---------- ࠡ稪  뢠 IRQ8-IRQ15

PROC	dummy_iret1	 NEAR
	push	ax

; 뫠 ᨣ  뢠   
;  ன ஫ 8259A

	mov	al,EOI
	out	MASTER8259A,al
	out	SLAVE8259A,al
	pop	ax
	iret
ENDP	dummy_iret1

; ------------------------------------------
; 楤 뤠 ⪨ 㪮 ᨣ
; ------------------------------------------

PROC	beep	NEAR
	push	ax bx cx

	in	al,KBD_PORT_B
	push	ax
	mov	cx,80
beep0:
	push	cx
	and	al,11111100b
	out	KBD_PORT_B,al
	mov	cx,60
idle1:
	loop	idle1
	or	al,00000010b
	out	KBD_PORT_B,al
	mov	cx,60
idle2:
	loop	idle2
	pop	cx
	loop	beep0

	pop	ax
	out	KBD_PORT_B,al

	pop	cx bx ax
	ret
ENDP	beep

; ------------------------------------------------
; 楤 ন 믮 ணࠬ
;  ஥ ६, 饥  த⢨
; .
; ------------------------------------------------

PROC	pause		NEAR
	push	cx
	mov	cx,10
ploop0:
	push	cx
	xor	cx,cx
ploop1:
	loop	ploop1
	pop	cx
	loop	ploop0
	pop	cx
	ret
ENDP	pause


; ------------------------------------------
;	楤  ࠡ  ன
; ------------------------------------------


DATASEG

	key_flag 	db	0
	key_code 	dw	0
	ext_scan	db	0
	keyb_status	dw	0

CODESEG

; ----------------------------------------------
; ࠡ稪 ⭮ 뢠 
; ----------------------------------------------

PROC	Keyb_int	 NEAR

	call	beep	; 뤠 㪮 ᨣ

	push	ax
	mov	al, [ext_scan]	; ७ ᪠-
	cmp	al, 0		;   ?
	jz	normal_scan1

; --------- ࠡ⪠ ७ ᪠- -------------

	cmp	al, 0e1h	;   <Pause>?
	jz	pause_key

	in	al, 60h		;  ᪠-

	cmp	al, 2ah		; 㥬 䨪 2Ah
	jz	intkeyb_exit_1

	cmp	al, 0aah	; 㥬 ᪠
	jz	intkeyb_exit_1	; 

	mov	ah, [ext_scan]	; 뢠 ᪠- 
	call	Keyb_PutQ	; ७ ᪠-
				;  "।", 
				;   ᫮

	mov	al, 0		; 뢠 ਧ
	mov	[ext_scan], al	; 祭 ७
	jmp	intkeyb_exit	; ᪠-

pause_key:			; ࠡ⪠  <Pause>

	in	al, 60h		;  ᪠-
	cmp	al, 0c5h	; ᫨   <Pause>,
	jz	pause_key1	; 뢠   ।,
	cmp	al, 45h		;  㥬
	jz	pause_key1
	jmp	intkeyb_exit

pause_key1:
	mov	ah, [ext_scan]	;   ।
	call	Keyb_PutQ	;   <Pause>

	mov	al, 0		; 뢠 ਧ 
	mov	[ext_scan], al	; 祭 ७
	jmp	intkeyb_exit	; ᪠-

; --------- ࠡ⪠ 筮 ᪠- -------------

normal_scan1:

	in	al, 60h		;  ᪠-

	cmp	al, 0feh	; 㥬 FEh
	jz	intkeyb_exit

	cmp	al, 0e1h	; ७ ᪠-?
	jz	ext_key		; ᫨ ,   ࠡ
				; ७ ᪠-
	cmp	al, 0e0h	
	jnz	normal_scan

ext_key:
	mov	[ext_scan], al	; ⠭ ਧ
	jmp	intkeyb_exit	; ७ ᪠-

;  ਧ ७ ᪠-  室

intkeyb_exit_1:
	mov	al, 0
	mov	[ext_scan], al
	jmp	intkeyb_exit

;  ଠ쭮 ᪠-  ।  室
	
normal_scan:
	mov	ah, 0
	call	Keyb_PutQ

intkeyb_exit:

	in	al, 61h		; ࠧ㥬 
	mov	ah, al
	or	al, 80h
	out	61h, al
	xchg	ah, al
	out	61h, al

	mov	al,EOI		; 뫠 ᨣ 
	out	MASTER8259A,al	; 뢠

	pop	ax
	sti
	iret
ENDP	Keyb_int


; ---------------------------------------------------
;  ᪠-  ७ ᪠- 
; "", 騩   ᫮.
; ---------------------------------------------------

PROC	Keyb_PutQ	NEAR

	push	ax
	mov	[key_code], ax	; 뢠 

; ------- ࠡ뢠 ४騥  ---------

	cmp	ax, 002ah	; L_SHIFT down
	jnz	@@kb1
	mov	ax, [keyb_status]
	or	ax, L_SHIFT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb1:
	cmp	ax, 00aah	; L_SHIFT up
	jnz	@@kb2
	mov	ax, [keyb_status]
	and	ax, NL_SHIFT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb2:
	cmp	ax, 0036h	; R_SHIFT down
	jnz	@@kb3
	mov	ax, [keyb_status]
	or	ax, R_SHIFT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb3:
	cmp	ax, 00b6h	; R_SHIFT up
	jnz	@@kb4
	mov	ax, [keyb_status]
	and	ax, NR_SHIFT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb4:
	cmp	ax, 001dh	; L_CTRL down
	jnz	@@kb5
	mov	ax, [keyb_status]
	or	ax, L_CTRL
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb5:
	cmp	ax, 009dh	; L_CTRL up
	jnz	@@kb6
	mov	ax, [keyb_status]
	and	ax, NL_CTRL
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb6:
	cmp	ax, 0e01dh	; R_CTRL down
	jnz	@@kb7
	mov	ax, [keyb_status]
	or	ax, R_CTRL
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb7:
	cmp	ax, 0e09dh	; R_CTRL up
	jnz	@@kb8
	mov	ax, [keyb_status]
	and	ax, NR_CTRL
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb8:
	cmp	ax, 0038h	; L_ALT down
	jnz	@@kb9
	mov	ax, [keyb_status]
	or	ax, L_ALT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb9:
	cmp	ax, 00b8h	; L_ALT up
	jnz	@@kb10
	mov	ax, [keyb_status]
	and	ax, NL_ALT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb10:
	cmp	ax, 0e038h	; R_ALT down
	jnz	@@kb11
	mov	ax, [keyb_status]
	or	ax, R_ALT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb11:
	cmp	ax, 0e0b8h	; R_ALT up
	jnz	@@kb12
	mov	ax, [keyb_status]
	and	ax, NR_ALT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb12:
	cmp	ax, 003ah	; CAPS_LOCK up
	jnz	@@kb13
	mov	ax, [keyb_status]
	xor	ax, CAPS_LOCK
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb13:
	cmp	ax, 00bah	; CAPS_LOCK down
	jnz	@@kb14
	jmp	keyb_putq_exit
@@kb14:
	cmp	ax, 0046h	; SCR_LOCK up
	jnz	@@kb15
	mov	ax, [keyb_status]
	xor	ax, SCR_LOCK
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb15:
	cmp	ax, 00c6h	; SCR_LOCK down
	jnz	@@kb16
	jmp	keyb_putq_exit
@@kb16:
	cmp	ax, 0045h	; NUM_LOCK up
	jnz	@@kb17
	mov	ax, [keyb_status]
	xor	ax, NUM_LOCK
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb17:
	cmp	ax, 00c5h	; NUM_LOCK down
	jnz	@@kb18
	jmp	keyb_putq_exit
@@kb18:
	cmp	ax, 0e052h	; INSERT up
	jnz	@@kb19
	mov	ax, [keyb_status]
	xor	ax, INSERT
	mov	[keyb_status], ax
	jmp	keyb_putq_exit
@@kb19:
	cmp	ax, 0e0d2h	; INSERT down
	jnz	@@kb20
	jmp	keyb_putq_exit
@@kb20:

	test	ax, 0080h	; 䨫㥬 ⦠ 
	jnz	keyb_putq_exit

	mov	al, 0ffh	; ⠭ ਧ
	mov	[key_flag], al	; ⮢  ⥭
				; ᨬ  ""
keyb_putq_exit:
	pop	ax
	ret
ENDP	Keyb_PutQ

; -----------------------------------------------------
; ணࠬ 뢠, ।祭  ⥭
; ᨬ   .  ᢮ 㭪
;  뢠 INT 16h ॠ쭮 ०.
;  AX 頥 ᪠- ⮩ ,
;  BX - ﭨ ४ .
; -----------------------------------------------------

PROC	Int_30h_Entry	 NEAR

	push	dx		; 頥 뢠 
	cli			; 뢠 ਧ 
	mov	al, 0		; ⮢ ᪠-
	mov	[key_flag], al	;   

;  室 뢠  .
; 楤 ୮ 뢠 ⠭
; ਧ  ६ key_flag.

keyb_int_wait:
	sti		; ࠧ蠥 뢠
	nop		;  뢠
	nop
	cli			; 頥 뢠
	mov	al, [key_flag]	;  訢 䫠
	cmp	al, 0		; ⮢ ᪠-
	jz	keyb_int_wait

	mov	al, 0		; 뢠 䫠
	mov	[key_flag], al	; ⮢

	mov	ax, [key_code]	  ; 뢠 ᪠-
	mov	bx, [keyb_status] ;  ﭨ ४
				  ; 

	sti			; ࠧ蠥 뢠
	pop	dx
	iret
ENDP	Int_30h_Entry



; -------------------------------------------
;	TIMER section
; -------------------------------------------


DATASEG

	timer_cnt dw	0

CODESEG

PROC	Timer_int	 NEAR
	cli
	push	ax

; 稢 ᮤন 稪 ६

	mov	ax, [timer_cnt]
	inc	ax
	mov	[timer_cnt], ax

; ਬ୮ ࠧ  ᥪ㭤 뤠 㪮 ᨣ

	test	ax, 0fh
	jnz	timer_exit

	call	beep

timer_exit:

; 뫠   뢠

	mov	al,EOI
	out	MASTER8259A,al

	pop	ax
	sti
	iret
ENDP	Timer_int

; --------------------------------------------------
; 楤 㦨 ஫
; --------------------------------------------------

DATASEG
	columns db	80d
	rows	db	25d
	rl_crt	dw	COLOR_SEG
	vir_crt dw	CRT_DESCR
	curr_line	dw	0d
	text_buf	db	"          "
CODESEG

; -----------------------------------------
; ।  
; -----------------------------------------

PROC	set_crt_base	NEAR
	mov	ax,40
	mov	es,ax
	mov	bx,[WORD es:4a]
	mov	[columns],bl
	mov	bl,[BYTE es:84]
	inc	bl
	mov	[rows],bl
	mov	bx,[WORD es:PORT_6845]
	cmp	bx,COLOR_PORT
	je	color_crt
	mov	[rl_crt],MONO_SEG
	mov	[vir_crt],MDA_DESCR
color_crt:
	ret
ENDP	set_crt_base

; -------------------------------------
;  ப  
; -------------------------------------

PROC	writexy		NEAR
	push	si
	push	di
	mov	dl,[columns]
	mul	dl
	add	ax,bx
	shl	ax,1
	mov	di,ax
	mov	ah,dh
write_loop:
	lodsb	
	stosw
	loop	write_loop	
	pop	di
	pop	si
	ret
ENDP	writexy

; ---------------------------------------
; ࠭ ࠭ ( ॠ쭮 ०)
; ---------------------------------------

PROC	clrscr		NEAR
	xor	cx,cx	
	mov	dl,[columns]
	mov	dh,[rows]
	mov	ax,0600
	int	10
	ret
ENDP	clrscr

DATASEG

hello_msg db " Protected mode monitor *TINY/OS*, v.1.1 for CPU 80286   (C) Frolov A.V., 1992 "

CODESEG

; ------------------------------------
; 뢮 砫쭮 ᮮ饭 
;  񭭮 ०
; ------------------------------------

PROC	write_hello_msg	NEAR
	mov	ax,[vir_crt]
	mov	es,ax
	mov	si,OFFSET hello_msg
	mov	bx,0
	mov	ax,[curr_line]
	inc	[curr_line]
	mov	cx,SIZE hello_msg
	mov	dh,30h
	call	writexy
	call	beep
	ret
ENDP	write_hello_msg

; ----------------------------------------------
; 楤 뢮  ࠭ ᮤন AX
;	(x,y) = (bh, bl)
; ----------------------------------------------

PROC Print_Word near

	push ax
     	push bx
	push dx

	push ax
	mov cl,8
	rol ax,cl
	call Byte_to_hex
	mov	[text_buf], dh
	mov	[text_buf+1], dl

	pop ax
	call Byte_to_hex
	mov	[text_buf+2], dh
	mov	[text_buf+3], dl

	mov	si, OFFSET text_buf
	mov	dh, 70h
	mov	cx, 4
	mov	al, bh
	mov	ah, 0

	mov	bh, 0
	call	writexy
	
	pop dx
	pop bx
	pop ax
	ret
ENDP Print_Word


DATASEG

tabl db '0123456789ABCDEF'

CODESEG

; -----------------------------------------
; ८ࠧ   ⭠
; ᨬ ଠ
; al - 室 
; dx - 室 ᫮
; -----------------------------------------

PROC Byte_to_hex near

 	push 	cx
	push 	bx

	mov	bx, OFFSET tabl

	push 	ax
	and 	al,0fh
	xlat
	mov 	dl,al

	pop 	ax
	mov 	cl,4
	shr 	al,cl
	xlat
	mov 	dh,al

	pop bx
	pop cx
	ret

ENDP Byte_to_hex

DATASEG

reg_title	db " CS    IP    AX    BX    CX    DX    SP    BP    SI    DI   "
;		     ....  ....  ....  ....  ....  ....  ....  ....
sreg_title	db " DS    ES    SS    FLAGS                                    "
;		     ....  ....  ....  ....  ....  ....  ....  ....

CODESEG

; ------------------------------------------------
; 뢮  ࠭ ᮤন ॣ஢ 
; ------------------------------------------------

PROC	rdump NEAR

	pushf
	pusha

	mov	di, es

	mov	ax,[vir_crt]
	mov	es,ax
	mov	si,OFFSET reg_title
	mov	bx,1			; (X,Y) = (AX,BX)
	mov	ax,6
	mov	cx,SIZE reg_title
	mov	dh,1fh			;   㡮 䮭
	call	writexy

; 뢮 ᮤন  ॣ஢

	mov 	ax,cs        	; cs
	mov	bx, 0702h
	call	Print_Word

	mov	bp, sp

	mov 	ax, [bp+18d]   	; ip
	mov	bx, 0708h
	call 	Print_Word

	mov	bx, 070eh
	mov 	ax,[bp+14d]	; ax
	call	Print_Word

	mov	bx, 0714h
	mov 	ax,[bp+8d]	; bx
	call 	Print_Word

	mov	bx, 071ah
	mov 	ax,[bp+12d]	; cx
	call 	Print_Word

	mov	bx, 0720h
	mov 	ax,[bp+10d]	; dx
	call 	Print_Word

	mov 	ax,bp
	add 	ax,20d		; sp
	mov	bx, 0726h
	call 	Print_Word

	mov 	ax,[bp+4d]	; bp
	mov	bx, 072ch
	call 	Print_Word

	mov	bx, 0732h
	mov 	ax,[bp+2]	; si
	call 	Print_Word

	mov	bx, 0738h
	mov 	ax, [bp]	; di
	call 	Print_Word

	mov	si,OFFSET sreg_title
	mov	bx,1
	mov	ax,8
	mov	cx,SIZE sreg_title
	mov	dh,1fh
	call	writexy

	mov	bx, 0902h
	mov 	ax, ds		; ds
	call 	Print_Word

	mov	bx, 0908h
	mov 	ax, di		; es
	call 	Print_Word

	mov	bx, 090eh
	mov 	ax,ss		; ss
	call 	Print_Word

	mov	bx, 0914h
	mov 	ax, [bp+16d]	; flags
	call 	Print_Word

; ⠭ ᮤন ॣ஢

	popa
	popf
	ret
ENDP	rdump


CSEG_SIZE	= ($ - start)

DATASEG

DSEG_SIZE	= ($ - DSEG_BEG)

wrong	db	?
	END	start
