#define word unsigned int

// , ।  GDT

#define CODE_SELECTOR      	0x08 // ᥣ 
#define DATA_SELECTOR      	0x10 // ᥣ 

#define TASK_1_SELECTOR    	0x18 //  TASK_1
#define TASK_2_SELECTOR    	0x20 //  TASK_2
#define MAIN_TASK_SELECTOR 	0x28 //  

#define VID_MEM_SELECTOR   	0x30 // ᥣ 
#define IDT_SELECTOR				0x38 // ⠫ IDT

#define KEYBIN_TASK_SELECTOR 	0x40 //    
#define KEYB_TASK_SELECTOR  	0x48 //  ࠡ⪨
											  // ୮ 뢠
#define FLIP_TASK_SELECTOR  	0x50 //  FLIP_TASK

//  㯠

typedef struct {
	 unsigned accessed   : 1;
	 unsigned read_write : 1;
	 unsigned conf_exp   : 1;
	 unsigned code       : 1;
	 unsigned xsystem    : 1;
	 unsigned dpl      	: 2;
	 unsigned present    : 1;
	 } ACCESS;

//  ਯ

typedef struct descriptor {
	word limit;
	word base_lo;
	unsigned char base_hi;
	unsigned char type_dpl;
	unsigned reserved;
} descriptor;

//  ⨫ 맮, , 뢠,
// ᪫祭

typedef struct gate {
	word offset;
	word selector;
	unsigned char count;
	unsigned char type_dpl;
	word reserved;
} gate;

//  ᥣ ﭨ  TSS

typedef struct tss {
	word link;		//  ⭮ 裡

	word sp0;		// 㪠⥫ ⥪  0
	word ss0;
	word sp1;		// 㪠⥫ ⥪  1
	word ss1;
	word sp2;		// 㪠⥫ ⥪  1
	word ss2;

	word ip;			// ॣ 
	word flags;
	word ax;
	word cx;
	word dx;
	word bx;
	word sp;
	word bp;
	word si;
	word di;
	word es;
	word cs;
	word ss;
	word ds;
	word ldtr;
} tss;

//  ᥣ⮢  

#define TSS_SIZE            (sizeof(tss))
#define DESCRIPTOR_SIZE     (sizeof(descriptor))
#define GATE_SIZE           (sizeof(gate))
#define IDT_SIZE            (sizeof(idt))

// ᪨    梥⭮
//  ஬ ஢

#define COLOR_VID_MEM       0xb8000L
#define MONO_VID_MEM        0xb0000L

// থ

#define MONO_MODE           0x07 // ஬
#define BW_80_MODE          0x02 // ஬, 80 ᨬ
#define COLOR_80_MODE       0x03 // 梥⭮, 80 ᨬ

// 祭   㯠

#define TYPE_CODE_DESCR     0x18
#define TYPE_DATA_DESCR     0x10
#define TYPE_TSS_DESCR      0x01
#define TYPE_CALL_GATE      0x04
#define TYPE_TASK_GATE      0x85
#define TYPE_INTERRUPT_GATE 0x86
#define TYPE_TRAP_GATE      0x87

#define SEG_WRITABLE        0x02
#define SEG_READABLE        0x02
#define SEG_PRESENT_BIT     0x80

// ⠭  ࠡ⪨ 
// 뢠

#define EOI 					0x20
#define MASTER8259A 			0x20
#define SLAVE8259A 			0xa0

//   ନ஢ 䨧᪮
//    ᥣ 
//  ᬥ饭

#define MK_LIN_ADDR(seg,off) (((unsigned long)(seg))<<4)+(word)(off)

//  㪠⥫  㭪 ⨯ void  ࠬ஢

typedef void (func_ptr)(void);
