; ===================================================
; ⨭ 2. 樠  맮 ࠩ IPX/SPX
;  ipxdrv.asm
;
; (C) A. Frolov, 1993
; ===================================================

.286
.MODEL SMALL

; ---------------------------------------
;   맮 ࠩ IPX/SPX
; ---------------------------------------

	IPXSPX_REGS struc
		rax	dw ?
		rbx	dw	?
		rcx	dw	?
		rdx	dw	?
		rsi	dw	?
		rdi	dw	?
		res	dw	?
	IPXSPX_REGS ends

.DATA

; 窠 室  ࠩ IPX/SPX

_ipxspx_drv_entry	dd ?

.CODE

	PUBLIC 	_ipxspx_entry, _ipx_init
	PUBLIC 	_ipxspx_drv_entry

; ---------------------------------------
; 楤, 뢠 ࠩ IPX/SPX
; ---------------------------------------

_ipxspx_entry PROC FAR

; ⮢ BP  樨 ࠬ 㭪樨

		push	bp
		mov  	bp,sp

; ࠭塞 ॣ, ⠪  ࠩ IPX/SPX
;  ᮤন ࠪ᪨  ॣ஢

		push	es
		push	di
		push	si
		push	dx
		push	cx
		push	bx
		push	ax

; 㦠 ॣ  ,
;  ன ।  ࠬ

		push	ds
		mov 	bx, [bp+6]   ; ᬥ饭
		mov	ds, [bp+8]   ; ᥣ
		mov	es, ds:[bx].res
		mov	di, ds:[bx].rdi
		mov	si, ds:[bx].rsi
		mov	dx, ds:[bx].rdx
		mov	cx, ds:[bx].rcx
		mov	ax, ds:[bx].rax
		mov	bx, ds:[bx].rbx
		pop	ds

; 뢠 ࠩ IPX/SPX

		call	[dword ptr _ipxspx_drv_entry]

; ࠭塞 ॣ

		push	ds
		push	dx
		mov	dx, bx

; 뢠   ᮤন ॣ஢
; ᫥ 맮 ࠩ

		mov 	bx, [bp+6]	 ; ᬥ饭
		mov	ds, [bp+8]   ; ᥣ
		mov	ds:[bx].rax, ax
		mov	ds:[bx].rcx, cx
		mov	ds:[bx].rbx, dx
		pop	dx
		mov	ds:[bx].rdx, dx
		pop	ds

; ⠭ ॣ

		pop	ax
		pop	bx
		pop	cx
		pop	dx
		pop	si
		pop	di
		pop	es

		pop 	bp
		retf
_ipxspx_entry ENDP

; ---------------------------------------------
; 楤 樠樨 ࠩ IPX/SPX
; ---------------------------------------------

_ipx_init PROC NEAR
		push	bp
		mov  	bp,sp

; ।塞 稥 ࠩ  ⥬
;    室

		mov	ax, 7a00h
		int	2fh

; ᫨ ࠩ , 蠥 楤

		cmp	al, 0ffh
		jne	_ipx_init_exit

; ࠭塞  窨 室

		mov	word ptr _ipxspx_drv_entry+2, es
		mov	word ptr _ipxspx_drv_entry, di

_ipx_init_exit:

;  ॣ AX -  襭 楤

		mov	ah, 0
		pop 	bp
		ret
_ipx_init ENDP

end