// ===================================================
// ⨭ 20.   ࠡ  NETBIOS
//
//  netbios.hpp
//
// (C) A. Frolov, 1993
// ===================================================

//  NETBIOS

//   ࠡ  

#define NB_WAddName 0x30
#define NB_AddName 0xb0
#define NB_WAddGroupName 0x36
#define NB_AddGroupName 0xb6
#define NB_WDeleteName 0x31
#define NB_DeleteName 0xb1

//   । ⠣ࠬ

#define NB_WSendDatagram 0x20
#define NB_SendDatagram 0xa0
#define NB_WSendBroadcastDatagram 0x22
#define NB_SendBroadcastDatagram 0xa2

//   ਥ ⠣ࠬ

#define NB_WReceiveDatagram 0x21
#define NB_ReceiveDatagram 0xa1
#define NB_WReceiveBroadcastDatagram 0x23
#define NB_ReceiveBroadcastDatagram 0xa3

//   ࠡ  

#define NB_WCall 0x10
#define NB_Call 0x90
#define NB_WListen 0x11
#define NB_Listen 0x91
#define NB_WHangUp 0x12
#define NB_HangUp 0x92

//   ।   

#define NB_WSend 0x14
#define NB_Send 0x94
#define NB_WSendNoAck 0x71
#define NB_SendNoAck 0xf1

#define NB_WChainSend 0x17
#define NB_ChainSend 0x97
#define NB_WChainSendNoAck 0x72
#define NB_ChainSendNoAck 0xf2

//   ਥ   

#define NB_WReceive 0x15
#define NB_Receive 0x95
#define NB_WReceiveAny 0x16
#define NB_ReceiveAny 0x96

// 稥 

#define NB_WResetAdapter 0x32
#define NB_WCancel 0x35
#define NB_WSessionStatus 0x34
#define NB_SessionStatus 0xb4


//  NCB  ࠡ   NETBIOS

class NCB {

// ⠭  NCB  ଠ NETBIOS

	struct _NCB {
		unsigned char Cmd;
		unsigned char CCode;
		unsigned char LocalSessionNumber;
		unsigned char NetworkNameNumber;
		void far *Buffer;
		unsigned Size;
		char CallName[16];
		char OurName[16];
		unsigned char ReceiveTimeout;
		unsigned char SendTimeout;
		void interrupt (*PostRoutine)(void);
		unsigned char AdapterNumber;
		unsigned char FinalCCode;
		unsigned char Reserved[14];
	} ncb;
	struct SREGS sregs;
	union REGS regs;
	unsigned errno;

// 㭪  맮 NETBIOS

	void NetBios(void) {
		sregs.es = FP_SEG(&ncb);
		regs.x.bx = FP_OFF(&ncb);
		int86x(0x5c, &regs, &regs, &sregs);
	}

public:

// , ᯨ뢠 ncb ﬨ

	NCB() {
		memset(&ncb, 0, sizeof(ncb));
		errno = 0;
	}

// 㭪 頥  訡

	int Error(void) {return errno;}

// 㭪   

	void WAddName(char *name);

// 㭪  㤠 

	void WDeleteName(char *name);

// 㭪  ।  

	unsigned GetNetworkNameNumber(void)
		{ return(ncb.NetworkNameNumber); }

// 㭪  ⠭   ࠧ 

	void SetBuffer(char far *Buf,	unsigned BufSize) {
		ncb.Buffer = Buf;
		ncb.Size = BufSize;
	}

// ⠭  ncb  뢠 ⭥

	void SetCallName(char *name);

// ਥ ⠣ࠬ  

	void WReceiveDatagram(int NetwrkNameNumber) {

// 塞   ᢮ 

		ncb.NetworkNameNumber = NetwrkNameNumber;

// 뢠 NETBIOS

		ncb.Cmd = NB_WReceiveDatagram;
		NetBios();
	}

// । ⠣ࠬ  

	void WSendDatagram(int NetwrkNameNumber) {

// 塞   ᢮ 

		ncb.NetworkNameNumber = NetwrkNameNumber;
		ncb.Cmd = NB_WSendDatagram;

// 뢠 NETBIOS

		NetBios();
	}

};

