// ===================================================
// ⨭ 5.1. 㭪樨 IPX.
//
//  ipx.c
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdio.h>
#include <stdlib.h>
#include <dos.h>
#include "ipx.h"

/**
* .Name    IntSwap
*
* .Title    ⮢  ᫮
*
* .Descr   㭪  ⠬   ᫮,
*          ஥ ।   ⢥ ࠬ
*
* .Params  unsigned i - ८ࠧ㥬 ᫮
*
* .Return  ८ࠧ ᫮
**/

unsigned IntSwap(unsigned i) {
	return((i>>8) | (i & 0xff)<<8);
}

/**
* .Name    IPXOpenSocket
*
* .Title    ᮪
*
* .Descr      㭪 뢠 ᮪, ⨯ ண
*          ।  १ ࠬ SocketType.
*             । 맮 室 ⮢  
*          ᫮     祭 뢠
*          ᮪ ( , ᫨ 㦥 ᪨ ᮪).
*           ᫮ । १ ࠬ Socket.
*             ᫨ 뢠 ᪨ ᮪, 
*          祭 㤥 ᠭ   Socket.
*
* .Params  int SocketType - ⨯ ᮪:
*                    0x00 - ⪮騩;
*                    0xFF - 騩.
*
*          unsigned *Socket - 㪠⥫  ᫮,
*                     ஬ 室 
*                    뢠 ᮪  ,
*                    ᫨ 㦥 ᪨ ᮪.
*
* .Return  0 - ᮪  ᯥ譮;
*          0xFE - ९ ⠡ ᮪⮢;
*          0xFF - ⠪ ᮪ 㦥 .
**/

int IPXOpenSocket(int SocketType, unsigned *Socket) {

	struct IPXSPX_REGS iregs;

	iregs.bx = IPX_CMD_OPEN_SOCKET;
	iregs.dx = IntSwap(*Socket);
	iregs.ax = SocketType;
	ipxspx_entry( (void far *)&iregs );

	*Socket = IntSwap(iregs.dx);
	return(iregs.ax);
}

/**
* .Name    IPXCloseSocket
*
* .Title    ᮪
*
* .Descr      㭪 뢠 ᮪.
*             । 맮 室 ⮢  
*          ᫮     祭 뢠
*          ᮪.  ᫮ । १ ࠬ Socket.
*
* .Params  unsigned *Socket - 㪠⥫  ᫮,
*                     ஬ 室 
*                    뢠 ᮪.
*
* .Return  祣
**/

void IPXCloseSocket(unsigned *Socket) {

	struct IPXSPX_REGS iregs;

	iregs.bx = IPX_CMD_CLOSE_SOCKET;
	iregs.dx = IntSwap(*Socket);
	ipxspx_entry( (void far *)&iregs );
}

/**
* .Name    IPXListenForPacket
*
* .Title   ਭ 
*
* .Descr      㭪 ⠢ ECB  ਥ
*            . ⥫  ECB ।
*          १ ࠬ RxECB.
*
* .Params  struct ECB *RxECB - 㪠⥫  ECB,
*                      ਥ .
*
* .Return  祣
**/

void IPXListenForPacket(struct ECB *RxECB) {

	struct IPXSPX_REGS iregs;

	iregs.es = FP_SEG((void far*)RxECB);
	iregs.si = FP_OFF((void far*)RxECB);
	iregs.bx = IPX_CMD_LISTEN_FOR_PACKET;
	ipxspx_entry( (void far *)&iregs );
}

/**
* .Name    IPXSendPacket
*
* .Title   । 
*
* .Descr      㭪 ⠢ ECB  ।
*          . ⥫  ECB । १
*          ࠬ TxECB.
*
* .Params  struct ECB *TxECB - 㪠⥫  ECB,
*                      । .
*
* .Return  祣
**/

void IPXSendPacket(struct ECB *TxECB) {

	struct IPXSPX_REGS iregs;

	iregs.es = FP_SEG((void far*)TxECB);
	iregs.si = FP_OFF((void far*)TxECB);
	iregs.bx = IPX_CMD_SEND_PACKET;
	ipxspx_entry( (void far *)&iregs );
}

/**
* .Name    IPXRelinquishControl
*
* .Title   । ࠢ IPX  
*
* .Descr      㭪 ᯮ  
*          襭 ਥ १   InUse
*           ECB.
*
* .Params   ᯮ
*
* .Return  祣
**/

void IPXRelinquishControl(void) {

	struct IPXSPX_REGS iregs;

	iregs.bx = IPX_CMD_RELINQUISH_CONTROL;
	ipxspx_entry( (void far *)&iregs );
}
