// ===================================================
// ⨭ 4. 㭪樨  ணࠬ SLIST.CPP
//
//  slist!\sap.cpp
//
// (C) A. Frolov, 1993
// ===================================================

#include <stdlib.h>
#include <stdio.h>
#include <mem.h>
#include <string.h>
#include <dos.h>
#include "sap.hpp"

// ====================================================
//   SLIST
// ====================================================

SLIST::SLIST(int ServiceType) {

// ஢塞 稥 ⥢ 窨 
// ।塞  

	MajorVersion = 0;

	asm push si
	GetNetWareShellVersion(&MajorVersion,
			&MinorVersion, &Revision);
	asm pop si

// ᫨ 窠  㦥, 蠥 ࠡ
// ணࠬ  ᮮ饭  訡

	if(MajorVersion == 0) {
		printf("\n窠 NetWare  㦥\n");
		errno = 0xff;
		return;
	}

// ஢塞 ⨯ SAP-

	if (ServiceType != 1 && ServiceType != 3)	{
		errno = NOT_SUPPORTED;
		return;
	}

//  ⨯ 

	QueryType = ServiceType;

// 樠㥬 ࠩ ⮪ IPX

	IPXInitialize();

// 뢠 ⪮騩 ᪨ ᮪

	SrcSocket = 0x00;
	errno = IPXOpenSocket(&SrcSocket, SHORT_LIVED);

// 塞 ⠡  ࢥ஢ ﬨ

	memset(ServerName,0,sizeof(ServerName));

// ⠢  ECB  ਥ
// ⮢  SAP-⮪

	for(int i=0;i<MAX_SERVERS;i++) {

// 塞  ECB

		 ReceiveSAPPacket(&Query[i]);

// ⠢  ।  ਥ 

		 IPXListenForPacket(&Query[i].theECB);
	}

// ᫨  뫮 訡, 뫠 

	if (!errno) {
		SendSAPPacket();

//  ਬ୮  ᥪ㭤

		sleep(1);

// ९뢠  ࢥ஢  
// ଠ

		GetServersName();
		GetServersInfo();
	}
}

// ====================================================
//   SLIST
// ====================================================

SLIST::~SLIST() {

// ⬥塞 騥  ECB

	 for(int i=0;i<MAX_SERVERS;i++) {
		 IPXCancelEvent(&Query[i].theECB);
	 }

// 뢠 ᮪

	 IPXCloseSocket(SrcSocket);
}

// ====================================================
// 뫪 SAP-
// ====================================================

void SLIST::SendSAPPacket(void) {

// 뢠  inUseFlag  ESRAddress,
// ⠭ ⨯  0

	SendPacket.theECB.inUseFlag = 0;
	SendPacket.theECB.ESRAddress = 0;
	SendPacket.SAPq.packetType = 0;

// SAP- ⮨   ࠣ.
// 뢠  ECB ⢮ ࠣ⮢,
//   ࠧ 

	SendPacket.theECB.fragmentCount = 1;
	SendPacket.theECB.fragmentDescriptor[0].address =
			&SendPacket.SAPq;
	SendPacket.theECB.fragmentDescriptor[0].size =
			sizeof(SAPQueryPacket);

// 뢠  ECB  ᢮ ᮪

	SendPacket.theECB.socketNumber = SrcSocket;

// ⠭  祭 -  ⠭樨
//  ⥪饩 , ᮪ SAP_SOCKET.
// ⠭  ।⢥ 

	memset(SendPacket.SAPq.destination.network, '\x00', 4);
	memset(SendPacket.SAPq.destination.node, '\xFF', 6);
	SendPacket.SAPq.destination.socket = IntSwap(SAP_SOCKET);
	memset(SendPacket.theECB.immediateAddress, '\xFF', 6);

// ⠭ ᢮    

	IPXGetInternetworkAddress(SendPacket.SAPq.source.network);
	SendPacket.SAPq.source.socket = IntSwap(SrcSocket);

// 塞 । . ⠭ ⨯ 
//  ⨯ ࢥ

	SendPacket.SAPq.queryType = IntSwap(QueryType);
	SendPacket.SAPq.serverType = IntSwap(0x0004);

// 뫠 SAP-

	IPXSendPacket(&SendPacket.theECB);

//  襭  । 

	while (SendPacket.theECB.inUseFlag)
		 IPXRelinquishControl();

// ࠭塞  

	errno = SendPacket.theECB.completionCode;
}

// ====================================================
// ਥ SAP-⮢
// ====================================================

void  SLIST::ReceiveSAPPacket(RECEIVE_PACKET	*Query) {

// 뢠  inUseFlag  ESRAddress

	Query->theECB.inUseFlag = 0;
	Query->theECB.ESRAddress = 0;

// 뢠  ECB ⢮ ࠣ⮢,
//   ࠧ 

	Query->theECB.fragmentCount = 1;
	Query->theECB.fragmentDescriptor[0].address =
				&Query->SB;
	Query->theECB.fragmentDescriptor[0].size =
				sizeof(Query->SB);

// ⠭  ECB ᢮  ᮪

	Query->theECB.socketNumber = SrcSocket;
}

// ====================================================
// 楤 ९뢠  ࢥ஢  
//  ECB,   諨 
// ====================================================

void  SLIST::GetServersName(void) {

	for(int i=0,j=0; i<MAX_SERVERS; i++) {
		if(!Query[i].theECB.inUseFlag) {
			strcpy(ServerName[j],Query[i].SB.ServerName);
			j++;
		}
	}
}

// ====================================================
// 楤 砥 ଠ  ࢥ
// ====================================================

void  SLIST::GetServersInfo(void) {

// 砥   ࢨ筮 ࢥ
//  ࢥ  㬮砭

	PrimaryConnID   = GetPrimaryConnectionID();
	DefaultConnID   = GetDefaultConnectionID();

//   ᥬ 㦥   ⨢ ࢥࠬ

	for(int i=0; i<MAX_SERVERS; i++) {
		if(ServerName[i][0]) {

// 砥   ࢥ

			errno = GetConnectionID(ServerName[i], &ConnID[i]);

// ᫨  , ᮧ ,   ࢥ

			if(errno) {
				AttachToFileServer(ServerName[i], &ConnID[i]);
			}

//  ⥪騩 ࢥ ।⥫, ⠪ 
//     㯠 

			errno = SetPreferredConnectionID(ConnID[i]);

// 砥 ଠ  ⥪饬 ࢥ

			if(!errno)
				errno = GetServerInformation(sizeof(ServerInfo[i]),
								&ServerInfo[i]);

// 砥 ਩    ਫ

			SerialNumber[i]=ApplicationNumber[i]=0L;
			errno = GetNetworkSerialNumber(&SerialNumber[i],
			 &ApplicationNumber[i]);
			errno = 0;
		}
	}
}

// ====================================================
// 楤 ᯥ뢠   
// ଠ  ࢥ
// ====================================================

void  SLIST::PrintServersName(void) {

//   ᥬ 㦥   ⨢ ࢥࠬ

	for(int i=0; i<MAX_SERVERS; i++) {
		if(ServerName[i][0]) {

// 뢮  ࢥ

			printf("%s",ServerInfo[i].serverName);

// ᫨   ⥪饣 ࢥ ᮢ 
// ஬  ࢨ筮 ࢥ, 뢮
// ப "\t[Primary]"

			if(ConnID[i] == PrimaryConnID)
				printf("\t[Primary]");
			else
				printf("\t[       ]");

// ᫨   ⥪饣 ࢥ ᮢ 
// ஬  ࢥ  㬮砭, 뢮
// ப " [Default]"

			if(ConnID[i] == DefaultConnID)
				printf(" [Default]");
			else
				printf(" [       ]");

// 뢮  ⥢ 樮 ⥬,
// ࠡ饩  ⥪饬 ࢥ

			printf(" v.%d.%d, ",
				ServerInfo[i].netwareVersion,
				ServerInfo[i].netwareSubVersion);

//  祭 ࢥ஢ 뢮 ਩
//    ਫ

			if(SerialNumber[i] != 0L)
				printf("s/n %08.8lX/%04.4X",
					SerialNumber[i], ApplicationNumber[i]);
			else
				printf("- Not Logged In -");

// 뢮  , ᯮ㥬  裡
//  ⥪騬 ࢥ஬

			printf("\tConnID: %d,",ConnID[i]);

// 뢮 ᨬ쭮 ᫮ , ন
// ࢥ஬,  ⢮ ᯮ㥬 

			printf(" (%d-%d)\n",
				ServerInfo[i].maxConnectionsSupported,
				ServerInfo[i].connectionsInUse);
		}
	}
}

