unit uSQR;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Buttons, ExtCtrls, Mask, ComCtrls;

type
  TfmEx = class(TForm)
    panelButtons: TPanel;
    panelParam: TPanel;
    bbClose: TBitBtn;
    bbOk: TBitBtn;
    sbA: TScrollBar;
    sbB: TScrollBar;
    sbC: TScrollBar;
    lA: TLabel;
    lB: TLabel;
    lC: TLabel;
    lbView: TLabel;
    lbX1: TLabel;
    lbX2: TLabel;
    pbGraph: TPaintBox;
    tbMul: TTrackBar;
    eA: TEdit;
    eB: TEdit;
    eC: TEdit;
    procedure FormCreate(Sender: TObject);
    procedure sbAChange(Sender: TObject);
    procedure sbBChange(Sender: TObject);
    procedure sbCChange(Sender: TObject);
    procedure tbMulChange(Sender: TObject);
    procedure pbGraphPaint(Sender: TObject);
    procedure eAChange(Sender: TObject);
    procedure eBChange(Sender: TObject);
    procedure eCChange(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  fmEx          : TfmEx;
  A,B,C,x1,x2,d : Real;
  Mul           : Byte = 5;

Procedure ViewSQR;

implementation

{$R *.dfm}

Procedure ViewSQR;
Var s : String;
  Procedure DrawGraf;
  Var
    i     : Real;
    Xi,Yi : Integer;
  Begin
    With fmEx.pbGraph.Canvas do
    Begin
      fmEx.pbGraph.Color:=clWhite;
      FillRect(Rect(0,0,fmEx.pbGraph.Width,fmEx.pbGraph.Height));
      fmEx.pbGraph.Canvas.Pen.Color:=clGray;
      MoveTo(fmEx.pbGraph.Width div 2,0);
      LineTo(fmEx.pbGraph.Width div 2,fmEx.pbGraph.Height-1);
      MoveTo(0,fmEx.pbGraph.Height div 2+1);
      LineTo(fmEx.pbGraph.Width-1,fmEx.pbGraph.Height div 2+1);

      MoveTo(fmEx.pbGraph.Width div 2-3,0+5);
      LineTo(fmEx.pbGraph.Width div 2,0);
      LineTo(fmEx.pbGraph.Width div 2+3,0+6);
      MoveTo(fmEx.pbGraph.Width-1-5,fmEx.pbGraph.Height div 2+1-3);
      LineTo(fmEx.pbGraph.Width-1,fmEx.pbGraph.Height div 2+1);
      LineTo(fmEx.pbGraph.Width-1-6,fmEx.pbGraph.Height div 2+1+3);

      Xi:=(fmEx.pbGraph.Width div 2) mod Mul;
      Repeat
        MoveTo(Xi,fmEx.pbGraph.Height div 2+1-3);
        LineTo(Xi,fmEx.pbGraph.Height div 2+1+3);
        Xi:=Xi+Mul;
      Until Xi>=fmEx.pbGraph.Width-6;

      i:=fmEx.sbA.Min;
      fmEx.pbGraph.Canvas.Pen.Color:=clBlue;
      While i<=fmEx.sbA.Max do
      Begin
        Xi:=Round(i*Mul)+(fmEx.pbGraph.Width div 2);
        Yi:=-Round(a*i*i+b*i+c)+(fmEx.pbGraph.Height div 2);
        If ((Xi>=0) and (Xi<fmEx.pbGraph.Width)) and
         ((Yi>=0) and (Yi<fmEx.pbGraph.Height)) then
             LineTo(Xi,Yi)
         else
             MoveTo(Xi,Yi);
        i:=i+0.1;
      End;
    End;
  End;

Begin
  s:='';
  If A<>0 then
    s:=FloatToStr(A)+'x^2';
  If (B>=0) and (A<>0) then s:=s+'+';
  s:=s+FloatToStr(B)+'x';
  If C>=0 then s:=s+'+';
  s:=s+FloatToStr(C)+'=0';
  fmEx.lbView.Caption:=s;
  D:=b*b-4*a*c;
  If (D>=0) and (A<>0) then
  Begin
    x1:=(-B+SQRT(d))/(2*a);
    x2:=(-B-SQRT(d))/(2*a);
    fmEx.lbx1.Caption:='x1 = '+FloatToStr(x1);
    fmEx.lbx2.Caption:='x2 = '+FloatToStr(x2);
  End
    else
  Begin
    If A<>0 then
    Begin
      fmEx.lbx1.Caption:='    !';
      fmEx.lbx2.Caption:='( <0 )'
    End
    else
    Begin
      fmEx.lbx1.Caption:='';
      fmEx.lbx2.Caption:='( A=0    ! )';
    End;  
  End;
  DrawGraf;       { }
End;


procedure TfmEx.FormCreate(Sender: TObject);
begin
  A:=1;
  B:=2;
  C:=1;
end;

procedure TfmEx.sbAChange(Sender: TObject);
begin
  eA.Text:=IntToStr(sbA.Position);
  A:=fmEx.sbA.Position;
  ViewSQR;
end;

procedure TfmEx.sbBChange(Sender: TObject);
begin
  eB.Text:=IntToStr(sbB.Position);
  B:=fmEx.sbB.Position;
  ViewSQR;
end;

procedure TfmEx.sbCChange(Sender: TObject);
begin
  eC.Text:=IntToStr(sbC.Position);
  C:=fmEx.sbC.Position;
  ViewSQR;
end;

procedure TfmEx.tbMulChange(Sender: TObject);
begin
  Mul:=fmEx.tbMul.Position;
  ViewSQR;
end;

procedure TfmEx.pbGraphPaint(Sender: TObject);
begin
  ViewSQR;
end;

procedure TfmEx.eAChange(Sender: TObject);
Var k : Real;
begin
  k:=0;
  If (eA.Text='') or (eA.Text='-') then Exit;
  Try
    k:=StrToFloat(eA.Text);
  Except
    exit;
  End;
  A:=k;
  ViewSQR;
end;

procedure TfmEx.eBChange(Sender: TObject);
Var k : Real;
begin
  k:=0;
  If (eB.Text='') or (eB.Text='-') then Exit;
  Try
    k:=StrToFloat(eB.Text);
  Except
    exit;
  End;
  B:=k;
  ViewSQR;
end;

procedure TfmEx.eCChange(Sender: TObject);
Var k : Real;
begin
  k:=0;
  If (eC.Text='') or (eC.Text='-') then Exit;
  Try
    k:=StrToFloat(eC.Text);
  Except
    exit;
  End;
  C:=k;
  ViewSQR;
end;

end.
