unit DrawTitl; //    
interface
uses windows;

const
  LensDelta = 4;
type
  pbarray = ^array[0..1023]of byte;
  TXlatOfs = Array[0..0] Of longint;
var
  dx, dy          : longint; //  / 
  bi              : bitmapinfo;       //   BMP-
  bih             : bitmapinfoheader absolute bi;
  bufMain         : pbarray;    //    dx*dy*bpp
  x1l,x1r,y1t,y1b : longint; //   ,     
  x2l,x2r,y2t,y2b : longint; //   ,     

procedure InitTitle; //    
Procedure InitLens; //  
procedure DrawScreen; //    
Procedure DrawLens; //     
procedure DrawTitle; //      
procedure InitScreen; //     
procedure DoneLens; //   
procedure DoneTitle; //   
procedure DoneScreen; //       

implementation
const
  LensRadius = 120; //  
  bpp = 4; //         
  FireAdd = 28; //             .   
  ProbabilityVertGor = 5; //   .   
  ProbabilityChangeDir = 1; //  ,        
  PaletteRange = 64;//256; //      bufFire^
  FireMask = 255 - ((PaletteRange - 1) shr 5);
var
  bufMain_d : ^TXlatOfs absolute bufMain;
  bufScrn   : pbarray;    //     dx*dy*bpp
  bufScrn_d : ^TXlatOfs absolute bufScrn;
  LensOld   : ^TXlatOfs;  //    ( )  
  LensNew   : ^TXlatOfs;  //    ( )  
  bufTitl   : pbarray;    //   
  bufTitl_d : ^TXlatOfs absolute bufTitl;
  bufFire   : pbarray;    //     - 1    dxf*dyf
  Palette   : array[0..1023]of byte; //   ,  
  Palette_d : array[0..255]of dword absolute Palette;
  PalTrns_d : array[0..255]of dword; //    (   )
  dxt, dyt  : longint;    //    
  dxf, dyf  : longint;    //    
  TotalOfs  : longInt; //      
  LensX, LensY   : longInt; //    
  dLensX, dLensY : longInt; //     
  FlameDirection : longint = 0; //  : 0 - , 1 - 

procedure InitTitle; //    
var
  f : file;
  i,j,k,line : longint;
  p : pbarray;
begin
  j := SizeofResource(0,FindResource(0,MakeIntResource(107),RT_BITMAP{RT_RCDATA}));
  p := LockResource(LoadResource(0,FindResource(0,MakeIntResource(107),RT_BITMAP)));
  move(p^[4],dxt,sizeof(longint));
  move(p^[8],dyt,sizeof(longint));
  line := ((dxt + 7) div 8 + 3) and $FFFC;
  getmem(bufTitl,dxt*dyt*bpp);
  for j := 0 to dyt-1 do begin
    k := 48 + j*line; //    
    for i := 0 to dxt-1 do begin
      if (p^[(i div 8)+k] and ($80 shr (i mod 8))) = 0 then
        bufTitl_d^[i + j*dxt] := 0
      else
        bufTitl_d^[i + j*dxt] := $00ffffff;
    end;
  end;
  dxf := dxt + FireAdd;
  dyf := dyt + FireAdd;
  getmem(bufFire,dxf*dyf*bpp);
  fillchar(bufFire^,dxf*dyf*bpp,0);
  for i := 0 to PaletteRange div 2 -1 do begin // -- ,  0,0..254,255..255
    j := i*(512 div PaletteRange);
    palette[i*4                  + 0] := 0;
    palette[i*4                  + 1] := j;
    palette[i*4                  + 2] := 255;
    palette[i*4 + PaletteRange*2 + 0] := j;
    palette[i*4 + PaletteRange*2 + 1] := 255;
    palette[i*4 + PaletteRange*2 + 2] := 255;
    j := j div 2; //      :    =>   7  8
    PalTrns_d[i]                      := j + (j shl 16);
    PalTrns_d[i + PaletteRange div 2] := $00ff00ff;
  end;
  x2l := (dx-dxt) div 2;
  x2r := x2l + dxf-1;
  y2b := (dy-dyt) div 2;
  y2t := y2b + dyf-1;
end;

Procedure InitLens; //  
Var
  i,j,X,Y : longint;
  s,k : single;
const
  k1 = 0.25;
  k2 = 0.25;
Begin
  LensX := dy div 2 + 23;
  LensY := dy div 2 - 3;
  dLensX := LensDelta;
  dLensY := LensDelta;
  getmem(LensOld,16*LensRadius*LensRadius);
  getmem(LensNew,16*LensRadius*LensRadius);
  TotalOfs := 0;
  For j := -LensRadius To LensRadius-1 Do
    For i := -LensRadius To LensRadius-1 Do Begin
      k := sqrt(i*i + j*j)/LensRadius;
      if k <= 1 then begin
        S := 1 - Sin(Pi*sqrt(k)) * k1 - k2;
        X := round(i*S);
        Y := round(j*S);
        LensOld^[TotalOfs] := X + Y*dx; //     
        LensNew^[TotalOfs] := i + j*dx; //     
        Inc(TotalOfs);{}
      end;
    End;{}
End;

procedure DrawScreen; //    
var j : longint;
begin
  if y1b < 0 then y1b := 0;
  if y1t > (dy-1) then y1t := (dy-1);
  for j := y1b to y1t do
    move(bufScrn_d^[x1l + j*dx],bufMain_d^[x1l + j*dx],(x1r-x1l+1)*bpp);
  for j := y2b to y2t do
    move(bufScrn_d^[x2l + j*dx],bufMain_d^[x2l + j*dx],(x2r-x2l+1)*bpp);
end;

Procedure DrawLens; //     
Var
  d,i : longint;
Begin
  d := LensX + LensY*dx;
  For i := 0 To TotalOfs-1 Do
    bufMain_d^[d + LensNew^[i]] := bufScrn_d^[d + LensOld^[i]];
  x1l := LensX - LensRadius;
  y1b := LensY - LensRadius;
  x1r := LensX + LensRadius - 1;
  y1t := LensY + LensRadius - 1;
  Inc( LensX, dLensX);
  Inc( LensY, dLensY);
  If ( LensX <= (LensRadius+LensDelta)) Or (LensX >= (dx-LensRadius-dLensX)) Then dLensX := -dLensX;
  If ( LensY <= (LensRadius+LensDelta)) Or (LensY >= (dy-LensRadius-dLensY)) Then dLensY := -dLensY;
End;

procedure DrawTitle; //      
type
   qword = array[0..3]of word;
const
  mm_zero : qword = (0,0,0,0); {0  MMX }
var
  i,j,ofsxy,d,d4,dt,df,bdf,ddf : longint;
  pal1,pal2 : longint;
  FireSamp : dword;
  FireTrns : dword;
begin
  ofsxy := ((dx-dxt) div 2) + ((dy-dyt) div 2)*dx;
  for j := 1 to dyt-2 do
    for i := 1 to dxt-2 do begin  //        
      dt := i + j*dxt;
      df := i + j*dxf;
      if bufTitl_d^[dt] = 0 then
        bufFire^[df] := random(2)*(PaletteRange-1);
    end;{}
  if random(ProbabilityChangeDir) = 0 then  //    
    if random(ProbabilityVertGor) = 0 then
      FlameDirection := 1
    else
      FlameDirection := 0;
  if FlameDirection = 0 then //     
    ddf := dxf
  else
    ddf := 1;
  for j := 1 to dyf-2 do begin
    df := j*dxf;
    d4 := ofsxy + j*dx;
    for i := 1 to dxf-2 do begin
      inc(df);
      bufFire^[df+ddf] := (bufFire^[df+1] + bufFire^[df-1] + bufFire^[df-dxf] + bufFire^[df+dxf]) shr 2 and FireMask;
      bdf := bufFire^[df];
      inc(d4);
      pal1 := PalTrns_d[bdf];        //     palette2
      pal2 := $00800080 - pal1; //    1 (128  256 ..   7,    8)
      FireSamp := Palette_d[bdf]; //     (1/2, 1/3, 1/4)
      asm
        mov  eax, d4     //   
        movq mm7, mm_zero     // 0000000000000000      0
        shl  eax, 2
        movd mm1, pal1        // aa00aa0000000000     2 
        add  eax, bufMain
        movd mm2, pal2        // dd00dd0000000000   ( d = 256 - a )    1
        movd mm0, [eax]       // bbggrraa00000000   
        punpcklwd mm1,mm1     // aa00aa00aa00aa00     00XX => XXXX
        movd mm4, FireSamp    // bbggrraa00000000      
        punpcklbw mm0,mm7     // bb00gg00rr00aa00  
        punpcklbw mm4,mm7     // bb00gg00rr00aa00       10203040
        punpcklwd mm2,mm2     // dd00dd00dd00dd00    00XX => XXXX
        pmullw    mm4,mm1     //palette[bufFire^[df]*4  ]*pal1
        pmullw    mm0,mm2     // bufMain_d^[d4]*pal2
        paddsw    mm0,mm4     //     
        psrlw     mm0,7       //    128
        packuswb  mm0,mm7
        movd [eax],mm0
      end; //asm
    end;
  end;
  for j := 1 to dyt-2 do begin
    d4 := ofsxy + j*dx; //    d4 := ofsxy + i + j*dx;
    dt := j*dxt; //     dt := i + j*dxt;
    for i := 1 to dxt-2 do begin
      if (bufTitl_d^[i + dt] = 0) then begin
        bufMain_d^[i + d4] := $ff0000;
      end;
    end;
  end;{}
  asm
    emms
  end;
end;

procedure InitScreen; //     
var
  hDCScr, hDCMem  : hdc;
  hBmMem, hBmOld  : HBITMAP;
  fResult : boolean;
begin
//  
  dx                := GetSystemMetrics(SM_CXSCREEN);
  dy                := GetSystemMetrics(SM_CYSCREEN);
  bih.biSize        := sizeof(BITMAPINFOHEADER);
  bih.biWidth       := dx;
  bih.biHeight      := dy;
  bih.biCompression := BI_RGB;
  bih.biBitCount    := bpp*8;
  bih.biClrUsed     := 16777216; // 2 ^ 24
  bih.biPlanes      := 1;
  bih.biSizeImage   := dx*dy*bpp;
//  DC 
  hDCScr := GetDC(0);
//    GDI DC   BMP
  hDCMem := CreateCompatibleDC(hDCScr);
  hBmMem := CreateCompatibleBitmap(hDCScr, dx, dy);
  hBmOld := SelectObject(hDCMem, hBmMem);
//  
  if( SetStretchBltMode(hDCMem, HALFTONE)) = 0 then
    SetStretchBltMode(hDCMem, COLORONCOLOR);
  StretchBlt(hDCMem, 0, 0, dx, dy, hDCScr, 0, 0, dx, dy, SRCCOPY);
  ReleaseDC(NULL, hDCScr);
  fResult := TRUE;
  if(hDCMem <> NULL) and (hBmMem <> NULL) then begin
//     BitMap
    getmem(bufScrn, bih.biSizeImage);
    if (bufScrn <> nil) then begin
//  BitMap  
      GetDIBits(hDCMem, hBmMem, 0, dy, bufScrn, bi, DIB_RGB_COLORS);
//      end else fResult := FALSE;
    end else fResult := FALSE;
  end else fResult := FALSE;
  SelectObject(hDCMem, hBmOld);
  DeleteDC(hDCMem);
  DeleteObject(hBmMem);

  getmem(bufMain,bih.biSizeImage);
  move(bufScrn^,bufMain^,bih.biSizeImage);
end;

procedure DoneLens; //   
begin
  freemem(LensNew,16*LensRadius*LensRadius);
  freemem(LensOld,16*LensRadius*LensRadius);
end;

procedure DoneTitle; //   
begin
  freemem(bufFire,dxf*dyf*bpp);
  freemem(bufTitl,dxt*dyt*bpp);
end;

procedure DoneScreen; //       
begin
  freemem(bufScrn,bih.biSizeImage);
  freemem(bufMain,bih.biSizeImage);
end;

end.