{ ⥢  (2:5017/11.40)  NETMAIL (SU.PASCAL.MODULA.ADA) 
 Msg  : 594 of 639                          Trs                                 
 From : Illya Belov                         2:5070/26.210   p 26  99 15:38 
 To   : All                                 2:5017/5.40      29  99 05:52 
 Subj : DDG (3d)                                                                

ਢ, All.


=== Cut ===
{
                      ᪠ 


  Coded by Dasaev
}
Unit Phong;

Interface

Const

   Name  =  '᪠ ';

Procedure RunPhong;

Implementation

Uses DemoVga,Crt,Effect;

Const
   TorePixel1 = 9;    { ⢮ 祪  ७ 㦭 }
   TorePixel2 = 16;   { ⢮ 祪   㦭 }

Type
   P3Point = ^T3Point;
   T3Point = Record
    X,Y,Z : LongInt;
   End;

   PRealVector = ^TRealVector;
   TRealVector = Record
    X,Y,Z : Real;
   End;

   PFace = ^TFace;
   TFace = Array[1..4] Of Word;

   PPointsArray = ^TPointsArray;
   TPointsArray = Array[0 .. TorePixel1 * TorePixel2 + 1] Of T3Point;

   PFacesArray = ^TFacesArray;
   TFacesArray = Array[0 .. TorePixel1 * TorePixel2 + 1] Of TFace;

   PPhongMap = ^TPhongMap;
   TPhongMap = Array[0..254, 0..255] Of Byte;

   PMem = ^TMem;
   TMem = Array[0..65534] Of Byte;

Const
   LightVector : TRealVector = (X : 0;Y : 0;Z : 1);

Var
  Points, RotPts : PPointsArray;
  FaceNormals,VertexNormals : PPointsArray;
  RotVertexNormals : PPointsArray;
  Faces : PFacesArray;
  Color : Byte;
  a,b,t : Word;
  MainPhongMap : PPhongMap;
  PhongMap1,PhongMap2 : PPhongMap;

Procedure CalcPhongMap;
Var
 SinTab : Array[0..255] Of Real;
 I,J : Integer;
Begin
 New( PhongMap1);
 New( PhongMap2);
 For I := 0 To 255 Do
  SinTab[ I] := Sqr( Sqr( Sin( I * Pi / 256)));
 For I := 0 To 255 Do
  For J := 0 To 255 Do Begin
   PhongMap1^[ I][ J] := Round( SinTab[ I] * SinTab[ J] * 59);
   PhongMap2^[ I][ J] := PhongMap1^[ I][ J] + 60;
  End;
End;

Procedure VectTo1( Vect : T3Point; Var W : TRealVector);
Var
  Len : Real;
Begin
 Len := Sqrt( Sqr( Vect.X) + Sqr( Vect.Y) + Sqr( Vect.Z));
 W.X := Vect.X / Len;
 W.Y := Vect.Y / Len;
 W.Z := Vect.Z / Len;
End;

Procedure PhongHLine( X1, X2, Y, U1, V1, U2, V2 : Integer);
Var
  I,Len : Integer;
  dU,dV : Integer;
  O1,O : Word;

  Procedure Swap( Var A,B : Integer);
  Var
    C : Integer;
  Begin
   C := B; B := A; A := C;
  End;

Begin
 If( X1 > X2) Then Begin
  Swap( X1, X2);
  Swap( U1, U2);
  Swap( V1, V2);
 End;
 Len := X2 - X1 + 1;
 dU := (U2 - U1) Div Len;
 dV := (V2 - V1) Div Len;
 O1 := Y * 320 + X1;
 For I := 0 To Len Do Begin
  O := U1 And $FF00 + V1 Div 256;
  PMem( DBuffer)^[ O1] := PMem( MainPhongMap)^[ O];
  Inc( O1);
  Inc( U1, dU);
  Inc( V1, dV);
 End;
End;

Procedure CalcNormals;
Var
  I,J : Integer;
  V : T3Point;

  Procedure CalcNormalVector( P1, P2, P3 : T3Point;Var Normal : T3Point);
  Var Ax,Ay,Az,Bx,By,Bz : Integer;
  Begin
   Ax := P2.X - P1.X;
   Ay := P2.Y - P1.Y;
   Az := P2.Z - P1.Z;
   Bx := P3.X - P1.X;
   By := P3.Y - P1.Y;
   Bz := P3.Z - P1.Z;
   Normal.X := (Ay * Bz) - (Az * By);
   Normal.Y := (Az * Bx) - (Ax * Bz);
   Normal.Z := (Ax * By) - (Ay * Bx);
  End;

Begin
 { 뢠 ଠ  ࠭ }
 For I := 0 To TorePixel1 * TorePixel2-1 Do
  CalcNormalVector( Points^[ Faces^[I][1]], Points^[ Faces^[I][2]], Points^[
Faces^[I][3]],
                    FaceNormals^[ I]);
 { 뢠 ଠ   設 }
 For I := 0 To TorePixel1 * TorePixel2-1 Do Begin
  V.X := 0; V.Y := 0; V.Z := 0;
  For J := 0 To TorePixel1 * TorePixel2-1 Do
   If (Faces^[J][1] = I) Or (Faces^[J][2] = I) Or
      (Faces^[J][3] = I) Or (Faces^[J][4] = I) Then Begin
    V.X := V.X + FaceNormals^[J].X;
    V.Y := V.Y + FaceNormals^[J].Y;
    V.Z := V.Z + FaceNormals^[J].Z;
   End;
  VertexNormals^[I].X := V.X Div 4;
  VertexNormals^[I].Y := V.Y Div 4;
  VertexNormals^[I].Z := V.Z Div 4;
 End;
End;

{ 頥 ᫨ X ⥫쭮   -1 }
{ ᫨ X ⥫쭮 +1  0      }
Function SignInt(X : Integer) : Integer;
InLine($5A/                    { Pop   DX         }
       $B8/$00/$00/            { Mov   AX,0 }
       $83/$FA/$00/            { Cmp   DX,0 }
       $74/$06/             { Je    @Ex  }
       $7F/$03/             { Jg    @L1  }
       $2D/$02/$00/            { Sub   AX,2 }
       $40                {@L1: Inc   AX         }
      );                {@Ex:                 }

Procedure PhongTriangle( X1,Y1,U1,V1,X2,Y2,U2,V2,X3,Y3,U3,V3 : Integer);
Type
  PEdge = ^TEdge;
  TEdge = Record
   YDir,CurX,YLen,CurY,StepX,ErrX,AddErrX,SubErrX,XDir : Integer;
   CurU,CurV,dU,dV : Integer;
  End;

Var
 Left,Right : PEdge;

 Function SetUpEdge( X1, Y1, U1, V1, X2, Y2, U2, V2 : Integer; Var Edge :
PEdge) : Boolean;
 Var T,XLen : Integer;
 Begin
  XLen := X2 - X1;
  With Edge^ Do Begin
   YLen := Y2 - Y1;
   If YLen = 0 Then Begin
    SetUpEdge := False;
    Exit;
   End;
   If YLen < 0 Then YDir := -1 Else YDir := 1;
   YLen := Abs( YLen);
   CurY := Y1;
   CurX := X1;
   CurU := U1 * 256;
   CurV := V1 * 256;
   dU := (U2 - U1) * 256 Div YLen;
   dV := (V2 - V1) * 256 Div YLen;
   StepX := XLen Div YLen;
   If XLen > 0 Then Begin
    XDir := 1; ErrX := 0;
   End
   Else Begin
    XDir := -1; ErrX := 1 - YLen;
    XLen := -XLen;
   End;
   AddErrX := XLen Mod YLen;
   SubErrX := YLen;
  End;
  SetUpEdge := True;
 End;

 Function ScanEdge(Var Edge : PEdge) : Boolean;
 Begin
  With Edge^ Do Begin
   Dec( YLen);
   If YLen >= 0 Then Begin
    Inc( CurY, YDir);
    Inc( CurX, StepX);
    Inc( ErrX, AddErrX);
    Inc( CurU, dU);
    Inc( CurV, dV);
    If ErrX > 0 Then Begin
     Dec( ErrX, SubErrX);
     Inc( CurX, XDir);
    End;
    ScanEdge := True;
   End
   Else ScanEdge := False;
  End;
 End;

 Procedure RunScan( X1, Y1, U1, V1, X2, Y2, U2, V2, X3, Y3, U3, V3 : Integer);
 Begin
  If SignInt( Y2-Y1) <> SignInt( Y3-Y1) Then Exit;
  If (Not SetUpEdge( X1, Y1, U1, V1, X2, Y2, U2, V2, Left)) Or (Not SetUpEdge(
X1, Y1, U1, V1, X3, Y3, U3, V3, Right)) Then
   Begin
    PhongHLine( X2, X3, Y1, U2, V2, U3, V3);
    Exit;
   End;
  Repeat
   PhongHLine( Left^.CurX, Right^.CurX, Left^.CurY,
               Left^.CurU, Left^.CurV, Right^.CurU, Right^.CurV);
  Until (Not ScanEdge( Left)) Or (Not ScanEdge( Right));
 End;

Begin
 New( Left);
 New( Right);
 RunScan( X1, Y1, U1, V1, X2, Y2, U2, V2, X3, Y3, U3, V3);
 RunScan( X2, Y2, U2, V2, X1, Y1, U1, V1, X3, Y3, U3, V3);
 RunScan( X3, Y3, U3, V3, X1, Y1, U1, V1, X2, Y2, U2, V2);
 Dispose( Right);
 Dispose( Left);
End;

Procedure CalcTore;
Var
  I,J,CurPt,RightPt,RightDownPt,DownPt : Integer;
  G1,G2,CX,CY : Real;
Begin
 G1 := TorePixel2 / (2 * Pi);
 G2 := TorePixel1 / (2 * Pi);
 For I := 0 To TorePixel2-1 Do Begin        {    p㦭 }
  CX:= Cos( I / G1) * 65;
  CY:= Sin( I / G1) * 65;
  For J := 0 To TorePixel1-1 Do
   With Points^[ I * TorePixel1 + J] Do Begin
    X := Round(CX + Cos( J / G2) * Cos( I / G1) * 30);
    Y := Round(CY + Cos( J / G2) * Sin( I / G1) * 30);
    Z := Round(Sin( J / G2) * 30);
   End;
 End;
 For I := 0 To TorePixel2-1 Do
  For J := 0 To TorePixel1-1 Do Begin
   CurPt       := I * TorePixel1 + J;
   RightPt     := I * TorePixel1 + J + 1;
   RightDownPt := I * TorePixel1 + J + 1 + TorePixel1;
   DownPt      := I * TorePixel1 + J + TorePixel1;
   If J = TorePixel1-1 Then Begin
     RightPt :=  I * TorePixel1;
     RightDownPt := (I + 1) * TorePixel1;
   End;
   If I = TorePixel2-1 Then Begin
    Dec( RightDownPt,(I + 1) * TorePixel1);
    Dec( DownPt, (I + 1) * TorePixel1);
   End;
   Faces^[I * TorePixel1 + J][1] := CurPt;
   Faces^[I * TorePixel1 + J][2] := RightPt;
   Faces^[I * TorePixel1 + J][3] := RightDownPt;
   Faces^[I * TorePixel1 + J][4] := DownPt;
  End;
End;


Procedure DrawFigure( NumFace : Integer );
Var I,J : Integer;
    X1,X2,Y1,Y2,X3,Y3,X4,Y4 : LongInt;
    N1,N2,N3,N4 : Integer;
    U1,V1,U2,V2,U3,V3,U4,V4 : LongInt;
    T1,T2,W1,W2 : Integer;
    K,MinZ,N : Integer;
    Tmp : TFace;
    W : TRealVector;

Begin
 { 㥬 ࠭  㤠 }
 For I := 0 To NumFace-1 Do Begin
  MinZ := RotPts^[ Faces^[I][1]].Z + RotPts^[ Faces^[I][2]].Z + RotPts^[
Faces^[I][3]].Z;
  N := I;
  For J := I To NumFace-1 Do Begin
   K := RotPts^[ Faces^[J][1]].Z + RotPts^[ Faces^[J][2]].Z + RotPts^[
Faces^[J][3]].Z;
   If K < MinZ Then Begin MinZ := K; N := J; End;
  End;
  Tmp := Faces^[I];
  Faces^[I] := Faces^[N];
  Faces^[N] := Tmp;
 End;
 { 㥬 䨣 }
 For I := 0 To NumFace-1 Do Begin
  N1 := Faces^[I][1];
  N2 := Faces^[I][2];
  N3 := Faces^[I][3];
  N4 := Faces^[I][4];
  X1 := RotPts^[ N1 ].X;  Y1 := RotPts^[ N1 ].Y;
  X2 := RotPts^[ N2 ].X;  Y2 := RotPts^[ N2 ].Y;
  X3 := RotPts^[ N3 ].X;  Y3 := RotPts^[ N3 ].Y;
  X4 := RotPts^[ N4 ].X;  Y4 := RotPts^[ N4 ].Y;
  T1 := X4 - X1;  T2 := X2 - X1;
  W1 := Y4 - Y1;  W2 := Y2 - Y1;

  VectTo1( RotVertexNormals^[ N1], W);
  U1 := Round( W.X * 128 + 128); V1 := Round( W.Y * 128 + 128);
  VectTo1( RotVertexNormals^[ N2], W);
  U2 := Round( W.X * 128 + 128); V2 := Round( W.Y * 128 + 128);
  VectTo1( RotVertexNormals^[ N3], W);
  U3 := Round( W.X * 128 + 128); V3 := Round( W.Y * 128 + 128);
  VectTo1( RotVertexNormals^[ N4], W);
  U4 := Round( W.X * 128 + 128); V4 := Round( W.Y * 128 + 128);

  If (T1*W2 - T2*W1) > 0 Then Begin
   MainPhongMap := PhongMap1;
   PhongTriangle( 160+X1, 100-Y1, U1, V1, 160+X2, 100-Y2, U2, V2, 160+X3,
100-Y3, U3, V3);
   MainPhongMap := PhongMap2;
   PhongTriangle( 160+X1, 100-Y1, U1, V1, 160+X3, 100-Y3, U3, V3, 160+X4,
100-Y4, U4, V4);
  End;
 End;
End;

Procedure RotateCords( a, b, t : Word; NumPts : Word);
Var I : Integer;
    alpha,beta,theta : Real;

  Procedure RotatePoint( Point : T3Point; Var RPoint : T3Point);
  Var  X,Y,Z,X1,Y1,Z1 : Real;
  Begin
   X := Point.X;
   Y := Point.Y;
   Z := Point.Z;
   { p  X }
   Y1 := Y*Cos(alpha)-Z*Sin(alpha);
   Z1 := Y*Sin(alpha)+Z*Cos(alpha);
   Y := Y1; Z := Z1;
   { p  Y }
   X1 := X*Cos(beta)+Z*Sin(beta);
   Z1 := -X*Sin(beta)+Z*Cos(beta);
   X := X1; Z := Z1;
   { p  Z }
   X1 := X*Cos(theta)-Y*Sin(theta);
   Y1 := X*Sin(theta)+Y*Cos(theta);
   X := X1; Y := Y1;
   RPoint.X := Round( X);
   RPoint.Y := Round( Y);
   RPoint.Z := Round( Z);
  End;

Begin
 alpha := a * Pi/180;
 beta := b * Pi/180;
 theta := t * Pi/180;
 For I := 0 To NumPts-1 Do
  RotatePoint( Points^[ I], RotPts^[ I]);
 For I := 0 To NumPts-1 Do
  RotatePoint( VertexNormals^[ I], RotVertexNormals^[ I]);
End;

Procedure RunPhong;
Var
  I,J : Integer;
Begin
 InitDemoPart;
 New( Points);
 New( RotPts);
 New( Faces);
 New( FaceNormals);
 New( VertexNormals);
 New( RotVertexNormals);
 CalcTore;
 CalcNormals;
 For I := 0 To 63 Do SetRGBColor( I, I, I, 0);
 For I := 0 To 63 Do SetRGBColor( 60 + I, I, Round( I / 1.1 + 5), I);
 CalcPhongMap;
 a := 0; b := 0; t := 0;
 ClearDBuffer;
 Repeat
  ClearDBuffer;
  RotateCords( a, b, t, TorePixel1 * TorePixel2);
  Inc( a, 6);
  If a > 360 Then Dec( a, 360);
  Inc( b, 4);
  If b > 360 Then Dec( b, 360);
  Inc( t, 5);
  If t > 360 Then Dec( t, 360);
  DrawFigure( TorePixel1 * TorePixel2);
  DBuff2Video;
 Until KeyPressed;
 ReadKey;
 Dispose( PhongMap2);
 Dispose( PhongMap1);
 Dispose( RotVertexNormals);
 Dispose( VertexNormals);
 Dispose( FaceNormals);
 Dispose( Faces);
 Dispose( RotPts);
 Dispose( Points);
 RestoreDemo;
End;

Begin
 RegisterEffect( 'PHONG.PAS', RunPhong, Chapter3D, Name);
End.




=== Cut ===

 㢠, Illya.

--- GoldED/386 3.00.Beta5+
 * Origin: .+.=., .+.+.+.+.+.=? (2:5070/26.210)

