{ ⥢  (2:5017/11.40)  NETMAIL (SU.PASCAL.MODULA.ADA) 
 Msg  : 590 of 639                          Trs                                 
 From : Illya Belov                         2:5070/26.210   p 26  99 15:38 
 To   : All                                 2:5017/5.40      29  99 05:52 
 Subj : DDG (3d)                                                                

ਢ, All.


=== Cut ===
{

 Coded by Dasaev
}
Unit TexMap2;

Interface

Const

  Name        =  'ਠ ⥪७  ⨭  䠩';

Procedure RunTexMapCube2;

Implementation

Uses DemoVga,Crt,bmplib,Effect;

Const
 S = 80;

Type
   P3Point = ^T3Point;
   T3Point = Record
    X,Y,Z : LongInt;
   End;

   PFace = ^TFace;
   TFace = Array[1..4] Of Word;

   PPointsArray = ^TPointsArray;
   TPointsArray = Array[1 .. 8] Of T3Point;

   PFacesArray = ^TFacesArray;
   TFacesArray = Array[1 .. 6] Of TFace;

   PTextureMap = ^TTextureMap;
   TTextureMap = Array[0 .. S,0 .. S-1] Of Byte;

   PMem = ^TMem;
   TMem = Array[0..65534] Of Byte;

Const
   Points : TPointsArray =
    ( (X : -S;Y : -S;Z : S), (X : -S;Y : S;Z : S),
      (X : S;Y : S;Z : S), ( X : S;Y : -S; Z : S),
      (X : -S;Y : -S;Z : -S), (X : -S;Y : S;Z : -S),
      (X : S;Y : S;Z : -S), ( X : S;Y : -S; Z : -S));

   Faces : TFacesArray =
    ( (1,2,3,4), (3,2,6,7), (2,1,5,6), (1,4,8,5), (4,3,7,8), (8,7,6,5));

   TexMapCord : Array[1..4] Of Record           { न  ⥪ }
    X,Y : Integer;
   End =
    ( (X : 0; Y : 0), (X : S; Y : 0), (X : S; Y : S), (X : 0; Y : S));

Var
  RotPts : PPointsArray;
  a,b,t : Word;
  TMap : PTextureMap;
  p : array[0..768]of byte;

Procedure CreateTexture;
Var
  I,J : Integer;
Begin
 New( TMap);
 readbmp(@(tmap^),80,80,@p,'le4.bmp');
 for i := 0 to 255 do SetRgbColor(i,p[i*3],p[i*3+1],p[i*3+2]);
{ For I := 0 To S Do
  For J := 0 To S-1 Do Begin
   TMap^[I][J] := ((S Div 2 - I) * (S Div 2 - I) + (S Div 2 - J) * (S Div 2 -
J)) Div 6;
  End;
  for i := 0 to s-1 do tmap^[i][i] := 0;}

End;

{ 頥 ᫨ X ⥫쭮   -1 }
{ ᫨ X ⥫쭮 +1  0      }
Function SignInt(X : Integer) : Integer;
InLine($5A/                    { Pop   DX         }
       $B8/$00/$00/            { Mov   AX,0 }
       $83/$FA/$00/            { Cmp   DX,0 }
       $74/$06/             { Je    @Ex  }
       $7F/$03/             { Jg    @L1  }
       $2D/$02/$00/            { Sub   AX,2 }
       $40                {@L1: Inc   AX         }
      );                {@Ex:                 }

Procedure TexMapHLine( X1, X2, Y : Integer; TX1,TY1,TX2,TY2 : Integer);
Var
  I,L : Integer;
  dX,dY : Integer;
  O,O1 : Word;

  Procedure Swap( Var A,B : Integer);
  Var C : Integer;
  Begin
   C := A; A := B; B := C;
  End;

Begin
 If( Y < 0) Or (Y > 199) Then Exit;
 If( X1 > X2) Then Begin
  Swap( X1, X2);
  Swap( TX1, TX2);
  Swap( TY1, TY2);
 End;
 L := X2 - X1 + 1;
 dX := (TX2 - TX1) Div L;
 dY := (TY2 - TY1) Div L;
 O := Y * 320 + X1;
 For I := 1 To L Do Begin
  O1 := TX1 Div 256 + TY1 Div 256 * S;
  PMem( DBuffer)^[ O] := PMem( TMap)^[ O1];
  Inc( O);
  Inc( TX1, dX);
  Inc( TY1, dY);
 End;
End;

Procedure Triangle( X1,Y1,X2,Y2,X3,Y3,P1,P2,P3 : Integer);
Type
  PEdge = ^TEdge;
  TEdge = Record
   YDir,CurX,YLen,CurY,StepX,ErrX,AddErrX,SubErrX,XDir : Integer;
   TexX,TexY,dTX,dTY : Integer;
  End;

Var
 Left,Right : PEdge;

 Function SetUpEdge( X1, Y1, X2, Y2, P1, P2 : Integer; Var Edge : PEdge) :
Boolean;
 Var T,XLen : Integer;
 Begin
  XLen := X2 - X1;
  With Edge^ Do Begin
   YLen := Y2 - Y1;
   If YLen = 0 Then Begin
    SetUpEdge := False;
    Exit;
   End;
   If YLen < 0 Then YDir := -1 Else YDir := 1;
   YLen := Abs( YLen);
   CurY := Y1;
   CurX := X1;
   TexX := TexMapCord[P1].X * 256;
   TexY := TexMapCord[P1].Y * 256;
   dTX := (TexMapCord[P2].X - TexMapCord[P1].X) * 256 Div YLen;
   dTY := (TexMapCord[P2].Y - TexMapCord[P1].Y) * 256 Div YLen;
   StepX := XLen Div YLen;
   If XLen > 0 Then Begin
    XDir := 1; ErrX := 0;
   End
   Else Begin
    XDir := -1; ErrX := 1 - YLen;
    XLen := -XLen;
   End;
   AddErrX := XLen Mod YLen;
   SubErrX := YLen;
  End;
  SetUpEdge := True;
 End;

 Function ScanEdge(Var Edge : PEdge) : Boolean;
 Begin
  With Edge^ Do Begin
   Dec( YLen);
   If YLen >= 0 Then Begin
    Inc( CurY, YDir);
    Inc( CurX, StepX);
    Inc( ErrX, AddErrX);
    Inc( TexX, dTX);
    Inc( TexY, dTY);
    If ErrX > 0 Then Begin
     Dec( ErrX, SubErrX);
     Inc( CurX, XDir);
    End;
    ScanEdge := True;
   End
   Else ScanEdge := False;
  End;
 End;

 Procedure RunScan( X1, Y1, X2, Y2, X3, Y3, P1, P2, P3 : Integer);
 Begin
  If SignInt( Y2-Y1) <> SignInt( Y3-Y1) Then Exit;
  If (Not SetUpEdge( X1, Y1, X2, Y2, P1, P2, Left)) Or (Not SetUpEdge( X1, Y1,
X3, Y3, P1, P3, Right)) Then
    Exit;
  Repeat
   TexMapHLine( Left^.CurX, Right^.CurX, Left^.CurY,
                Left^.TexX, Left^.TexY, Right^.TexX, Right^.TexY);
  Until (Not ScanEdge( Left)) Or (Not ScanEdge( Right));
 End;

Begin
 New( Left);
 New( Right);
 RunScan( X1, Y1, X2, Y2, X3, Y3, P1, P2, P3);
 RunScan( X2, Y2, X1, Y1, X3, Y3, P2, P1, P3);
 RunScan( X3, Y3, X1, Y1, X2, Y2, P3, P1, P2);
 Dispose( Right);
 Dispose( Left);
End;

Procedure DrawFigure;
Var I,J : Integer;
    X1,X2,Y1,Y2,X3,Y3,X4,Y4 : LongInt;
    V1,V2,W1,W2 : LongInt;
    K,MinZ,N : Integer;
    Tmp : TFace;

Begin
 { 㥬 䨣 }
 For I := 1 To 6 Do Begin
  X1 := RotPts^[ Faces[I][1] ].X;  Y1 := RotPts^[ Faces[I][1] ].Y;
  X2 := RotPts^[ Faces[I][2] ].X;  Y2 := RotPts^[ Faces[I][2] ].Y;
  X3 := RotPts^[ Faces[I][3] ].X;  Y3 := RotPts^[ Faces[I][3] ].Y;
  X4 := RotPts^[ Faces[I][4] ].X;  Y4 := RotPts^[ Faces[I][4] ].Y;
  V1 := X4 - X1;  V2 := X2 - X1;
  W1 := Y4 - Y1;  W2 := Y2 - Y1;
  If (V1*W2 - V2*W1) > 0 Then Begin
   Triangle( 160+X1, 100-Y1, 160+X2, 100-Y2, 160+X3, 100-Y3, 1, 2, 3);
   Triangle( 160+X1, 100-Y1, 160+X3, 100-Y3, 160+X4, 100-Y4, 1, 3, 4);
  End;
 End;
End;

Procedure RotateCords( a, b, t : Word);
Var I : Integer;
    X,Y,Z,X1,Y1,Z1 : Real;
    alpha,beta,theta : Real;
Begin
 alpha := a * Pi/180;
 beta := b * Pi/180;
 theta := t * Pi/180;
 For I := 1 To 8 Do Begin
  X := Points[I].X;
  Y := Points[I].Y;
  Z := Points[I].Z;
  { p  X }
  Y1 := Y*Cos(alpha)-Z*Sin(alpha);
  Z1 := Y*Sin(alpha)+Z*Cos(alpha);
  Y := Y1; Z := Z1;
  { p  Y }
  X1 := X*Cos(beta)+Z*Sin(beta);
  Z1 := -X*Sin(beta)+Z*Cos(beta);
  X := X1; Z := Z1;
  { p  Z }
  X1 := X*Cos(theta)-Y*Sin(theta);
  Y1 := X*Sin(theta)+Y*Cos(theta);
  X := X1; Y := Y1;
  RotPts^[I].X := Round( X);
  RotPts^[I].Y := Round( Y);
  RotPts^[I].Z := Round( Z);
 End;
End;

Procedure RunTexMapCube2;
Var
  I,J : Integer;
Begin
 InitDemoPart;
 New( RotPts);
 For I := 1 To 255 Do SetRGBColor( I, Round( 60 * Sin( I * Pi / 128)), Round(
60 * Sin( I * Pi / 256)), 0);
 CreateTexture;
 a := 0; b := 0; t := 0;
 Repeat
  ClearDBuffer;
  RotateCords( a, b, t);
  Inc( a, 2);
  If a > 360 Then Dec( a, 360);
  Inc( b, 3);
  If b > 360 Then Dec( b, 360);
  Inc( t, 1);
  If t > 360 Then Dec( t, 360);
  DrawFigure;
  DBuff2Video;
 Until KeyPressed;
 ReadKey;

 Dispose( TMap);
 Dispose( RotPts);
 RestoreDemo;
End;

Begin
 RegisterEffect( 'TEXMAP2.PAS', RunTexMapCube2, Chapter3D, Name);
End.




=== Cut ===

 㢠, Illya.

--- GoldED/386 3.00.Beta5+
 * Origin: .+.=., .+.+.+.+.+.=? (2:5070/26.210)

