unit ProgrBar; // ""      
interface      //    40 ""
uses windows;

function InitProgressBar(x0,y0,x1,y1:longint):longint; //     ,
//  ,   0,    
procedure UpdateProgressBar(id:longint; pos : double); //   , pos -  0.0  1.0
procedure DoneProgressBar(id:longint); //   
procedure DrawProgressBars(dc:hdc); //     

implementation

type
  ProgressBarType = record
    r : trect;    // 
    b : boolean;  // 
    pos : double; // 
  end;
const MaxNumPB = 40;
var
  PB : array[1..MaxNumPB]of ProgressBarType;

function InitProgressBar(x0,y0,x1,y1:longint):longint; //     ,  
var i,n : longint;
begin
  i := 1;
  if ((x0 + 2) > x1) or ((y0+2) > y1) then begin
    InitProgressBar := 0;
    exit;
  end;
  while PB[i].b and (i <= MaxNumPB) do inc(i);
  if i <= MaxNumPB then begin
    with PB[i] do begin
      r.left   := x0;
      r.right  := x1;
      r.top    := y0;
      r.bottom := y1;
      b        := TRUE;
      pos      := 0.0;
    end;
//    writeln('InitPB: ',i);
  end else
    InitProgressBar := 0;
end;

procedure UpdateProgressBar(id:longint; pos : double); //   
var i,j : longint;
begin
//        if id = 1 then writeln('Update ',GetTickCount:12);
  if (id > 0) and (id <= MaxNumPB) then
    if PB[id].b then begin
      if pos < 0.0 then pos := 0.0;
      if pos > 1.0 then pos := 1.0;
      PB[id].pos := pos;
    end;
end;

procedure DoneProgressBar(id:longint); //   
begin
  if (id > 0) and (id <= MaxNumPB) then
    if PB[id].b then begin
    end;
end;

procedure DrawProgressBars(dc:hdc); //     
var
  i, d, OldBkMode, OldTextColor, OldTextAlign, OldObject : longint;
  brush : hbrush;
  pen : hpen;
  r1,r2 : trect;
  rgn : hrgn;
  s : string;
//  size : tsize;
begin
  for i := 1 to MaxNumPB do
    if PB[i].b then begin
      OldBkMode := GetBkMode(dc);
      OldTextColor := GetTextColor(dc);
      OldTextAlign := GetTextAlign(dc);
      SetBkMode(dc,TRANSPARENT);
//      SetTextColor(dc,GetSysColor(COLOR_ACTIVECAPTION));
      SetTextAlign(dc,TA_CENTER or VTA_CENTER);

      with PB[i] do begin
        pen := CreatePen(dc,1,GetSysColor(COLOR_3DSHADOW));
        OldObject := SelectObject(dc,pen);
        MoveToEx(dc,r.left,r.bottom-1,nil);
        LineTo(dc,r.left,r.top);
        Lineto(dc,r.right,r.top);
        SelectObject(dc,OldObject);
        DeleteObject(pen);

        pen := CreatePen(dc,1,GetSysColor(COLOR_3DHILIGHT));
        OldObject := SelectObject(dc,pen);
        MoveToEx(dc,r.left+1,r.bottom,nil);
        LineTo(dc,r.right,r.bottom);
        Lineto(dc,r.right,r.top);
        SelectObject(dc,OldObject);
        DeleteObject(pen);{}

        d := round((r.right-r.left-1)*pos)+1;
        r1.left := r.left+1;    r1.right := r.left+d;   r1.top := r.top+1;  r1.bottom := r.bottom;
        r2.left := r.left+d;  r2.right := r.right;  r2.top := r.top+1;  r2.bottom := r.bottom;

        str(pos*100:3:1,s);
        s := s + '%';

//        if i = 1 then writeln('Draw ',GetTickCount:12,' ',s);

        with r1 do
          rgn := CreateRectRgn(left,top,right,bottom);
        SelectClipRgn(dc,rgn);
        Brush := CreateSolidBrush (GetSysColor(COLOR_ACTIVECAPTION)); {  }
        FillRect(dc,r1,brush);
        DeleteObject (Brush); {      }

        SetTextColor(dc,GetSysColor(COLOR_3DHILIGHT));
        TextOut(dc,(r1.left+r.right) div 2,r1.top,@s[1],length(s));
        deleteObject(rgn);


        with r2 do
          rgn := CreateRectRgn(left,top,right,bottom);
        SelectClipRgn(dc,rgn);
        Brush := CreateSolidBrush (GetSysColor(COLOR_3DFACE)); {  }
        FillRect(dc,r2,brush);
        DeleteObject (Brush); {      }

        SetTextColor(dc,GetSysColor(COLOR_ACTIVECAPTION));
        TextOut(dc,(r1.left+r.right) div 2,r1.top,@s[1],length(s));
        deleteObject(rgn);
      end;

      SelectClipRgn(dc,0);
      SetTextAlign(dc,OldTextAlign);
      SetTextColor(dc,OldTextColor);
      SetBkMode(dc,OldBkMode);
    end;
end;

begin
  fillchar(PB,sizeof(PB),0);
end.