Program RobotsGraph;
uses Crt;
Type
      Vector = Array [1..50] of integer; { // odnomernyj massiv }
      Matrix = Array [1..3,1..50] of integer; { // dvuhmernyj massiv }
Var
   { * OCHEREDI PUNKTOV DLYA ROBOTOV * }
      Ways: Vector; { // vektor vozmozhnyh putej }
      Was: Vector; { // zapis punktov, kot uzhe vstrechalis }
      Q: Matrix; { // matrica putej }
   { * GLOBALNYE PEREMENNYE * }
      Input: text; { // fajl s vhodnoj informaciej }
      N: integer; { // chislo punktov }
      Robots: integer; { // chislo robotov }
      WasInWays: boolean; { // vstrechalsya li punkt v spiske }
      CountOfWas: integer; { // schetchik unikalnyh putej }
      NumWays: integer; { // chislo vozmozhnyh dorog }
      RS: Array [1..50,1..50] of integer; { // matrica dorog }
      Shag: Array [1..3] of integer; { // vektor shagov robotov }
      WhereNow: Array [1..3] of integer; { // v kakom punkte sejchas }
      WhereMeet: integer; { // punkt, gde vstretyatsya }
      BestPath: Array [1..50] of integer; { // iskomyj put }
      Time: integer; { // tekuwee vremya }
      WasGathered: integer; { // 0 - ne vstretilis; 1 - vstretilis }
      i,j,k,l: integer;
      it,jt,kt: integer;

   { * BEGIN: PROCEDURY *}

{
***************************************************************
 Chtenie matricy putej iz fajla.
***************************************************************
 OPISANIE PARAMETROV:
 -------- -----------
  < N > ................ Chislo punktov;
  < RS > ............... Globalnaya matrica putej;
  < Input > ............ Identificator fajla s matricej putej;
}
Procedure ReadPaths(N:integer);
var i,j: integer;
BEGIN
for i:=1 to N do
    for j:=1 to N do
        Read(Input,RS[i,j]);
END;

{
***************************************************************
 Gde mozhet byt i-j robot v sledushij moment vremeni?
***************************************************************
 OPISANIE PARAMETROV:
 -------- -----------
  < From What > ........ Tekushee mestonahozhdenie i-go robota;
  < Step > ............. Skorost i-go robota;
  < NumWays > .......... Chislo punktov, kuda mozhet popast i-j robot;
  < WhereWill > ........ Vector vozmozhnyh putej dlya i-go robota;
}
Procedure WhereWill(FromWhat,Step:integer; var NumWays:integer; var WhereWill:Vector);
var
    i,j,k: integer;
    Row, Column: integer;
    states: integer;
BEGIN
case Step of
     1:
     begin { // BEGIN: CASE '1' }
           states:=0;
           Row:=FromWhat; { // perehodim na nachalnyj punkt }
           for j:=1 to N do
               if (RS[Row,j]=1) then
                  begin
                       states:=states+1;
                       WhereWill[states]:=j;
                  end;
     end; { // END: CASE '1' }

     2:
     begin { // BEGIN: CASE '2' }
           states:=0;
           Row:=FromWhat;
           for j:=1 to N do
               if (RS[Row,j]=1) then
                  for k:=1 to N do
                      if (RS[j,k]=1) then
                         begin
                              states:=states+1;
                              WhereWill[states]:=k;
                         end;
     end; { // END: CASE '2' }
end; { // END OF CASE}
NumWays:=states;
END;

   { * END: PROCEDURY * }

   { * BEGIN: FUNCTIONS * }

{
***************************************************************
 Proveryaet, nahodyatsya li roboty v
    dvuh punktah, svyazannyh dorogoj.
***************************************************************
 OPISANIE PARAMETROV:
 -------- -----------
  < One > .............. Tekushee mestopolozhenie 1-go robota;
  < Two > .............. Tekushee mestopolozhenie 2-go robota;
  < Three > ............ Tekushee mestopolozhenie 3-go robota;
  < JoinTwo > .......... Svyazany li dva puncta dorogoj;
}
Function JoinTwo(One,Two,Three:integer):boolean;
var
    i,j: integer;
    OneTwo,TwoThree,OneThree: boolean;
    Result: boolean;
BEGIN
JoinTwo:=FALSE;
OneTwo:=FALSE; TwoThree:=FALSE; OneThree:=FALSE;
if (One=Two) then OneTwo:=TRUE;
if (Two=Three) then TwoThree:=TRUE;
if (One=Three) then OneThree:=TRUE;

if (OneTwo=TRUE) then
   if ((RS[One,Two]=1) AND (RS[Two,One]=1)) then Result:=TRUE;
if (TwoThree=TRUE) then
   if ((RS[Two,Three]=1) AND (RS[Three,Two]=1)) then JoinTwo:=TRUE;
if (OneThree=TRUE) then
   if ((RS[One,Three]=1) AND (RS[Three,One]=1)) then JoinTwo:=TRUE;
END;

{
***************************************************************
 Proveryaet, nahodyatsya li roboty v
    punktah, iz kotoryh est dorogi v odi i to zhe punkt.
***************************************************************
 OPISANIE PARAMETROV:
 -------- -----------
  < One > .............. Tekushee mestopolozhenie 1-go robota;
  < Two > .............. Tekushee mestopolozhenie 2-go robota;
  < Three > ............ Tekushee mestopolozhenie 3-go robota;
  < WillThere > ........ Vedut li dorogi v odin punkt;
}
Function WillThere(One,Two,Three:integer):boolean;
var
    i,j: integer;
BEGIN
WillThere:=FALSE;
for j:=1 to N do
    if (RS[One,j] = 1) then
       if ((RS[Two,j]=1) AND (RS[Three,j]=1)) then
          WillThere:=TRUE;
END;

{
***************************************************************
 Proveryaet, nahodyatsya li roboty v
    3-h punktah, obrazuyushih treugolnik.
***************************************************************
 OPISANIE PARAMETROV:
 -------- -----------
  < One > .............. Tekushee mestopolozhenie 1-go robota;
  < Two > .............. Tekushee mestopolozhenie 2-go robota;
  < Three > ............ Tekushee mestopolozhenie 3-go robota;
  < Triangle > ......... Obrazuyut li punkty treugolnik;
}
Function Triangle(One,Two,Three:integer):boolean;
var
    i,j: integer;
BEGIN
Triangle:=FALSE;
if ((RS[One,Two]=1) AND (RS[Two,Three]=1) AND (RS[One,Three]=1)) then
   Triangle:=TRUE;
END;

   { * END: FUNCTIONS * }

BEGIN

ClrScr;
Assign(Input,'Robots.txt'); Reset(Input); {otkryvaem fail}
ReadLn(Input,N);

{ // Chislo punktov }
ReadPaths(N);

{ // Chislo robotov }
WriteLn('Skolko robotov?');
ReadLn(Robots);

{ // Skorosti i nachalnye polozheniya robotov }
for i:=1 to Robots do
    begin
         Writeln('>>> ',i,' ROBOT');
         Write('  Skorost ',i,'go robota: ');
         ReadLn(Shag[i]);
         Write('  Nachalnyj punkt: ');
         ReadLn(WhereNow[i]);
         WriteLn;
    end;

{ * GDE ROBOTY NAHODYATSYA SEJCHAS * }
WriteLn('>>> Where are robots right now:');
for i:=1 to Robots do
    WriteLn(i,' robot is in ',WhereNow[i]);
WriteLn;

WasGathered:=0; { // ne vstretilis }
Time:=0;

{ * PROVERKA TREH USLOVIJ SHODIMOSTI ROBOTOV * }
while (WasGathered=0) do
Begin { // OF WHILE CIRCLE }



{ * GDE MOGUT OKAZATSYA ROBOTY V SLEDUYUSHIJ MOMENT VREMENI * }
for i:=1 to Robots do
    begin
         WhereWill(WhereNow[i],Shag[i],NumWays,Ways);
         CountOfWas:=0;
         for j:=1 to NumWays do
             begin
                  WasInWays:=FALSE;
                  for k:=1 to NumWays do
                      if (Was[k]=Ways[j]) then
                         begin
                              WasInWays:=TRUE;
                         end;
                  if (WasInWays = FALSE) then
                     begin
                          CountOfWas:=CountOfWas+1;
                          Was[CountOfWas]:=Ways[j];
                          Q[i,CountOfWas]:=Ways[j];
                     end;
             end;
         for l:=1 to NumWays do
             Was[l]:=0;
    end;

{ * GDE BUDUT ROBOTY V SLEDUSHIJ MOMENT VREMENI * }
WriteLn('>>> Where will be robots:');
for i:=1 to Robots do
    begin
         for j:=1 to N do
             if (Q[i,j]>0) then
                Write(' ',Q[i,j]);
         WriteLn;
    end;
WriteLn;

for it:=1 to N do
    for jt:=1 to N do
        for kt:=1 to N do
            if ((JoinTwo(Q[1,it],Q[2,kt],Q[3,kt])) OR
               (WillThere(Q[1,it],Q[2,kt],Q[3,kt])) OR
               (Triangle(Q[1,it],Q[2,kt],Q[3,kt]))) then
               WasGathered:=1;
Time:=Time+1;

End; { // OF WHILE CIRLE }

Close(Input);
ReadLn;
END.