{ : Archon  }
{ : 1.0.2  }
{ : 29.04.08 }

{       -  demo: TDemo }

{$mode objfpc}
unit u_demo;

interface

uses
	gl, glu, glut, openil, openilut;

type
	TScene = class
	private
		fActive : boolean;
	public
		procedure Init; virtual; abstract;
		procedure Finish; virtual; abstract;
		procedure Draw; virtual; abstract;
		property Active : boolean read fActive write fActive;
	end;
	
	TDemo = class
	private
		Angle : GLdouble;
		Frames : longint;
		FramesPerSecond : real;
		CurrentScene : integer;
		Scenes : array of TScene;
		DemoTitle: PChar;
		procedure SetTitle(aTitle: PChar);
	public
		constructor Create;
		procedure AddScene(Scene : TScene);
		procedure Start;
		procedure SetOrtho2D;
		procedure SetPerspective(aAngle : GLdouble);
		property Fps: real read FramesPerSecond;
		property Title: PChar read DemoTitle write SetTitle;
	end;

var
  Demo: TDemo;

implementation

// Callback

procedure Keyboard(Key : byte; x, y : integer); cdecl;
begin
	case Key of
		27: Halt(0); // Escape
	end;
end;

procedure ReshapeOrtho2D(w, h : integer); cdecl;
begin
	glViewport(0, 0, w, h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity;
	gluOrtho2D(-2, 2, -1.5, 1.5);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity;
end;

procedure ReshapePerspective(w, h: integer); cdecl;
begin
	glViewport(0, 0, w, h);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity;
	gluPerspective(Demo.Angle, glutGet(GLUT_WINDOW_WIDTH) / glutGet(GLUT_WINDOW_HEIGHT), 0.1, 100);
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity;
end;

procedure Display; cdecl;
begin
	Demo.Scenes[demo.CurrentScene].Draw;
	glFinish;
	glutSwapBuffers;
end;

procedure Idle; cdecl;
begin
	if Demo.CurrentScene < 0 then begin
		Inc(Demo.CurrentScene);
		if Demo.CurrentScene > Length(Demo.Scenes) - 1 then Halt(0);
		Demo.Scenes[Demo.CurrentScene].Init;
	end;
	if not Demo.Scenes[Demo.CurrentScene].Active then begin
		Demo.Scenes[Demo.CurrentScene].Finish;
		Inc(Demo.CurrentScene);
		if Demo.CurrentScene > Length(Demo.Scenes) - 1 then Halt(0);
		Demo.Scenes[Demo.CurrentScene].Init;
	end;
	glutPostRedisplay;
	Inc(Demo.Frames);
end;

// Timers

procedure FpsCounter(Value: integer); cdecl;
begin
	Demo.FramesPerSecond := Demo.Frames;
	Demo.Frames := 0;
	glutTimerFunc(1000, @FpsCounter, -1);
end;

// TDemo -----

// private

procedure TDemo.SetTitle(aTitle: PChar);
begin
	DemoTitle := aTitle;
	glutSetWindowTitle(DemoTitle);
end;

// public

constructor TDemo.Create;
begin
	DemoTitle := 'Just a little demo =)';

	glutInit(@argc, argv);
	glutInitDisplayMode(GLUT_RGBA or GLUT_DOUBLE or GLUT_DEPTH);
	glutCreateWindow(DemoTitle);
	glutFullscreen;
	
	ilInit;
	ilutRenderer(IL_OPENGL);
	ilutEnable(ILUT_OPENGL_CONV);
	
	glutKeyboardFunc(@Keyboard);
	glutDisplayFunc(@Display);
	glutIdleFunc(@Idle);
	glutTimerFunc(1000, @FpsCounter, -1);
end;

procedure TDemo.AddScene(Scene: TScene);
begin
	SetLength(Scenes, Length(Scenes) + 1);
	Scenes[High(Scenes)] := Scene;
end;

procedure TDemo.Start;
begin
	CurrentScene := -1;
	Frames := 0;
	SetOrtho2D;
	glutMainLoop;
end;

procedure TDemo.SetOrtho2D;
begin
	glutReshapeFunc(@ReshapeOrtho2D);
	ReshapeOrtho2D(glutGet(GLUT_WINDOW_WIDTH), glutGet(GLUT_WINDOW_HEIGHT));
end;

procedure TDemo.SetPerspective(aAngle: GLdouble);
begin
	Angle := aAngle;
	glutReshapeFunc(@ReshapePerspective);
	ReshapePerspective(glutGet(GLUT_WINDOW_WIDTH), glutGet(GLUT_WINDOW_HEIGHT));
end;

initialization
	Demo := TDemo.Create;
finalization
	Demo.Destroy;
end.
