{ : Archon  }
{ : 1.1.5  }
{ : 30.05.08 }

{  00. , . }

{$mode objfpc}
unit u_scene00;

interface

uses
	u_demo,
	gl, glu, glext, glut, openilut;

const
	Brightness: real = 0.0;
	AtmosphereTexPath = 'data\atmosphere.png';
	EarthTexPath = 'data\earth.jpg';
	SunTexPath = 'data\sun.png';
	ShineTexPath = 'data\shine.png';
	SkyTexPath = 'data\sky.tga';
	AtmosphereDiffuse: array[0..3] of GLfloat = (0.07, 0.09, 0.98, 0.7);
	StarsDist = 52;
	StarsNum = 50000;

type
	TScene00 = class(TScene)
	private
		AtmosphereTex: GLuint;
		EarthTex: GLuint;
		SunTex: GLuint;
		ShineTex: GLuint;
		SkyTex: GLuint;
		AtmosphereList: GLuint;
		EarthList: GLuint;
		SunList: GLuint;
		ShineList: GLuint;
		SkyList: GLuint;
		StarsList: GLuint;
		AngleX, AngleY, Ang: real;
		StartMouseX, StartMouseY: integer;
	public
		constructor Create;
		destructor Destroy; override;
		procedure Init; override;
		procedure Finish; override;
		procedure Draw; override;
	end;

var
	Scene00 : TScene00;

implementation

// Callback

procedure MouseButtons(Button, State, x, y: integer); cdecl;
begin
	if (Button = GLUT_LEFT_BUTTON) then
		if State = GLUT_DOWN then begin
				Scene00.StartMouseX := x;
				Scene00.StartMouseY := y;
		end else begin
				Scene00.StartMouseX := -1;
				Scene00.StartMouseY := -1;
		end;
end;

procedure MouseMotion(x, y: integer); cdecl;
begin
	if Scene00.StartMouseX <> -1 then begin
		Scene00.AngleX := Scene00.AngleX + (x - Scene00.StartMouseX) / glutGet(GLUT_WINDOW_WIDTH) * 200;
		Scene00.AngleY := Scene00.AngleY + (y - Scene00.StartMouseY) / glutGet(GLUT_WINDOW_HEIGHT) * 200;
		if Scene00.AngleX < -180 then Scene00.AngleX :=  180;
		if Scene00.AngleX >  180 then Scene00.AngleX := -180;
		if Scene00.AngleY < -180 then Scene00.AngleY :=  180;
		if Scene00.AngleY >  180 then Scene00.AngleY := -180;
		Scene00.StartMouseX := x;
		Scene00.StartMouseY := y;
		Scene00.Ang := Sqrt(Sqr(Scene00.AngleX - 90) + Sqr(Scene00.AngleY));
		if (Scene00.Ang < 30) and (Scene00.Ang > 10) then
			if Scene00.Ang < 15 then
				Brightness := (Scene00.Ang - 10) / 50
			else
				Brightness := 0.1 - (Scene00.Ang - 15) / 150;
	end;
end;

// Timers

procedure MainTimer(Value : integer); cdecl;
begin
	if Scene00.Active then glutTimerFunc(10, @MainTimer, Value);
end;

// TScene00 -----

// private

// No functions :(

// public

constructor TScene00.Create;
begin
	AtmosphereTex := ilutGLLoadImage(AtmosphereTexPath);
	if AtmosphereTex = 0 then begin
		Writeln('Error loading image: ', AtmosphereTexPath);
		Halt(1);
	end;
	EarthTex := ilutGLLoadImage(EarthTexPath);
	if EarthTex = 0 then begin
		Writeln('Error loading image: ', EarthTexPath);
		Halt(1);
	end;
	SunTex := ilutGLLoadImage(SunTexPath);
	if SunTex = 0 then begin
		Writeln('Error loading image: ', SunTexPath);
		Halt(1);
	end;
	ShineTex := ilutGLLoadImage(ShineTexPath);
	if ShineTex = 0 then begin
		Writeln('Error loading image: ', ShineTexPath);
		Halt(1);
	end;
	SkyTex := ilutGLLoadImage(SkyTexPath);
	if SkyTex = 0 then begin
		Writeln('Error loading image: ', SkyTexPath);
		Halt(1);
	end;
end;

destructor TScene00.Destroy;
begin
	glDeleteTextures(1, @AtmosphereTex);
	glDeleteTextures(1, @EarthTex);
	glDeleteTextures(1, @SunTex);
	glDeleteTextures(1, @ShineTex);
	glDeleteTextures(1, @SkyTex);
end;

procedure TScene00.Init;
var
	Quadric: PGLUquadricObj;
	i: integer;
	Alpha, Beta, x, y, z, p, b: real;
	MaterialAmbient: array[0..3] of GLfloat = (0.0, 0.0, 0.0, 1.0);
	PlanetDiffuse: array[0..3] of GLfloat = (1.0, 1.0, 1.0, 1.0);
begin
	Active := true;
	
	Demo.SetPerspective(45);
	
	glEnable(GL_TEXTURE_2D);
	glShadeModel(GL_SMOOTH);
	glClearColor(0.0, 0.0, 0.0, 1.0);
	glClearDepth(1.0);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glEnable(GL_CULL_FACE);
	glEnable(GL_LIGHT0);
	glTexEnvf(GL_TEXTURE_ENV, GL_TEXTURE_ENV_MODE, GL_MODULATE);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
	glMaterialfv(GL_FRONT, GL_AMBIENT, @MaterialAmbient);
	
	Quadric := gluNewQuadric();
	gluQuadricTexture (Quadric, 1);
	gluQuadricOrientation(Quadric, GLU_OUTSIDE);
	
	glEnable(GL_BLEND);
	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	
	AtmosphereList := 1;
	glNewList(AtmosphereList, GL_COMPILE);	
		glMaterialfv(GL_FRONT, GL_DIFFUSE, @AtmosphereDiffuse);
		glBindTexture(GL_TEXTURE_2D, AtmosphereTex);
		gluSphere(Quadric, 1.01, 64, 64);
	glEndList;
	
	EarthList := 2;
	glNewList(EarthList, GL_COMPILE);
		glMaterialfv(GL_FRONT, GL_DIFFUSE, @PlanetDiffuse);
		glBindTexture(GL_TEXTURE_2D, EarthTex);
		glRotatef(23.45, 0, 1, 0);
		gluSphere(Quadric, 1.0, 64, 64);
		glRotatef(-23.45, 0, 1, 0);
	glEndList;
	
	SunList := 3;
	glNewList(SunList, GL_COMPILE);
		glDisable(GL_LIGHTING);
		glColor4f(1.0, 1.0, 1.0, 1.0);
		glBindTexture(GL_TEXTURE_2D, SunTex);
		glTranslatef(49.0, 0.0, 0.0);
		glBegin(GL_QUADS);
			glTexCoord2f(0, 0); glVertex3f(0, -5,  5);
			glTexCoord2f(1, 0); glVertex3f(0,  5,  5);
			glTexCoord2f(1, 1); glVertex3f(0,  5, -5);
			glTexCoord2f(0, 1); glVertex3f(0, -5, -5);
		glEnd;
		glTranslatef(-49.0, 0.0, 0.0);
		glEnable(GL_LIGHTING);
	glEndList;
	
	ShineList := 4;
	glNewList(ShineList, GL_COMPILE);
		glDisable(GL_LIGHTING);
		glBindTexture(GL_TEXTURE_2D, ShineTex);
		glTranslatef(49.0, 0.0, 0.0);
		glBegin(GL_QUADS);
			glTexCoord2f(0, 0); glVertex3f(0, -10,  10);
			glTexCoord2f(1, 0); glVertex3f(0,  10,  10);
			glTexCoord2f(1, 1); glVertex3f(0,  10, -10);
			glTexCoord2f(0, 1); glVertex3f(0, -10, -10);
		glEnd;
		glTranslatef(-49.0, 0.0, 0.0);
		glEnable(GL_LIGHTING);
	glEndList;
	
	SkyList := 5;
	gluQuadricOrientation(Quadric, GLU_INSIDE);
	glNewList(SkyList, GL_COMPILE);
		gluSphere(Quadric, 10.0, 16, 16);
	glEndList;
	
	StarsList := 6;
	glNewList(StarsList, GL_COMPILE);
		glDisable(GL_LIGHTING);
		glDisable(GL_BLEND);
		glDisable(GL_TEXTURE_2D);
		glBegin(GL_POINTS);
			for i := 0 to StarsNum do begin
				Alpha := Random;
				Beta := Random;
				if Beta < Alpha then begin
					p := Alpha;
					Alpha := Beta;
					Beta := p;
				end;
				x := Alpha;
				y := Beta - Alpha;
				z := 1 - Beta;
				if Random(2) = 0 then x := -x;
				if Random(2) = 0 then y := -y;
				if Random(2) = 0 then z := -z;
				b := Random;
				glColor4f((Random * 0.2 + 0.8) * b, (Random * 0.2 + 0.8) * b, (Random * 0.2 + 0.8) * b, 1.0);
				glVertex3f(x * StarsDist, y * StarsDist, z * StarsDist);
			end;
		glEnd;
		glEnable(GL_BLEND);
		glEnable(GL_LIGHTING);
		glEnable(GL_TEXTURE_2D);
	glEndList;
	
	gluDeleteQuadric(Quadric);
	
	glutTimerFunc(10, @MainTimer, 1);
	
	glutMouseFunc(@MouseButtons);
	glutMotionFunc(@MouseMotion);
	AngleX := -30;
	AngleY := 15;
	StartMouseX := -1;
	StartMouseY := -1;
end;

procedure TScene00.Finish;
begin
	glDeleteLists(AtmosphereList, 1);
	glDeleteLists(EarthList, 1);
	glDeleteLists(SunList, 1);
	glDeleteLists(ShineList, 1);
	glDeleteLists(SkyList, 1);
	glDeleteLists(StarsList, 1);
	glutMotionFunc(nil);
end;

procedure TScene00.Draw;
var
	LightPos: array[0..3] of GLfloat = (50.0, 0.0, 0.0, 0.0);
begin
	glClear(GL_COLOR_BUFFER_BIT or GL_DEPTH_BUFFER_BIT);
	glLoadIdentity;
	glTranslatef(0, 0, -5);
	
	glRotatef(AngleY, 1, 0, 0);
	glRotatef(AngleX, 0, 1, 0);
	
	glRotatef(-90.0, 1, 0, 0);
	
	glLightfv(GL_LIGHT0, GL_POSITION, @LightPos);
	glCallList(StarsList);
	glCallList(EarthList);
	glCallList(SunList);
	glPushMatrix;
	
	glLoadIdentity;
	glTranslatef(0, 0, -5);
	glCallList(AtmosphereList);
	glPopMatrix;
	
	glDisable(GL_DEPTH_TEST);
	glColor4f(0.75, 0.71, 0.29, Brightness * 3);
	glCallList(ShineList);
	glEnable(GL_DEPTH_TEST);
	
	glLoadIdentity;
	glBindTexture(GL_TEXTURE_2D, 0);
	glDisable(GL_LIGHTING);
	glBegin(GL_QUADS);
		glColor4f(1, 1, 1, Brightness);
		glVertex3f(-1, -1, -1);
		glVertex3f( 1, -1, -1);
		glVertex3f( 1,  1, -1);
		glVertex3f(-1,  1, -1);
	glEnd;
end;

initialization
	Scene00 := TScene00.Create;
finalization
	Scene00.Destroy;
end.

