(*
    VESA 256   .   
 TP(BP) 7.0.      !!
 ,      =)

      darkmaze@mail.ru
(+)       .
(-)         .

   /     -  .

          Graph.
,   ,  .  
     .

(C) by Dark
*)

UNIT VESATYPE;

INTERFACE

uses dos,crt;


type
 TVesaInfo = record
   VesaSignature : array[0..3] of char;{ 'VESA'}
   VesaVersion   : array[0..1] of byte;{major - . minor }
   OemString     : pointer;            { }
   Capabilities  : longint;            {}
   VideoModeInfo : pointer;            { }
   TotalMemory   : word;               {  (  64Kb)}
   Reserv        : array [0..235] of byte; { }
 end;

type TModeInfo = record
   Attributes              : word;
   WinAAttr,WinBAttr       : byte;
   WinGran                 : word;
   WinSize                 : word;
   WinASeg, WinBSeg        : word;
   VMC                     : pointer;
   BytesPLine              : word;
   Width,Height            : word;
   CharWidth,CharHeight    : byte;
   Planes,BitsPPixel       : byte;
   Banks,MemModel,BankSize : byte;
   ImagePages              : byte;
   Reserv1                 : byte;
   RedMaskSize             : byte;
   RedFieldPos             : byte;
   GreenMaskSize           : byte;
   GreenFieldPos           : byte;
   BlueMaskSize            : byte;
   BlueFieldPos            : byte;
   ResMaskSize             : byte;
   ResFieldPos             : byte;
   ColorModeInfo           : byte;
   Reserv2                 : array [0..225] of byte; {  - }
end;

var
  VesaInfo : TVesaInfo;
  ModeInfo : TModeInfo;
  IsVesa   : boolean;

{+} Procedure TestVesa;
{+} Function  TestMode(mode:word):boolean;
{+} Procedure VSetMode(mode:word);
{+} procedure SetTextMode;
{+} procedure VRetrace;

IMPLEMENTATION

Procedure TestVesa;
begin
  asm
   mov ax,seg  VesaInfo
   mov es,ax
   mov di,offset VesaInfo
   mov IsVesa,1
   mov ax,4f00h
   int 10h
   xor ax,4fh
   je @exit
   mov IsVesa,0
@exit:
  end;
end;

function TestMode(mode:word):boolean;
begin
 asm
  cmp [IsVesa],0
  je @exit
  mov ax,seg  ModeInfo
  mov es,ax
  mov di,offset ModeInfo
  mov @result,1
  mov ax,4f01h
  mov cx,[mode]
  int 10h
  xor ax,4fh
  je @exit
  mov @result,0
@exit:
 end;
end;

procedure VSetMode(mode:word);
begin
 testmode(mode);
 asm
  cmp [IsVesa],0
  je @exit
  mov ax,4f02h
  mov bx,[mode]
  int 10h
@exit:
 end;
end;

procedure SetTextMode;
begin
 asm
  mov ax,3h
  int 10h
 end;
end;

procedure VRetrace;assembler;
 asm
  cmp [IsVESA],0
  je @exit
  push dx
  push ax
  mov dx,3DAh
@l1:
  in al,dx
  and al,08h
  jnz @l1
@l2:
  in al,dx
  and al,08h
  jz @l2
  pop ax
  pop dx
@exit:
 end;
begin
TestVesa;
end.
