.386
.MODEL flat, stdcall
option casemap: none

include D:\masm32\include\windows.inc
include D:\masm32\include\user32.inc
include D:\masm32\include\kernel32.inc
include D:\masm32\include\shell32.inc
include D:\masm32\include\comctl32.inc
include D:\masm32\macros\macros.asm

includelib D:\masm32\lib\user32.lib
includelib D:\masm32\lib\kernel32.lib
includelib D:\masm32\lib\shell32.lib
includelib D:\masm32\lib\gdi32.lib
includelib D:\masm32\lib\comctl32.lib

.const
	FIRST_NUMBER		equ 1
	OPERATION		equ 2
	SECOND_NUMBER	equ 3
	CALCULUS		equ 4
	EMPTY			equ 5
	
	Button_0		equ 1020
	Button_1		equ 1021
	Button_2		equ 1022
	Button_3		equ 1023
	Button_4		equ 1024
	Button_5		equ 1025
	Button_6		equ 1026
	Button_7		equ 1027
	Button_8		equ 1028
	Button_9		equ 1029
	Button_A		equ 1030
	Button_B		equ 1031
	Button_C		equ 1032
	Button_D		equ 1033
	Button_E		equ 1034
	Button_F		equ 1035
	
	FUNCTION_BASE	equ 2000
	FUNCTION_AND		equ (FUNCTION_BASE + 38)
	FUNCTION_DIVISION	equ (FUNCTION_BASE + 47)
	FUNCTION_LSHIFT	equ (FUNCTION_BASE + 60)
	FUNCTION_MINUS	equ (FUNCTION_BASE + 45)
	FUNCTION_MULTIPLICATION	equ (FUNCTION_BASE + 42)
	FUNCTION_OR		equ (FUNCTION_BASE + 124)
	FUNCTION_PERCENT	equ (FUNCTION_BASE + 37)
	FUNCTION_PLUS	equ (FUNCTION_BASE + 43)
	FUNCTION_POWER	equ (FUNCTION_BASE + 94)
	FUNCTION_RSHIFT	equ (FUNCTION_BASE + 62)
	FUNCTION_CANCEL	equ 1070
	FUNCTION_CLEAR	equ 1071
	FUNCTION_EQUALS	equ (FUNCTION_BASE + 61)
	FUNCTION_OK		equ (FUNCTION_EQUALS)
	
	DISPLAY		equ 1050
	PROTOCOL	equ 1060
	
	dialogname	db "HexCalc", 0
.data
	Func db 3 dup(0)
	Protocol db 30 dup(0)
	DisplayNumber db 30 dup(0);
	
	szAndFunc db "&&", 0
	szRsFunc	db ">>", 0
	szLsFunc	db "<<", 0
	
	szChar	db "%c", 0
	szHex	db "%x", 0
	szHexStr	db "%x %s", 0
	szHexStrHex	db "%x %s %x", 0
	szHexStrHexHex	db "%x %s %x = %x", 0
	szEmpty	db "                           ", 0
;
gInstance	HINSTANCE ?
nFNumber	UINT 0
nSNumber	UINT 0
nResult	UINT 0
nDial		UINT 0
nStage	UINT (FIRST_NUMBER)
nOperation	UINT (FUNCTION_EQUALS)
.code

DlgProc proc hDlg:HWND, uMsg:UINT, wParam:WPARAM, lParam:LPARAM

	mov eax, uMsg
	.if eax == WM_CLOSE
		invoke EndDialog, hDlg, 0
	.elseif eax == WM_COMMAND
		.if (wParam >= Button_0) && (wParam <= Button_F)
			switch nStage
				case EMPTY, CALCULUS
					mov nStage, FIRST_NUMBER
					mov nDial, 0
				case OPERATION
					mov nStage, SECOND_NUMBER
			endsw
			
			mov eax, nDial
			shl eax, 4
			add eax, wParam
			sub eax, Button_0
			mov nDial, eax
		.endif

		switch wParam
			case FUNCTION_AND, FUNCTION_DIVISION, FUNCTION_LSHIFT, FUNCTION_MINUS, FUNCTION_MULTIPLICATION, FUNCTION_OR, FUNCTION_PERCENT, FUNCTION_PLUS, FUNCTION_POWER, FUNCTION_RSHIFT
				.if (nStage == FIRST_NUMBER)
					mov eax, nDial
					mov nFNumber, eax
				.elseif (nStage == CALCULUS)
					mov eax, nResult
					mov nFNumber, eax
				.endif
				mov nDial, 0
				mov eax, wParam
				mov nOperation, eax
				mov nStage, OPERATION
				
			case FUNCTION_CANCEL
				mov eax, nFNumber
				mov nDial, eax
				mov nDial, 0
				mov nStage, EMPTY
				
			case FUNCTION_CLEAR
				mov nDial, 0
				mov nStage, EMPTY
				
			case FUNCTION_EQUALS
				.if (nOperation == FUNCTION_PLUS)
					mov eax, nFNumber
					add eax, nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_MINUS)
					mov eax, nFNumber
					sub eax, nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_MULTIPLICATION)
					mov eax, nFNumber
					mul nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_DIVISION)
					cmp nSNumber, 0
					jne L_div
					mov nResult, 0ffffh
				L_div:
					xor edx, edx
					mov eax, nFNumber
					div nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_LSHIFT)
					mov eax, nFNumber
					xor ecx, ecx
					mov ecx, nSNumber
					shl eax, cl
					mov nResult, eax
				.elseif (nOperation == FUNCTION_RSHIFT)
					mov eax, nFNumber
					xor ecx, ecx
					mov ecx, nSNumber
					shr eax, cl
					mov nResult, eax
				.elseif (nOperation == FUNCTION_PERCENT)
					cmp nSNumber, 0
					jne L_percent
					mov nResult, 0ffffh
				L_percent:
					xor edx, edx
					mov eax, nFNumber
					div nSNumber
					mov nResult, edx
				.elseif (nOperation == FUNCTION_POWER)
					mov eax, nFNumber
					xor eax, nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_AND)
					mov eax, nFNumber
					and eax, nSNumber
					mov nResult, eax
				.elseif (nOperation == FUNCTION_OR)
					mov eax, nFNumber
					or eax, nSNumber
					mov nResult, eax
				.endif
			mov nStage, CALCULUS
			mov eax, nResult
			mov nDial, eax
		endsw

		.if nOperation == FUNCTION_AND
			invoke wsprintf, addr Func, addr szAndFunc
		.elseif nOperation == FUNCTION_RSHIFT
			invoke wsprintf, addr Func, addr szRsFunc
		.elseif nOperation == FUNCTION_LSHIFT
			invoke wsprintf, addr Func, addr szLsFunc
		.else
			mov eax, nOperation
			sub eax, FUNCTION_BASE
			invoke wsprintf, addr Func, addr szChar, eax
		.endif
			
		.if nStage == FIRST_NUMBER
			mov eax, nDial
			mov nFNumber, eax
			invoke wsprintf, addr Protocol, addr szHex, nFNumber
		.elseif nStage == OPERATION
			invoke wsprintf, addr Protocol, addr szHexStr, nFNumber, addr Func
		.elseif nStage == SECOND_NUMBER
			mov eax, nDial
			mov nSNumber, eax
			invoke wsprintf, addr Protocol, addr szHexStrHex, nFNumber, addr Func, nSNumber
		.elseif nStage == CALCULUS
			invoke wsprintf, addr Protocol, addr szHexStrHexHex, nFNumber, addr Func, nSNumber, nResult
		.elseif nStage == EMPTY
			invoke wsprintf, addr Protocol, addr szEmpty
		.endif
			
		invoke wsprintf, addr DisplayNumber, addr szHex, nDial
		invoke SetDlgItemText, hDlg, PROTOCOL, addr Protocol
		invoke SetDlgItemText, hDlg, DISPLAY, addr DisplayNumber
	.endif

        xor eax, eax
        ret
DlgProc endp

start:
	invoke GetModuleHandle, NULL
	mov gInstance, eax
	
	invoke DialogBoxParamA, gInstance, addr dialogname, NULL, addr DlgProc, 0
	invoke ExitProcess, eax
	invoke InitCommonControls
end start
