// HitTest.cpp : Defines the entry point for the application.
//

#include "stdafx.h"
#include "HitTest.h"
#define MAX_LOADSTRING 100
#include<stdio.h>
#include<commctrl.h>  //     
#pragma comment(lib, "comctl32.lib")
#define IDSB_SB 0x909
#define IDTB_TB	0x44
//         
#define SZ_SCROLL_STEP 10
#define SZ_SCROLL_PAGE 100


//    
class AazRectD{
	double l,r,t,b;
public:
	AazRectD(double _l,double _r,double _t,double _b){
		l=_l;
		b=_b;
		t=_t;
		r=_r;
	}
	double L(){return l;}
	double R(){return r;}
	double T(){return t;}
	double B(){return b;}
};
struct draftInfo{
	
	double zoom;
	int x0,y0,//     
		w,h,// 
		cw,ch,//  /*stepX,stepY,*/
		nStepsX,nStepsY//   
		;
		HRGN rgu;//    
};
class AazRectV
{
	AazRectD*rdoc;
public:
	AazRectV(AazRectD*rd=NULL):rdoc(rd){return;}
	void draw(HDC hdc,draftInfo& di){
		//      
		HPEN hpen,hpen2,hpen3;
		HBRUSH hb1, hb2, hb3, hb4, hb5,hb6,hb7;
		LOGBRUSH lb;
	static DWORD usrdata[8]={10,0,20,0,30,0};
	HPEN pen2;
		int xl=( rdoc->L()*di.w)-di.x0,
			yt=( rdoc->T()*di.h)-di.y0,                                 
			xr=( (rdoc->R()-rdoc->L())*di.w)-di.x0,
			yb=( (rdoc->B()-rdoc->T())*di.h)-di.y0,
			L,
			midlex=xl+((xr-xl)/2),
			midley=yt+((yb-yt)/2);
		TCHAR buf[256];
		RECT rect;

		lb.lbColor=RGB(255,100,100);
		lb.lbHatch=HS_BDIAGONAL;
		lb.lbStyle=BS_HATCHED;

		pen2=ExtCreatePen(PS_USERSTYLE| PS_GEOMETRIC|
			PS_ENDCAP_SQUARE| //    : ""(PS_ENDCAP_SQUARE)
			//""( PS_ENDCAP_ROUND )
			PS_JOIN_ROUND,//  .    
			8,// 
			&lb,// ( )
			8,//      ( , , , ,...)
			(DWORD*)usrdata// 
			);



		rect.left=xl;rect.top=yt,rect.right=xr,rect.bottom=yb;	
		hb6=(HBRUSH)GetStockObject(WHITE_BRUSH);
		SelectObject(hdc,hb6);
		di.rgu=CreateRectRgn(rect.left,rect.top,rect.right,rect.bottom);
		hpen=CreatePen(PS_SOLID,2,RGB(0,0,0));
		hpen2=CreatePen(PS_DASHDOT,1,RGB(255,0,0));
		hpen3=CreatePen(PS_DASH,1,RGB(0,255,0));
		FillRect(hdc,&rect,/*br*/NULL);	
		MoveToEx(hdc,xl+(780*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(780*di.zoom),yb-(100*di.zoom));
		MoveToEx(hdc,xl+(780*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(778*di.zoom),yt+(115*di.zoom));
		MoveToEx(hdc,xl+(780*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(783*di.zoom),yt+(115*di.zoom));

		hb7=(HBRUSH)GetStockObject(LTGRAY_BRUSH);
		SelectObject(hdc,hb7);

		Rectangle(hdc,xl+(210*di.zoom),yt+(100*di.zoom),xr-(210*di.zoom),yb-(100*di.zoom));
		SelectObject(hdc,hpen);
		hb1 = CreateHatchBrush(HS_BDIAGONAL,RGB(200,200,255));
		SelectObject(hdc,hb1);	
		Ellipse(hdc,xl+(210*di.zoom),yt+(100*di.zoom),xr-(210*di.zoom),yb-(100*di.zoom));
		hb2 = CreateHatchBrush(HS_FDIAGONAL,RGB(100,200,255));
		SelectObject(hdc,hb2);
		Ellipse(hdc,xl+(230*di.zoom),yt+(120*di.zoom),xr-(230*di.zoom),yb-(120*di.zoom));
		SelectObject(hdc,GetStockObject(WHITE_BRUSH));
		Rectangle(hdc,xl+(400*di.zoom),yt+(180*di.zoom),xr-(400*di.zoom),yb-(180*di.zoom));
		hb3 = 	CreateHatchBrush(HS_CROSS,RGB(200,100,0));	
		SelectObject(hdc,hb3);
		Rectangle(hdc,xl+(410*di.zoom),yt+(190*di.zoom),xr-(410*di.zoom),yb-(190*di.zoom));
		hb4 = CreateHatchBrush(HS_DIAGCROSS,RGB(100,0,255));
		SelectObject(hdc,hb4);
		Ellipse(hdc,xl+(420*di.zoom),yt+(220*di.zoom),xr-(420*di.zoom),yb-(370*di.zoom));
		Ellipse(hdc,xl+(420*di.zoom),yt+(370*di.zoom),xr-(420*di.zoom),yb-(220*di.zoom));
		SelectObject(hdc,GetStockObject(NULL_PEN));
		hb5 = CreateHatchBrush(HS_HORIZONTAL,RGB(200,0,0));	
		SelectObject(hdc,hb5);
		Ellipse(hdc,xl+(610*di.zoom),yt+(110*di.zoom),xr-(220*di.zoom),yb-(470*di.zoom));
		
		hb1 = CreateHatchBrush(HS_VERTICAL,RGB(200,0,0));

		SelectObject(hdc,hb1);
		SelectObject(hdc,GetStockObject(WHITE_PEN));
		Ellipse(hdc,xl+(220*di.zoom),yt+(110*di.zoom),xr-(610*di.zoom),yb-(470*di.zoom));

		hpen2 = CreatePen(PS_DASHDOT,1,RGB(255,0,0));

		SelectObject(hdc,hpen2);
		MoveToEx(hdc,xl+(450*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(800*di.zoom),yt+(100*di.zoom));
		MoveToEx(hdc,xl+(450*di.zoom),yb-(100*di.zoom),NULL);
		LineTo(hdc,xl+(800*di.zoom),yb-(100*di.zoom));
		SelectObject(hdc,CreatePen(PS_DASH,1,RGB(0,255,0)));
		MoveToEx(hdc,xl+(150*di.zoom),midley,NULL);
		LineTo(hdc,xl+(750*di.zoom),midley);
		MoveToEx(hdc,midlex,yt+(50*di.zoom),NULL);
		LineTo(hdc,midlex,yt+(600*di.zoom));
		
		hpen2 = CreatePen(PS_DASHDOTDOT,1,RGB(0,0,0));
		SelectObject(hdc,hpen2);
		
		MoveToEx(hdc,xl+(778*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(778*di.zoom),yb-(100*di.zoom));
		DeleteObject(hpen2);

		hpen2 = CreatePen(PS_INSIDEFRAME,1,RGB(0,0,0));
		SelectObject(hdc,hpen2);
		MoveToEx(hdc,xl+(778*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(776*di.zoom),yt+(125*di.zoom));
		MoveToEx(hdc,xl+(778*di.zoom),yt+(100*di.zoom),NULL);
		LineTo(hdc,xl+(780*di.zoom),yt+(125*di.zoom));
		
		MoveToEx(hdc,xl+(778*di.zoom),yb-(100*di.zoom),NULL);
		LineTo(hdc,xl+(776*di.zoom),yb-(125*di.zoom));
		MoveToEx(hdc,xl+(778*di.zoom),yb-(100*di.zoom),NULL);
		LineTo(hdc,xl+(780*di.zoom),yb-(125*di.zoom));
		DeleteObject(hpen2);
		

		SelectObject(hdc,pen2);
		MoveToEx(hdc,xl+(5*di.zoom),yt+(5*di.zoom),NULL);
		LineTo(hdc,xr-(5*di.zoom),yt+(5*di.zoom));
		MoveToEx(hdc,xl+(5*di.zoom),yb-(5*di.zoom),NULL);
		LineTo(hdc,xr-(5*di.zoom),yb-(5*di.zoom));
		
	DeleteObject(pen2);	
	DeleteObject(hpen2);	
	DeleteObject(hpen);	
	DeleteObject(hpen3);	
	DeleteObject(hb1);	
	DeleteObject(hb2);	
	DeleteObject(hb3);
	DeleteObject(hb4);	
	DeleteObject(hb5);	
	DeleteObject(hb6);
	DeleteObject(hb7);		

		
	}
};

//    ,  .
AazRectD*rd;
AazRectV*rv;
//   .
HIMAGELIST imgls;
double l,r,t,b;
draftInfo di;
HFONT font;
int CountZoom=0;

// Global Variables:
HINSTANCE hInst;								// current instance
TCHAR szTitle[MAX_LOADSTRING];					// The title bar text
TCHAR szWindowClass[MAX_LOADSTRING];			// the main window class name
HWND hsb,htb;// HWND of Status Bar
// Forward declarations of functions included in this code module:
ATOM				MyRegisterClass(HINSTANCE hInstance);
BOOL				InitInstance(HINSTANCE, int);
LRESULT CALLBACK	WndProc(HWND, UINT, WPARAM, LPARAM);
LRESULT CALLBACK	About(HWND, UINT, WPARAM, LPARAM);

int APIENTRY _tWinMain(HINSTANCE hInstance,
                     HINSTANCE hPrevInstance,
                     LPTSTR    lpCmdLine,
                     int       nCmdShow)
{
 	// TODO: Place code here.
	MSG msg;
	
	HACCEL hAccelTable;
	//rd=new AazRectD(0.02,0.02,0.02,0.02);//
	rd=new AazRectD(0.02,0.98,0.02,0.98);// 
	
	l=rd->L();
	r=rd->R();
	t=rd->T();
	b=rd->B();



	rv=new AazRectV(rd);//   
	// Initialize global strings
	LoadString(hInstance, IDS_APP_TITLE, szTitle, MAX_LOADSTRING);
	LoadString(hInstance, IDC_HITTEST, szWindowClass, MAX_LOADSTRING);
	MyRegisterClass(hInstance);
	
	InitCommonControls();

	// Perform application initialization:
	if (!InitInstance (hInstance, nCmdShow)) 
	{
		return FALSE;
	}

	hAccelTable = LoadAccelerators(hInstance, (LPCTSTR)IDC_HITTEST);

	while (GetMessage(&msg, NULL, 0, 0)) 
	{
		if (!TranslateAccelerator(msg.hwnd, hAccelTable, &msg)) 
		{
			TranslateMessage(&msg);
			DispatchMessage(&msg);
		}
	}

	return (int) msg.wParam;
}


ATOM MyRegisterClass(HINSTANCE hInstance)
{
	WNDCLASSEX wcex;
	HBITMAP bmp;
	bmp=LoadBitmap(hInstance,MAKEINTRESOURCE(IDB_SKULL));
	wcex.cbSize = sizeof(WNDCLASSEX); 
	wcex.style			= CS_HREDRAW | CS_VREDRAW;
	wcex.lpfnWndProc	= (WNDPROC)WndProc;
	wcex.cbClsExtra		= 0;
	wcex.cbWndExtra		= 0;
	wcex.hInstance		= hInstance;
	wcex.hIcon			= LoadIcon(hInstance, (LPCTSTR)IDI_HITTEST);
	wcex.hCursor		= LoadCursor(hInstance,MAKEINTRESOURCE(IDC_CURSOR1));
	wcex.hbrBackground	= (HBRUSH)CreatePatternBrush(bmp);
	wcex.lpszMenuName	= (LPCTSTR)IDC_HITTEST;
	wcex.lpszClassName	= szWindowClass;
	wcex.hIconSm		= LoadIcon(wcex.hInstance, (LPCTSTR)IDI_SMALL);
	DeleteObject(bmp);
	return RegisterClassEx(&wcex);
}

void CreateStatusBar(HWND hw)
{
	int parts[]={200,400};
	DWORD ec;
	if(NULL==(hsb=CreateWindowEx(CCS_BOTTOM,STATUSCLASSNAME,NULL,WS_VISIBLE|WS_CHILD,
				0,0,20,20,hw,(HMENU)IDSB_SB,hInst,0)))
		{
			ec=GetLastError();
			MessageBox(0,"can not create status bar","error",MB_OK);
			return;
		}
	if(SendMessage(hsb,SB_SETPARTS,2,(LPARAM)parts)==FALSE)
		{
			MessageBox(0,"can not make parts of status bar","error",MB_OK);
			return;
		}
}

void SetSBtext(DWORD pane,TCHAR*text)
{
	SendMessage(hsb,SB_SETTEXT,pane,(LPARAM)text);
	return;
}

BOOL InitInstance(HINSTANCE hInstance, int nCmdShow)
{
   HWND hWnd;

   hInst = hInstance; 

   hWnd = CreateWindow(szWindowClass, szTitle, WS_OVERLAPPEDWINDOW,
      CW_USEDEFAULT, 0, CW_USEDEFAULT, 0, NULL, NULL, hInstance, NULL);

   if (!hWnd)
   {
      return FALSE;
   }

   ShowWindow(hWnd, nCmdShow);
   UpdateWindow(hWnd);
   ImageList_Destroy(imgls);

   return TRUE;
}

// ,       
void updateScrollBars(HWND hwnd,double dz)
{
	if (CountZoom < 4 && CountZoom > -4 && CountZoom!=0 )
	{
		di.w/=di.zoom;
		di.h/=di.zoom;
		if((di.zoom+dz<8) && (di.zoom+dz>0.3))di.zoom+=dz;
		di.w*=di.zoom;
		di.h*=di.zoom;
	}
	else if(CountZoom!=0)MessageBox(0,"Max ZOOM!","error",MB_OK);

	ShowScrollBar(hwnd,SB_HORZ,di.w>di.cw);
	ShowScrollBar(hwnd,SB_VERT,di.h>di.ch);

	//  
		di.nStepsX=(int)( ( di.w-di.cw )/SZ_SCROLL_STEP);
		di.nStepsY=(int)( ( di.h-di.ch )/SZ_SCROLL_STEP);
		SetScrollRange(hwnd,SB_VERT,0,di.nStepsY,TRUE);
		SetScrollRange(hwnd,SB_HORZ,0,di.nStepsX,TRUE);
//	di.stepY=di.h/di.nStepsY;
//	di.stepX=di.w/di.nStepsX;
	InvalidateRect(hwnd,NULL,TRUE);
}
///////////////////TOOLBAR////////////////////////////////////////////////////////
void CreateTB(HWND hw,DWORD tbid)
{
	static const int NUM_BUTTONS=4,IMGLS_ID=0;

	if(NULL==(htb=CreateWindowEx(0,TOOLBARCLASSNAME,"",
									WS_VISIBLE|WS_CHILD,0,0,20,20,
									hw,(HMENU)tbid,hInst,0))){
									
								MessageBox(0,"can not create status bar","error",MB_OK);
								return;										
	}
    imgls = ImageList_Create(
        16, 16,   
        ILC_COLOR16 | ILC_MASK,
        NUM_BUTTONS, 
		0
		);
	SendMessage(htb, TB_SETIMAGELIST,IMGLS_ID,(LPARAM)imgls);
    TBBUTTON tbButtons[NUM_BUTTONS];
	ZeroMemory(tbButtons,sizeof(tbButtons));
	
	tbButtons[0].iBitmap=MAKELONG(STD_FILEOPEN,IMGLS_ID);
	tbButtons[0].idCommand=IDM_OPEN;
	tbButtons[0].fsStyle=BTNS_BUTTON |TBSTYLE_AUTOSIZE|TBSTYLE_BUTTON|TBSTYLE_TRANSPARENT;
	tbButtons[0].fsState=TBSTATE_ENABLED;
	
	tbButtons[1].iBitmap=MAKELONG(STD_FILESAVE,IMGLS_ID);
	tbButtons[1].idCommand=IDM_SAVE;
	tbButtons[1].fsStyle=BTNS_BUTTON |TBSTYLE_AUTOSIZE|TBSTYLE_BUTTON|TBSTYLE_TRANSPARENT;
	tbButtons[1].fsState=TBSTATE_ENABLED;
	tbButtons[3].iBitmap=MAKELONG(HIST_ADDTOFAVORITES ,IMGLS_ID);
	tbButtons[3].idCommand=IDM_SAVE;
	tbButtons[3].fsStyle=BTNS_BUTTON |TBSTYLE_AUTOSIZE|TBSTYLE_BUTTON|TBSTYLE_TRANSPARENT;
	tbButtons[3].fsState=TBSTATE_ENABLED;
	//-.
	//tbButtons[1].fsStyle=TBSTYLE_SEP;
	//tbButtons[1].fsState=TBSTATE_ENABLED;

/*	HICON myico=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON));
	DeleteObject(myico);
	if(myico){		
		tbButtons[2].iBitmap=MAKELONG(ImageList_AddIcon(imgls, myico),IMGLS_ID);
		tbButtons[2].idCommand=IDM_EXIT;
		tbButtons[2].fsStyle=BTNS_BUTTON |TBSTYLE_AUTOSIZE|TBSTYLE_BUTTON|TBSTYLE_TRANSPARENT;
		tbButtons[2].fsState=TBSTATE_ENABLED;
	}
 myico=LoadIcon(hInst,MAKEINTRESOURCE(IDI_ICON_I));
	DeleteObject(myico);
	if(myico){		
		tbButtons[4].iBitmap=MAKELONG(ImageList_AddIcon(imgls, myico),IMGLS_ID);
		tbButtons[4].idCommand=IDM_EXIT;
		tbButtons[4].fsStyle=BTNS_BUTTON |TBSTYLE_AUTOSIZE|TBSTYLE_BUTTON|TBSTYLE_TRANSPARENT;
		tbButtons[4].fsState=TBSTATE_ENABLED;
	}
	/*  ,    */
    SendMessage(htb, TB_LOADIMAGES, (WPARAM)IDB_STD_SMALL_COLOR, 
        (LPARAM)HINST_COMMCTRL);
	//,   
    SendMessage(htb, TB_BUTTONSTRUCTSIZE, 
        (WPARAM)sizeof(TBBUTTON), 0);
	//  ,     .
    SendMessage(htb, TB_ADDBUTTONS, (WPARAM)NUM_BUTTONS, 
        (LPARAM)&tbButtons);
	//      .
    SendMessage(htb, TB_AUTOSIZE, 0, 0); 
	return;
}
/////////////////////////////////////////////////////////////////////////////////
LRESULT CALLBACK WndProc(HWND hWnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	int wmId, wmEvent,mx,my,
		cx,//   
		cy,scrollDelta;// --"--  
	PAINTSTRUCT ps;
	HDC hdc;
	static HCURSOR hcguetar;
	static HBITMAP cbmp=NULL;
	static HDC cdc=NULL;
	bool moved;
	static double da=0.005;
	static bool db=false, BAR=true;
	static int tbh,sbh,sbshow = 1;
	static RECT rc;
	LOGBRUSH lb;
	static DWORD usrdata[8]={10,10,20,20,30,30};
	HPEN pen2;
	HBITMAP bmp;
	static HBRUSH br;
	//,  .
	static RECT rect;
	static HRGN rgn=NULL;
	/*    :       .*/
	static bool CLIP=false,ShowRect=true;
	static char b[256];


	bmp=LoadBitmap(hInst,MAKEINTRESOURCE(IDB_SKULL));
	/////////////////////////////////////////////////////////////////////////////////
	
		lb.lbColor=RGB(0,255,0);
		lb.lbHatch=HS_DIAGCROSS;
		lb.lbStyle=BS_HATCHED;

		pen2=ExtCreatePen(PS_USERSTYLE| PS_GEOMETRIC|
			PS_ENDCAP_SQUARE| //    : ""(PS_ENDCAP_SQUARE)
			//""( PS_ENDCAP_ROUND )
			PS_JOIN_ROUND,//  .    
			8,// 
			&lb,// ( )
			8,//      ( , , , ,...)
			(DWORD*)usrdata// 
			);
	/////////////////////////////////////////////////////////////////////////////////
	switch (message) 
	{
	case WM_CREATE:
		
		CreateStatusBar(hWnd);
		CreateTB(hWnd,IDTB_TB);
		br=CreatePatternBrush(bmp);
		hcguetar=LoadCursor(hInst,MAKEINTRESOURCE(IDC_NOD));
		//   .
		di.zoom=1.0L;
		di.x0=0;di.y0=0;
		di.w=0;
		updateScrollBars(hWnd,0);

		return 0;
		
	case WM_SIZE:

		hdc=GetDC(hWnd);//  DC
		
		if(cbmp)DeleteObject(cbmp);//   DC
		
		if(cdc)DeleteDC(cdc);
		
		// " ".
		cbmp=CreateCompatibleBitmap(hdc,LOWORD(lParam),HIWORD(lParam));
		cdc=CreateCompatibleDC(hdc);
		// hdc .
		ReleaseDC(hWnd,hdc);
		mx=LOWORD(lParam)/2;
		my=HIWORD(lParam)/2;
		// , . ,   .
		di.cw=LOWORD(lParam);
		di.ch=HIWORD(lParam);
		
		if(abs(di.zoom-1.0L)<0.08 && di.w==0){
			di.w=di.cw;
			di.h=di.ch;
		}

		if(di.rgu)DeleteObject(di.rgu);
		
		//   .
		cx=LOWORD(lParam);
		cy=HIWORD(lParam);
		
		//   ,  .
		SendMessage(hsb,WM_SIZE,wParam,lParam);
		SendMessage(htb, TB_AUTOSIZE,0,0);
		GetWindowRect(hsb,&rc);
		
		if(BAR)sbh=rc.bottom-rc.top;
		else sbh=0;
		tbh = rc.bottom-rc.top;
		updateScrollBars(hWnd,0);

		return 0;	

	case WM_MBUTTONDOWN:
		
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_MBUTTONUP:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_RBUTTONUP:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_RBUTTONDOWN:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_LBUTTONDOWN:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_LBUTTONUP:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		break;
	case WM_MOUSEMOVE:
		if(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam)))SetCursor(hcguetar);
		// .      
		sprintf(b,"X:%d Y:%d",LOWORD(lParam),HIWORD(lParam));
		SetSBtext(1,b);
		SetSBtext(0,(PtInRegion(di.rgu,LOWORD(lParam),HIWORD(lParam))==0)?" ":" ");////////
		return 0;
	case WM_COMMAND:
		wmId    = LOWORD(wParam); 
		wmEvent = HIWORD(wParam); 
		// Parse the menu selections:
		switch (wmId)
		{
		case IDM_ZOOMIN:
			if(CountZoom < 4)
			{
				CountZoom++;
				updateScrollBars(hWnd,+0.2);
			}
			break;
		case IDM_ZOOMOUT:
			if(CountZoom > -4 )
			{
				CountZoom--;
				updateScrollBars(hWnd,-0.2);
			}
			break;
		case IDM_ABOUT:
			DialogBox(hInst, (LPCTSTR)IDD_ABOUTBOX, hWnd, (DLGPROC)About);
			break;
		case IDM_EXIT:
			DestroyWindow(hWnd);
			break;
		case IDM_STATUSBAR:
			BAR=!BAR;
			CheckMenuItem(GetMenu(hWnd),IDM_STATUSBAR,BAR?MF_CHECKED:MF_UNCHECKED);
			if(!BAR)
			{
				sbshow=0;
				sbh=0;
			}
			else 
			{
				sbshow =1;
			sbh=rc.bottom-rc.top;
			}
			ShowWindow(hsb,sbshow);
			InvalidateRect(hWnd,NULL,TRUE);
			break;
		default:
			return DefWindowProc(hWnd, message, wParam, lParam);
		}
		break;
	
///////////////////////////////////////////////////////////////////////////////////////
		 case WM_VSCROLL :
		moved=true;//,   -
		scrollDelta=0;
        switch (LOWORD (wParam))
            {
            case SB_TOP :
					scrollDelta=-di.y0;//  (  -- )
                    break ;
            case SB_BOTTOM:
				scrollDelta=di.nStepsY-di.y0;//
                    break ;
            case SB_LINEUP:
					if(GetScrollPos(hWnd,SB_VERT)>0)//,   
						scrollDelta=-SZ_SCROLL_STEP;
                    break ;
            case SB_LINEDOWN:
				if(GetScrollPos(hWnd,SB_VERT)<di.nStepsY)
                    scrollDelta=SZ_SCROLL_STEP;
                    break ;
            case SB_PAGEUP :
				scrollDelta=-SZ_SCROLL_PAGE;
                    break ;
            case SB_PAGEDOWN :
                    scrollDelta=SZ_SCROLL_PAGE;
                    break ;
            case SB_THUMBTRACK :
				scrollDelta = HIWORD (wParam)*SZ_SCROLL_STEP - di.y0 ;
                    break ;
			default:moved=false;
            }
        if (moved)// ,  ...
            {
				//  
				ScrollWindowEx(hWnd, 0,-scrollDelta, NULL, NULL,0,0,SW_INVALIDATE) ;
				di.y0+=scrollDelta;// 
				if(di.y0<0){
					throw 0xdead002;
					di.y0=0;
				}
				//   
				SetScrollPos (hWnd, SB_VERT, di.y0/SZ_SCROLL_STEP, TRUE) ;
				//
				InvalidateRect(hWnd,NULL,TRUE);
            }
        return 0 ;
    case WM_HSCROLL :
		moved=true;
		scrollDelta=0;
        switch (LOWORD (wParam))
            {
            case SB_TOP :
					scrollDelta=-di.x0;
                    break ;
            case SB_BOTTOM:
				scrollDelta=di.nStepsX-di.x0;
                    break ;
            case SB_LINEUP:
					if(GetScrollPos(hWnd,SB_HORZ)>0)
						scrollDelta=-SZ_SCROLL_STEP;
                    break ;
            case SB_LINEDOWN:
				if(GetScrollPos(hWnd,SB_HORZ)<di.nStepsX)
                    scrollDelta=SZ_SCROLL_STEP;
                    break ;
            case SB_PAGEUP :
				scrollDelta=-SZ_SCROLL_PAGE;
                    break ;
            case SB_PAGEDOWN :
                    scrollDelta=SZ_SCROLL_PAGE;
                    break ;
            case SB_THUMBTRACK :
				scrollDelta = HIWORD (wParam)*SZ_SCROLL_STEP - di.x0 ;
                    break ;
			default:moved=false;
            }
        if (moved)
            {
				ScrollWindowEx(hWnd,-scrollDelta, 0, NULL, NULL,0,0,SW_INVALIDATE) ;
				di.x0+=scrollDelta;
				if(di.x0<0){
					throw 0xdead002;
					di.x0=0;
				}
				SetScrollPos (hWnd, SB_HORZ, di.x0/SZ_SCROLL_STEP, TRUE) ;
				InvalidateRect(hWnd,NULL,TRUE);
            }
	case WM_ERASEBKGND:return 0;
	case WM_PAINT:
		hdc = BeginPaint(hWnd, &ps);

		if(true){
			//    ,
			//   .       CompatibleDC
			SelectObject(cdc,cbmp);
			SelectObject(cdc,GetStockObject(NULL_PEN));
			SelectObject(cdc,br);
			Rectangle(cdc,1,1,di.cw,di.ch+rc.bottom-rc.top);
			rv->draw(cdc,di);
			BitBlt(hdc,0,0,di.cw,di.ch+tbh,cdc,0,0,SRCCOPY);
		}
		else{
			rv->draw(hdc,di);	
		}
		EndPaint(hWnd, &ps);	
		break;
	case WM_DESTROY:
		PostQuitMessage(0);
		break;
	default:
		return DefWindowProc(hWnd, message, wParam, lParam);
	}
	return 0;
}
// Message handler for about box.
LRESULT CALLBACK About(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
	switch (message)
	{
	case WM_INITDIALOG:
		return TRUE;

	case WM_COMMAND:
		if (LOWORD(wParam) == IDOK || LOWORD(wParam) == IDCANCEL) 
		{
			EndDialog(hDlg, LOWORD(wParam));
			return TRUE;
		}
		break;
	}
	return FALSE;
}
