unit UCalc;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, Grids;

type
  TFCalc = class(TForm)
    SG: TStringGrid;
    ESum: TEdit;
    EStavka: TEdit;
    EMonth: TEdit;
    Label1: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    BRasch: TButton;
    RBAn: TRadioButton;
    RBDif: TRadioButton;
    procedure BRaschClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);

  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  FCalc: TFCalc;
  procedure Annuite(summa, stavka, mesplatej: real; month: integer);

implementation

{$R *.dfm}


procedure Annuite(summa, stavka, mesplatej: real; month: integer);
var
 i: integer;
 ostn, ostk, vplpr, pgdolg: real;
begin
  for i := 1 to month do begin
    if month = 1 then ostn := summa else ostn := ostk;
    vplpr := ostn * stavka / 12;
    pgdolg := mesplatej - vplpr;
    ostk := ostn - pgdolg;

    FCalc.SG.Cells[0,i]:= inttostr(month);
    FCalc.SG.Cells[1,i]:= floattostr(vplpr);
    FCalc.SG.Cells[2,i]:= floattostr(pgdolg);
    FCalc.SG.Cells[3,i]:= floattostr(mesplatej);
    FCalc.SG.Cells[4,i]:= floattostr(ostn);
    FCalc.SG.Cells[5,i]:= floattostr(ostk);

  end;

end;

procedure TFCalc.BRaschClick(Sender: TObject);
var
  str: string;
  a,b,c: real;
  Ejrasch: extended;
begin
  str := EStavka.text;

  if pos(',', EStavka.Text) <> 0 then
    str := copy(EStavka.Text, pos(',', EStavka.Text), 1);

  if  pos('.', EStavka.Text) <> 0 then
    str := copy(EStavka.Text, pos(',', EStavka.Text), 1);

  EStavka.Text := '0,' + str;

  a:= StrToFloat(ESum.Text);
  b:= StrToFloat(EStavka.Text);
  c:= StrToFloat(Emonth.Text);


  if RBAn.Checked=true then begin   //   
    Ejrasch := a*( (b/12) / (exp(ln((1-(1+b/12))*(-c))  )) );
    Annuite(strtofloat(ESum.Text), strtofloat(EStavka.Text), Ejrasch, strtoint(EMonth.Text));
  end

  else begin    //   

  end;

end;

procedure TFCalc.FormCreate(Sender: TObject);
begin
  SG.Cells[0,0]:='';
  SG.Cells[1,0]:=' ';
  SG.Cells[2,0]:='  ';
  SG.Cells[3,0]:='  ';
  SG.Cells[4,0]:='    ';
  SG.Cells[5,0]:='    ';
end;

end.
