unit TanksUnit;

interface
uses   ExtCtrls,ImgList,Controls,windows,Classes;

type tstr=array of Char;
type tpole=array of tstr; //    

type Ttank=object
            image:timage;// 
            imglist:array [0..3]of timage;// 
            MaxPath,CurPath:integer;
            defaultSpeed,//  
            speed,       // 
            defaultLive, //   
            Live:         // 
            integer;

              pula:record
              image:timage;
              x,y,direction,
              speed,sila,tip:integer;
              end;
            private
            CurDirection :integer;  // 

            public
            function PathOut:boolean;
            function CheckPole(const pole:tpole;const sw,sh:byte):boolean;
              procedure init(const img:timage;const list:TImageList;const parent:TWinControl);
              procedure destroy;
              procedure GenDirection;
              procedure smartDirTo(const obj:ttank);
              procedure MoveFOR;
              procedure MoveBACK;
            procedure SetDirection(nomer:byte);
            Function  GetDirection:byte;
            function  tankCheckObject(const obj:timage):boolean;
              procedure PulaHome;
              procedure PulaMove;
              procedure PulaStart;
              Procedure PulaStop;
              function  PulaCheckPole(const img,free:TImage;
                                      const pole:tpole;const sw,sh:byte):boolean;
              function PulaCheckObject(const obj:timage):boolean;
            end;

implementation

function ttank.PathOut:boolean;
begin
if CurPath>MaxPath then result:=true else result:=false;
end;

function ttank.CheckPole(const pole:tpole;const sw,sh:byte):boolean;
var
y,x:integer;
begin
result:=false;
if ((image.Top)<=0)or
   ((image.left)<=0)or
   ((image.Top +image.Height)div sh>length(pole)-1)or
   ((image.left+image.width )div sw>length(pole[0])-1)
then result:=true
else
  for x:=image.left div sw to (image.left+image.width) div sw do
  for y:=image.Top div sh to (image.Top+image.Height) div sh do

    if pos(pole[y][x],'123')<>0 then
      begin
      result:=true;
      exit;
      end;
end;

procedure ttank.destroy;
var i:byte;
begin
for i:=0 to length(imglist)-1 do imglist[i].Free;
pula.image.Free;
image.Free;
end;

procedure ttank.init(const img:timage;const list:TImageList;const parent:TWinControl);
var
i:byte;
begin
randomize;
    //     
    for i:=0 to length(imglist)-1 do
    begin
      imglist[i]:=TImage.Create(img.Owner);
      imglist[i].AutoSize:=true;
      imglist[i].Canvas.FillRect(rect(0,0,1,1));
    List.GetBitmap(i,imglist[i].Picture.Bitmap);
    end;

//  
image:=timage.Create(img.Owner);
// 
image.Parent:=parent;
image.AutoSize:=true;
image.Transparent:=true;
image.Left:=5;
image.top:=random(4);

pula.image:=TImage.Create(img.Owner);
pula.image.Parent:=parent;
pula.image.Picture:=img.Picture;
pula.image.AutoSize:=true;
pula.image.Transparent:=true;
pula.image.Enabled:=false;
pula.speed:=8;

// 
SetDirection(GetDirection);
defaultSpeed:=3;
defaultLive:=10;
SetDirection(random(4));
Maxpath:=random(400);
end;

procedure ttank.MoveFOR;
begin
  if image.Visible then
  begin
      case GetDirection of
      0:image.top :=image.top - speed;
      1:image.Left:=image.Left+ speed;
      2:image.top :=image.top + speed;
      3:image.Left:=image.Left- speed;
      end;
  curpath:=curpath+speed;
    if not pula.image.Enabled then  PulaHome;
  end;
end;

procedure ttank.MoveBACK;
begin
  if image.Visible then
  begin
      case GetDirection of
      0:image.top :=image.top + speed;
      1:image.Left:=image.Left- speed;
      2:image.top :=image.top - speed;
      3:image.Left:=image.Left+ speed;
      end;
    curpath:=curpath-speed;
    if not pula.image.Enabled then  PulaHome;
  end;
end;


function Ttank.GetDirection: byte;
begin
result:=CurDirection;
end;

procedure Ttank.SetDirection(nomer: byte);
begin
CurDirection:=nomer;
image.Picture:=imglist[nomer].Picture;
  if not pula.image.Enabled then  PulaHome;
end;

procedure ttank.GenDirection;
begin
curpath:=0;
MaxPath:=random(400);
SetDirection(random(4));
end;

procedure Ttank.PulaHome;
begin
if not pula.image.Enabled then
begin
  Case GetDirection of
  0:begin
    pula.x:=image.Left+image.Width div 2;
    pula.y:=image.Top;
    end;
  1:begin
    pula.x:=image.Left+image.Width;
    pula.y:=image.Top+image.Height div 2;
    end;
  2:begin
    pula.x:=image.Left+image.Width div 2;
    pula.y:=image.Top+image.Height;
    end;
  3:begin
    pula.x:=image.Left;
    pula.y:=image.Top+image.Height div 2;
    end;
  end;
  pula.image.Visible:=image.Visible;
pula.direction:=GetDirection;
pula.image.Left:=pula.x-pula.image.width div 2;
pula.image.top :=pula.y-pula.image.Height div 2;
end;
end;

procedure Ttank.PulaStart;
begin
pula.image.Enabled:=true;
end;

procedure Ttank.PulaStop;
begin
pula.image.Enabled:=false;
PulaHome;
end;

procedure Ttank.PulaMove;
begin
if pula.image.Enabled then
with pula do
case direction of
    0:image.top :=image.top  - speed;
    1:image.Left:=image.Left + speed;
    2:image.top :=image.top  + speed;
    3:image.Left:=image.Left - speed;
    end;
end;

function Ttank.PulaCheckPole(const img,free:TImage;
                             const pole:tpole;const sw,sh:byte):boolean;
var
y,x:integer;
r1,r2:trect;
begin
result:=false;
if pula.image.Enabled then
begin//start

if ((pula.image.Top)<=0)or
   ((pula.image.left)<=0)or
   ((pula.image.Top +pula.image.Height)div sh>length(pole)-1)or
   ((pula.image.left+pula.image.width )div sw>length(pole[0])-1)
then result:=true
else
begin
  for y:=pula.image.Top div sh to (pula.image.Top+pula.image.Height) div sh do
  for x:=pula.image.left div sw to (pula.image.left+pula.image.width) div sw do
    begin
      if pole[y][x]='1' then result:=true else
        if pole[y][x]='2' then
        begin
        pole[y][x]:='0';
            r1.Left:=x*sw;          r2.Left:=0;
            r1.top:=y*sh;           r2.top:=0;
            r1.Right:=x*sw+sw;      r2.Right:=free.Width;
            r1.Bottom:=y*sh+sh;     r2.Bottom:=free.Height;
        img.Canvas.CopyRect(r1,free.Canvas,r2);
        result:=true;
        end;
    end;
end;
end;//start
end;

function Ttank.PulaCheckObject(const obj: timage): boolean;
var
pt:array [0..3]of tpoint;
z:integer;
begin
result:=false;
if (obj.Visible)and(pula.image.Visible) then
begin
  pt[0].X:=pula.image.Left;
  pt[0].Y:=pula.image.Top;

  pt[1].X:=pula.image.Left+pula.image.Width;
  pt[1].Y:=pula.image.Top;

  pt[2].X:=pula.image.Left+pula.image.Width;
  pt[2].Y:=pula.image.Top+pula.image.Height;

  pt[3].X:=pula.image.Left;
  pt[3].Y:=pula.image.Top+pula.image.Height;

  for z:=0 to 4 do
  if (pt[z].x<=(obj.Left+obj.width ))and
     (pt[z].x>= obj.Left)and
     (pt[z].y<=(obj.top +obj.Height))and
     (pt[z].y>= obj.top )then result:=true;
end;
end;

procedure Ttank.smartDirTo(const obj:Ttank);
var
pt:array [0..3]of tpoint;
centr:tpoint;
begin
if (obj.image.Visible)and(image.Visible) then
begin
  pt[0].X:=obj.image.Left;
  pt[0].Y:=obj.image.Top;

  pt[1].X:=obj.image.Left+image.Width;
  pt[1].Y:=obj.image.Top;

  pt[2].X:=obj.image.Left+image.Width;
  pt[2].Y:=obj.image.Top+image.Height;

  pt[3].X:=obj.image.Left;
  pt[3].Y:=obj.image.Top+image.Height;

  centr.X:=image.Left+image.Width  div 2;
  centr.y:=image.top +image.Height div 2;

  if (centr.X>=pt[0].X)and(centr.X<=pt[1].X) then
    if (centr.Y<pt[0].Y) then
                         begin
                          SetDirection(2);// 
                          PulaStart;
                         end
                         else
                         begin
                         SetDirection(0);// 
                         PulaStart;
                         end;

  if (centr.y>=pt[1].y)and(centr.y<=pt[2].y) then
    if (centr.x<pt[0].x) then
                         begin
                         SetDirection(1);// 
                         PulaStart;
                         end
                         else
                         begin
                         SetDirection(3);// 
                         PulaStart;
                         end;
end;
end;

function Ttank.tankCheckObject(const obj: timage): boolean;
var
pt:array [0..3]of tpoint;
z:integer;
begin
result:=false;
if (obj.Visible)and(image.Visible) then
begin// 
  pt[0].X:=image.Left;
  pt[0].Y:=image.Top;

  pt[1].X:=image.Left+image.Width;
  pt[1].Y:=image.Top;

  pt[2].X:=image.Left+image.Width;
  pt[2].Y:=image.Top+image.Height;

  pt[3].X:=image.Left;
  pt[3].Y:=image.Top+image.Height;

  for z:=0 to 3 do
  if (pt[z].x<=(obj.Left+obj.width ))and
     (pt[z].x>= obj.Left)and
     (pt[z].y<=(obj.top +obj.Height))and
     (pt[z].y>= obj.top )then result:=true;
end;
end;

end.

