unit Unit4;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ComCtrls, ExtCtrls, DB, DBTables;

type
  TLech = class(TForm)
    Panel1: TPanel;
    GroupBox1: TGroupBox;
    GroupBox2: TGroupBox;
    ListBox1: TListBox;
    ListBox2: TListBox;
    Label1: TLabel;
    DateTimePicker1: TDateTimePicker;
    Label2: TLabel;
    Edit1: TEdit;
    Panel2: TPanel;
    Button1: TButton;
    Button2: TButton;
    Query1: TQuery;
    procedure FormCreate(Sender: TObject);
  private
    procedure fillList;
  public               
    procedure setRec(dia, bol, lech: string; dt: TDateTime);
    function dia_id: string;
    function bol_id: string;
  end;

implementation

{$R *.dfm}

{ TLech }

procedure TLech.fillList;
begin
    ListBox1.Clear;
    Query1.Active := false;
    Query1.SQL.Clear;
    Query1.SQL.Add('SELECT * FROM dia.db');
    Query1.Active := true;
    Query1.First;
    while not Query1.Eof do begin
        ListBox1.Items.Add(Query1.FieldByName('diagnoz').AsString);
        Query1.Next;
    end;

    ListBox2.Clear;
    Query1.Active := false;
    Query1.SQL.Clear;
    Query1.SQL.Add('SELECT * FROM bol.db');
    Query1.Active := true;
    Query1.First;
    while not Query1.Eof do begin
        ListBox2.Items.Add(Query1.FieldByName('Name').AsString);
        Query1.Next;
    end;

    if ListBox1.Items.Count > 0 then ListBox1.ItemIndex := 0;
    if ListBox2.Items.Count > 0 then ListBox2.ItemIndex := 0;
end;

procedure TLech.setRec(dia, bol, lech: string; dt: TDateTime);
begin
    ListBox1.ItemIndex := ListBox1.Items.IndexOf(dia);
    ListBox2.ItemIndex := ListBox2.Items.IndexOf(bol);
    Edit1.Text := lech;
    DateTimePicker1.DateTime := dt;
end;

function TLech.dia_id: string;
begin
    Result := '-1';
    if ListBox1.ItemIndex >= 0 then begin
      Query1.Active := false;
      Query1.SQL.Clear;
      Query1.SQL.Add('SELECT * FROM dia.db');
      Query1.SQL.Add('WHERE Diagnoz=''' + ListBox1.Items[ListBox1.ItemIndex] + '''');
      Query1.Active := true;
      Query1.First;
      Result := Query1.FieldByName('ID').AsString;
    end;
end;

function TLech.bol_id: string;
begin
    Result := '-1';
    if ListBox2.ItemIndex >= 0 then begin
      Query1.Active := false;
      Query1.SQL.Clear;
      Query1.SQL.Add('SELECT * FROM bol.db');
      Query1.SQL.Add('WHERE Name=''' + ListBox2.Items[ListBox2.ItemIndex] + '''');
      Query1.Active := true;
      Query1.First;
      Result := Query1.FieldByName('ID').AsString;
    end;
end;

procedure TLech.FormCreate(Sender: TObject);
begin
    fillList;
end;

end.
