unit UUtils;

interface

uses
  SysUtils, Classes;

type
  TRowColCount = 0..15;

  TMatrix = record
    rowCount: TRowColCount;
    colCount: TRowColCount;
    matrix:    array[TRowColCount, TRowColCount] of real;
            end;
  procedure GridInit(const grid: TObject; const matrix: TMatrix);

implementation

uses
  Grids;

procedure GridInit(const grid: TObject; const matrix: TMatrix);
var
  i, j: integer;
  g: TStringGrid;
begin
  g := grid as TStringGrid;
  g.ColCount := matrix.colCount;
  g.RowCount := matrix.rowCount;
  for i := 0 to matrix.rowCount do
    for j := 0 to matrix.colCount do
      (grid as TStringGrid).Cells[j, i] :=
        Format('%8.4f', [matrix.Matrix[i, j]]);
end;


end.
