unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls, ComCtrls, Grids,
  UUtils;

type
  TStartForm = class(TForm)
    Menu: TMainMenu;
    File1: TMenuItem;
    Exit1: TMenuItem;
    Method: TMenuItem;
    N1: TMenuItem;
    N2: TMenuItem;
    gbSize: TGroupBox;
    Label2: TLabel;
    Label3: TLabel;
    EcolCount: TEdit;
    UpDownCol: TUpDown;
    CreateButton: TButton;
    ErowCount: TEdit;
    UpDownRow: TUpDown;
    N3: TMenuItem;
    N4: TMenuItem;
    procedure Exit1Click(Sender: TObject);
    procedure CreateButtonClick(Sender: TObject);
    procedure N1Click(Sender: TObject);
    procedure N2Click(Sender: TObject);
    procedure N3Click(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure N4Click(Sender: TObject);
  private
    BaseGrid:   TStringGrid;
    procedure BaseGridInit();
    procedure BaseMatrixInit();
    procedure _Init();
  public
    BaseMatrix: TMatrix;
  end;

var
  StartForm: TStartForm;

implementation

uses Unit2, Unit3, Unit4, Unit6;

{$R *.dfm}

procedure TStartForm.Exit1Click(Sender: TObject);
begin
  Application.Terminate;
end;

procedure TStartForm.FormCreate(Sender: TObject);
begin
  DecimalSeparator := '.';
end;

procedure TStartForm.CreateButtonClick(Sender: TObject);
begin
  FreeAndNil(BaseGrid);

  BaseGridInit();
  Menu.Items.Items[Menu.Items.IndexOf(Method)].Enabled := true;
  _Init();

end;

procedure TStartForm.BaseGridInit();
begin
  BaseGrid := TStringGrid.Create(Self);
  with BaseGrid do begin
    Top := gbSize.Top + gbSize.Height + 10;
    Left := 10;
    Parent := Self;
    FixedCols := 0;
    FixedRows := 0;
    DefaultRowHeight := 20;
    RowCount := StrToInt(ErowCount.Text);
    ColCount := StrToInt(EcolCount.Text);
    Width := ColCount * (DefaultColWidth + 2) + 8;
    Height := RowCount * (DefaultRowHeight + 2) + 8;
    Options := Options + [goEditing, goAlwaysShowEditor];
  end;
end;

procedure TStartForm.BaseMatrixInit();
var
  i, j: integer;
begin
  BaseMatrix.rowCount := BaseGrid.RowCount;
  BaseMatrix.colCount := BaseGrid.ColCount;

  for i := 0 to BaseMatrix.rowCount - 1 do
    for j := 0 to BaseMatrix.colCount - 1 do
      if( BaseGrid.Cells[j, i] = '' ) then
        BaseMatrix.Matrix[i, j] := 0.0
      else
        BaseMatrix.Matrix[i, j] := StrToFloat(BaseGrid.Cells[j, i]);
end;

procedure TStartForm._Init();
var
  i, j: integer;
begin
  BaseMatrix.Matrix[0, 0] := 8.22;
  BaseMatrix.Matrix[0, 1] := 1.42;
  BaseMatrix.Matrix[0, 2] := -1.72;
  BaseMatrix.Matrix[0, 3] := 1.91;
  BaseMatrix.Matrix[0, 4] := 7.53;

  BaseMatrix.Matrix[1, 0] := 1.42;
  BaseMatrix.Matrix[1, 1] := 7.33;
  BaseMatrix.Matrix[1, 2] := 1.11;
  BaseMatrix.Matrix[1, 3] := -1.82;
  BaseMatrix.Matrix[1, 4] := 6.06;

  BaseMatrix.Matrix[2, 0] := -1.72;
  BaseMatrix.Matrix[2, 1] := 1.11;
  BaseMatrix.Matrix[2, 2] := 7.24;
  BaseMatrix.Matrix[2, 3] := 1.42;
  BaseMatrix.Matrix[2, 4] := 8.05;

  BaseMatrix.Matrix[3, 0] := 1.91;
  BaseMatrix.Matrix[3, 1] := -1.82;
  BaseMatrix.Matrix[3, 2] := 1.42;
  BaseMatrix.Matrix[3, 3] := 8.55;
  BaseMatrix.Matrix[3, 4] := 8.06;

  for i := 0 to 3 do
    for j := 0 to 4 do
      BaseGrid.Cells[j, i] := FloatToStr(BaseMatrix.Matrix[i, j]);
end;

procedure TStartForm.N1Click(Sender: TObject);
begin
  BaseMatrixInit();
  with TForm2.Create(Application) do begin
    Init(BaseMatrix);
    StartForm.Hide;
  end;
end;

procedure TStartForm.N2Click(Sender: TObject);
begin
  BaseMatrixInit();
  with TForm3.Create(Application) do begin
    Init(BaseMatrix);
    StartForm.Hide;
  end;
end;

procedure TStartForm.N3Click(Sender: TObject);
begin
  BaseMatrixInit();
  with TForm4.Create(Application) do begin
    Init(BaseMatrix);
    StartForm.Hide;
  end;
end;

procedure TStartForm.N4Click(Sender: TObject);
begin
  StartForm.hide;
  Form6.Show;
end;
end.
