unit Unit2;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, Menus, StdCtrls, Grids,
  UUtils;

type
  TForm2 = class(TForm)
    MainMenu1: TMainMenu;
    File1:     TMenuItem;
    Exit1:     TMenuItem;
    EApprox: TEdit;
    BPricision: TButton;
    Label1: TLabel;

    procedure Exit1Click(Sender: TObject);
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure BPricisionClick(Sender: TObject);
    procedure EApproxKeyUp(
      Sender: TObject; var Key: Word; Shift: TShiftState);
  private
    BaseGrid:   TStringGrid;
    Grid1:      TStringGrid;
    Grid2:      TStringGrid;
    BaseMatrix: TMatrix;
    Matrix1:    TMatrix;

    currRow:   array[0..15] of real;
    lastRow:   array[0..15] of real;

    approx: real;

    function GridCreate(rCount, cCount, t: integer): TStringGrid;
    procedure Grid2Create();

    procedure MethodStart();
    procedure Matrix1Init();
    function ProofConvergence(): boolean;
    function ProofPricision(): boolean;
    procedure Approach();
    procedure AddRow();
  public
    procedure Init(matrix: TMatrix);
  end;

var
  Form2: TForm2;


implementation

uses Math, Unit1;


procedure TForm2.Init(matrix: TMatrix);
begin
  Show;
  BPricision.Visible := false;
  BPricision.Enabled := false;
  EApprox.Visible := false;
  EApprox.Enabled := false;
  Label1.Visible := false;
  EApprox.Text := '';

  BaseMatrix := matrix;
  BaseGrid := GridCreate(matrix.rowCount, matrix.colCount, 10);
  GridInit(BaseGrid, BaseMatrix);
  MethodStart();
end;

function TForm2.GridCreate(rCount, cCount, t: integer): TStringGrid;
begin
  Result := TStringGrid.Create(Self);
  with Result do begin
    Parent := Self;
    Top := t;
    Left := 10;
    FixedCols := 0;
    FixedRows := 0;
    RowCount := rCount;
    ColCount := cCount;
    Width := ColCount * (DefaultColWidth + 3);
    Height := RowCount * (DefaultRowHeight + 3);
    Options := Options - [goEditing];
  end;
end;

procedure TForm2.Grid2Create();
var
  i: integer;
begin
  FreeAndNil(Grid2);
  Grid2 :=
    GridCreate(2, Matrix1.colCount, BPricision.Top + BPricision.Height + 10);
  with Grid2 do begin
    FixedCols := 1;
    FixedRows := 1;
    Cells[0, 0] := 'k';
    Cells[0, 1] := '1';
    for i := 1 to Matrix1.colCount - 1 do
      Cells[i, 0] := 'x' + IntToStr(i);
  end;
end;

procedure TForm2.MethodStart();
var
  t: integer;
begin
  Matrix1Init();
  t := BaseGrid.Top + BaseGrid.Height + 10;
  Grid1 := GridCreate(Matrix1.rowCount, Matrix1.colCount, t);
  GridInit(Grid1, Matrix1);
  if not ProofConvergence() then
    ShowMessage('   ')
  else begin
    EApprox.Top := Grid1.Top + Grid1.Height + 10;
    Label1.Top := Grid1.Top + Grid1.Height + 10;
    BPricision.Top := EApprox.Top + EApprox.Height + 10;
    Label1.Visible := true;
    EApprox.Visible := true;
    EApprox.Enabled := true;
    BPricision.Visible := true;
  end;
end;

procedure TForm2.Matrix1Init();
var
  i, j: integer;
begin
  Matrix1 := BaseMatrix;

  for i := 0 to Matrix1.rowCount - 1 do
    Matrix1.Matrix[i, i] := 0.0;

  for i := 0 to Matrix1.rowCount - 1 do
    for j := 0 to Matrix1.colCount - 2 do
      Matrix1.Matrix[i, j] := -Matrix1.Matrix[i, j] / BaseMatrix.Matrix[i, i];

  for i := 0 to Matrix1.rowCount - 1 do
    Matrix1.Matrix[i, Matrix1.colCount - 1] :=
      Matrix1.Matrix[i, Matrix1.colCount - 1] /
      BaseMatrix.Matrix[i, i];
end;

function TForm2.ProofConvergence(): boolean;
var
  i, j: integer;
  sum: real;
begin
  result := true;
  for i := 0 to Matrix1.rowCount - 1 do begin
    sum := 0;
    for j := 0 to Matrix1.colCount - 2 do
      sum := sum + abs(Matrix1.Matrix[i, j]);

    if( sum > 1 ) then begin
      result := false;
      break;
    end;
  end;
end;

procedure TForm2.Approach();
var
  i, j:integer;
begin
  Grid2Create();
  for i := 0 to Matrix1.rowCount - 1 do
    currRow[i] := Matrix1.Matrix[i, Matrix1.colCount - 1];

  repeat
    AddRow();
    for i := 0 to Matrix1.rowCount - 1 do
    begin
      LastRow[i] := CurrRow[i];
      CurrRow[i] := 0.0;
    end;

    for i := 0 to 3 do begin
      CurrRow[i] := Matrix1.Matrix[i, Matrix1.colCount - 1];
      for j := 0 to Matrix1.rowCount - 1 do
        CurrRow[i] := CurrRow[i] + Matrix1.Matrix[i, j] * LastRow[j];
    end;
  until (not(ProofPricision()) );
end;

procedure TForm2.AddRow();
var
  i: integer;
begin
  Grid2.Cells[0, Grid2.RowCount - 1] := IntToStr(Grid2.RowCount - 1);
  Grid2.RowCount := Grid2.RowCount + 1;
  for i := 1 to Matrix1.colCount - 1 do
    Grid2.Cells[i, Grid2.rowCount - 2] := Format('%8.6f', [currRow[i - 1]]);
  Grid2.Height :=  Grid2.RowCount * (Grid2.DefaultRowHeight + 3);
end;

function TForm2.ProofPricision(): boolean;
var
  i: integer;
begin
  result := true;
  for i := 0 to Matrix1.rowCount - 1 do
    if ( abs(CurrRow[i] - LastRow[i]) ) < approx then
    begin
      result := false;
      break;
    end;
end;

{$R *.dfm}

procedure TForm2.Exit1Click(Sender: TObject);
begin
  StartForm.Exit1Click(Exit1);
end;

procedure TForm2.FormClose(Sender: TObject; var Action: TCloseAction);
begin
  FreeAndNil(BaseGrid);
  FreeAndNil(Grid1);
  FreeAndNil(Grid2);
  Application.MainForm.Show;
end;


procedure TForm2.BPricisionClick(Sender: TObject);
begin
  Approx := StrToFloat(EApprox.Text);
  Approach();
end;

procedure TForm2.EApproxKeyUp(
  Sender: TObject; var Key: Word; Shift: TShiftState);
begin
  BPricision.Enabled := not (((EApprox.Text = '') or (EApprox.Text = '0')));
end;

end.

